/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.geotools.api.filter.expression.Literal;
import org.geotools.filter.text.commons.BuildResultStack;
import org.geotools.filter.text.commons.Result;
import org.geotools.filter.text.cql2.CQLException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

abstract class GeometryBuilder {
    private BuildResultStack resultStack;
    private String statement;

    public GeometryBuilder(String statement, BuildResultStack resultStack) {
        assert (statement != null);
        assert (resultStack != null);
        this.statement = statement;
        this.resultStack = resultStack;
    }

    protected String getStatemet() {
        return this.statement;
    }

    protected GeometryFactory getGeometryFactory() {
        return new GeometryFactory();
    }

    protected BuildResultStack getResultStack() {
        return this.resultStack;
    }

    public Geometry build() throws CQLException {
        throw new UnsupportedOperationException("should be implemented by subclass");
    }

    public Geometry build(int idNode) throws CQLException {
        throw new UnsupportedOperationException("should be implemented by subclass");
    }

    protected Coordinate[] asCoordinate(Stack<Coordinate> stack) {
        int size = stack.size();
        Coordinate[] coordinates = new Coordinate[size];
        int i = 0;
        while (!stack.empty()) {
            coordinates[i++] = stack.pop();
        }
        return coordinates;
    }

    protected Stack<Coordinate> popCoordinatesOf(int geomNode) throws CQLException {
        Result result;
        int node;
        Stack<Coordinate> stack = new Stack<Coordinate>();
        while (!this.getResultStack().empty() && (node = (result = this.getResultStack().peek()).getNodeType()) == geomNode) {
            this.getResultStack().popResult();
            Coordinate coordinate = (Coordinate)result.getBuilt();
            stack.push(coordinate);
        }
        return stack;
    }

    protected List<Geometry> popGeometry(int geometryNode) throws CQLException {
        Result result;
        LinkedList<Geometry> geomList = new LinkedList<Geometry>();
        while (!this.getResultStack().empty() && (result = this.getResultStack().peek()).getNodeType() == geometryNode) {
            this.getResultStack().popResult();
            Geometry geometry = (Geometry)result.getBuilt();
            geomList.add(geometry);
        }
        Collections.reverse(geomList);
        return geomList;
    }

    protected List<Geometry> popGeometryLiteral(int geometryNode) throws CQLException {
        Result result;
        LinkedList<Geometry> geomList = new LinkedList<Geometry>();
        while (!this.getResultStack().empty() && (result = this.getResultStack().peek()).getNodeType() == geometryNode) {
            this.getResultStack().popResult();
            Literal geometry = (Literal)result.getBuilt();
            geomList.add((Geometry)geometry.getValue());
        }
        Collections.reverse(geomList);
        return geomList;
    }
}

