/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import java.util.HashMap;
import java.util.Map;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.factory.CommonFactoryFinder;

public final class FilterECQLSample {
    protected static final FilterFactory FACTORY = CommonFactoryFinder.getFilterFactory(null);
    public static final String ABS_FUNCTION_LESS_PROPERTY = "abs(10) < aProperty";
    public static final String AREA_FUNCTION_LESS_NUMBER = "area( the_geom ) < 30000";
    public static final String EXPRESION_GREATER_PROPERTY = "(1+3) > aProperty";
    public static final String FUNCTION_LESS_SIMPLE_ADD_EXPR = "area( the_geom ) < (1+3)";
    public static final String FUNC_AREA_LESS_FUNC_ABS = "area( the_geom ) < abs(10)";
    public static final String ADD_EXPRESION_GREATER_SUBTRACT_EXPRESION = "(1+3) > (4-5)";
    public static final String PROPERTY_GREATER_MINUS_INGEGER = "aProperty > -1";
    public static final String MINUS_INTEGER_GREATER_PROPERTY = "-1 > aProperty";
    public static final String PROPERTY_GREATER_MINUS_FLOAT = "aProperty > -1.05";
    public static final String MINUS_FLOAT_GREATER_PROPERTY = "-1.05 > aProperty";
    public static final String MINUS_EXPR_GREATER_PROPERTY = "-1.05 + 4.6 > aProperty";
    public static final String PROPERTY_GREATER_MINUS_EXPR = "aProperty > -1.05 + 4.6";
    public static final String PROPERTY_GREATER_NESTED_EXPR = "-1.05 + (-4.6* -10) > aProperty";
    public static final String MINUS_MINUS_EXPR_GRATER_PROPERTY = "10--1.05 > aProperty";
    public static final String FUNCTION_LIKE_ECQL_PATTERN = "strConcat('aa', 'bbcc') like '%bb%'";
    public static final String LITERAL_LIKE_ECQL_PATTERN = "'aabbcc' LIKE '%bb%'";
    public static final String LITERAL_NOT_LIKE_ECQL_PATTERN = "'aabbcc' not like '%bb%'";
    public static final String LITERAL_BETWEEN_TWO_LITERALS = "2 between 1 and 3";
    public static final String LITERAL_BETWEEN_TWO_EXPRESSIONS = "2 BETWEEN (2-1) AND (2+1)";
    public static final String FUNCTION_BETWEEN_LITERALS = "area( the_geom ) BETWEEN 10000 AND 30000";
    public static final String FUNCTION_BETWEEN_FUNCTIONS = "area( the_geom ) BETWEEN abs(10000) AND abs(30000)";
    public static final String FUNCTION_IS_NULL = "centroid( the_geom ) IS NULL";
    public static final String FUNCTION_IS_NOT_NULL = "centroid( the_geom ) IS NOT NULL";
    public static final String EXPRESSIONS_WITH_PROPERTIES = "(x+4) > (y - 5)";
    public static Map<String, Object> SAMPLES = new HashMap<String, Object>();

    public static Filter getSample(String predcateRequested) {
        Filter sample = (Filter)SAMPLES.get(predcateRequested);
        assert (sample != null) : "There is not a sample for " + predcateRequested;
        return sample;
    }

    static {
        Add simpleAddExpression = FACTORY.add((Expression)FACTORY.literal(1), (Expression)FACTORY.literal(3));
        PropertyIsGreaterThan filter = FACTORY.greater((Expression)simpleAddExpression, (Expression)FACTORY.property("aProperty"));
        SAMPLES.put(EXPRESION_GREATER_PROPERTY, filter);
        Expression[] absArgs = new Expression[]{FACTORY.literal(10)};
        Function abs = FACTORY.function("abs", absArgs);
        filter = FACTORY.less((Expression)abs, (Expression)FACTORY.property("aProperty"));
        SAMPLES.put(ABS_FUNCTION_LESS_PROPERTY, filter);
        Expression[] areaArgs = new Expression[]{FACTORY.property("the_geom")};
        Function area = FACTORY.function("area", areaArgs);
        filter = FACTORY.less((Expression)area, (Expression)FACTORY.literal(30000));
        SAMPLES.put(AREA_FUNCTION_LESS_NUMBER, filter);
        filter = FACTORY.less((Expression)area, (Expression)simpleAddExpression);
        SAMPLES.put(FUNCTION_LESS_SIMPLE_ADD_EXPR, filter);
        filter = FACTORY.less((Expression)area, (Expression)abs);
        SAMPLES.put(FUNC_AREA_LESS_FUNC_ABS, filter);
        Subtract simpleSubtractExpression = FACTORY.subtract((Expression)FACTORY.literal(4), (Expression)FACTORY.literal(5));
        filter = FACTORY.greater((Expression)simpleAddExpression, (Expression)simpleSubtractExpression);
        SAMPLES.put(ADD_EXPRESION_GREATER_SUBTRACT_EXPRESION, filter);
        Add plusToProp = FACTORY.add((Expression)FACTORY.property("x"), (Expression)FACTORY.literal(4));
        Subtract subtractToProp = FACTORY.subtract((Expression)FACTORY.property("y"), (Expression)FACTORY.literal(5));
        filter = FACTORY.greater((Expression)plusToProp, (Expression)subtractToProp);
        SAMPLES.put(EXPRESSIONS_WITH_PROPERTIES, filter);
        Literal minusOne = FACTORY.literal(-1);
        PropertyName aProperty = FACTORY.property("aProperty");
        filter = FACTORY.greater((Expression)aProperty, (Expression)minusOne);
        SAMPLES.put(PROPERTY_GREATER_MINUS_INGEGER, filter);
        filter = FACTORY.greater((Expression)minusOne, (Expression)aProperty);
        SAMPLES.put(MINUS_INTEGER_GREATER_PROPERTY, filter);
        Literal minusFloat = FACTORY.literal(-1.05);
        filter = FACTORY.greater((Expression)aProperty, (Expression)minusFloat);
        SAMPLES.put(PROPERTY_GREATER_MINUS_FLOAT, filter);
        filter = FACTORY.greater((Expression)minusFloat, (Expression)aProperty);
        SAMPLES.put(MINUS_FLOAT_GREATER_PROPERTY, filter);
        Add exprWithMinus = FACTORY.add((Expression)FACTORY.literal(-1.05), (Expression)FACTORY.literal(4.6));
        filter = FACTORY.greater((Expression)exprWithMinus, (Expression)aProperty);
        SAMPLES.put(MINUS_EXPR_GREATER_PROPERTY, filter);
        filter = FACTORY.greater((Expression)aProperty, (Expression)exprWithMinus);
        SAMPLES.put(PROPERTY_GREATER_MINUS_EXPR, filter);
        Add nestedExpr = FACTORY.add((Expression)FACTORY.literal(-1.05), (Expression)FACTORY.multiply((Expression)FACTORY.literal(-4.6), (Expression)FACTORY.literal(-10)));
        filter = FACTORY.greater((Expression)nestedExpr, (Expression)aProperty);
        SAMPLES.put(PROPERTY_GREATER_NESTED_EXPR, filter);
        Subtract subtractExpr = FACTORY.subtract((Expression)FACTORY.literal(10), (Expression)FACTORY.literal(-1.05));
        filter = FACTORY.greater((Expression)subtractExpr, (Expression)aProperty);
        SAMPLES.put(MINUS_MINUS_EXPR_GRATER_PROPERTY, filter);
        Expression[] strConcatArgs = new Expression[]{FACTORY.literal((Object)"aa"), FACTORY.literal((Object)"bbcc")};
        Function strConcat = FACTORY.function("strConcat", strConcatArgs);
        filter = FACTORY.like((Expression)strConcat, "%bb%");
        SAMPLES.put(FUNCTION_LIKE_ECQL_PATTERN, filter);
        PropertyIsLike like = FACTORY.like((Expression)FACTORY.literal((Object)"aabbcc"), "%bb%", "%", "?", "\\", true);
        SAMPLES.put(LITERAL_LIKE_ECQL_PATTERN, like);
        Not notLike = FACTORY.not((Filter)like);
        SAMPLES.put(LITERAL_NOT_LIKE_ECQL_PATTERN, notLike);
        filter = FACTORY.between((Expression)FACTORY.literal(2), (Expression)FACTORY.literal(1), (Expression)FACTORY.literal(3));
        SAMPLES.put(LITERAL_BETWEEN_TWO_LITERALS, filter);
        filter = FACTORY.between((Expression)FACTORY.literal(2), (Expression)FACTORY.subtract((Expression)FACTORY.literal(2), (Expression)FACTORY.literal(1)), (Expression)FACTORY.add((Expression)FACTORY.literal(2), (Expression)FACTORY.literal(1)));
        SAMPLES.put(LITERAL_BETWEEN_TWO_EXPRESSIONS, filter);
        filter = FACTORY.between((Expression)area, (Expression)FACTORY.literal(10000), (Expression)FACTORY.literal(30000));
        SAMPLES.put(FUNCTION_BETWEEN_LITERALS, filter);
        Expression[] abs1Args = new Expression[]{FACTORY.literal(10000)};
        Function abs1 = FACTORY.function("abs", abs1Args);
        Expression[] abs2Args = new Expression[]{FACTORY.literal(30000)};
        Function abs2 = FACTORY.function("abs", abs2Args);
        filter = FACTORY.between((Expression)area, (Expression)abs1, (Expression)abs2);
        SAMPLES.put(FUNCTION_BETWEEN_FUNCTIONS, filter);
        Expression[] centroidArgs = new Expression[]{FACTORY.property("the_geom")};
        Function centroid = FACTORY.function("centroid", centroidArgs);
        PropertyIsNull isNullFilter = FACTORY.isNull((Expression)centroid);
        SAMPLES.put(FUNCTION_IS_NULL, isNullFilter);
        Not notIsNullFilter = FACTORY.not((Filter)isNullFilter);
        SAMPLES.put(FUNCTION_IS_NOT_NULL, notIsNullFilter);
    }
}

