/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.FilterCQLSample;
import org.junit.Assert;
import org.junit.Test;

public class CQLComparisonPredicateTest {
    protected final Language language;

    public CQLComparisonPredicateTest() {
        this(Language.CQL);
    }

    protected CQLComparisonPredicateTest(Language language) {
        assert (language != null) : "language cannot be null value";
        this.language = language;
    }

    @Test
    public void comparisonOperators() throws Exception {
        Filter expected = FilterCQLSample.getSample("ATTR1 < 1");
        Filter actual = this.parseFilter("ATTR1 < 1");
        Assert.assertNotNull((String)"expects filter not null", (Object)actual);
        Assert.assertEquals((String)"less than compare filter error", (Object)expected, (Object)actual);
        expected = FilterCQLSample.getSample("ATTR1 <= 1");
        actual = this.parseFilter("ATTR1 <= 1");
        Assert.assertNotNull((String)"expects filter not null", (Object)actual);
        Assert.assertEquals((String)"less or equal compare filter error", (Object)expected, (Object)actual);
        expected = FilterCQLSample.getSample("ATTR1 <> 1");
        actual = this.parseFilter("ATTR1 <> 1");
        Assert.assertNotNull((String)"expects filter not null", (Object)actual);
        Assert.assertEquals((String)"not equal compare filter error", (Object)expected, (Object)actual);
        expected = FilterCQLSample.getSample("ATTR1 = 1");
        actual = this.parseFilter("ATTR1 = 1");
        Assert.assertNotNull((String)"expects filter not null", (Object)actual);
        Assert.assertEquals((String)"equal compare filter error", (Object)expected, (Object)actual);
    }

    protected Filter parseFilter(String filter) throws CQLException {
        return CompilerUtil.parseFilter((Language)this.language, (String)filter);
    }

    @Test
    public void deprecatedPredicate() throws Exception {
        CQL.toFilter((String)"POP_RANK eq 6");
        CQL.toFilter((String)"POP_RANK neq 6");
        CQL.toFilter((String)"POP_RANK lte 6");
        CQL.toFilter((String)"! (POP_RANK = 6)");
    }

    @Test
    public void attributeName() throws Exception {
        String prop = "gmd:aa:bb.gmd:cc.gmd:dd";
        String propExpected = "gmd:aa:bb/gmd:cc/gmd:dd";
        Filter actual = this.parseFilter("gmd:aa:bb.gmd:cc.gmd:dd < 100");
        Assert.assertTrue((String)"PropertyIsLessThan filter was expected", (boolean)(actual instanceof PropertyIsLessThan));
        PropertyIsLessThan lessFilter = (PropertyIsLessThan)actual;
        Expression property = lessFilter.getExpression1();
        Assert.assertEquals((Object)"gmd:aa:bb/gmd:cc/gmd:dd", (Object)property.toString());
    }

    @Test
    public void propertyComparisonSimpleExpressions() throws Exception {
        Filter expected = FilterCQLSample.getSample("ATTR1 > 1 + 2");
        Filter actual = this.parseFilter("ATTR1 > 1 + 2");
        Assert.assertNotNull((String)"expects filter not null", (Object)actual);
        Assert.assertEquals((String)"not equal compare filter error", (Object)expected, (Object)actual);
    }

    @Test
    public void booleanLiteral() throws Exception {
        Filter filter = this.parseFilter("attr = true");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eqFilter = (PropertyIsEqualTo)filter;
        Assert.assertEquals((Object)"attr", (Object)((PropertyName)eqFilter.getExpression1()).getPropertyName());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((Literal)eqFilter.getExpression2()).getValue());
        filter = this.parseFilter("attr = false");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        eqFilter = (PropertyIsEqualTo)filter;
        Assert.assertEquals((Object)"attr", (Object)((PropertyName)eqFilter.getExpression1()).getPropertyName());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)((Literal)eqFilter.getExpression2()).getValue());
    }

    @Test
    public void longLiteral() throws Exception {
        String expectedValue = Long.toString(Long.MAX_VALUE);
        Filter filter = this.parseFilter("attr = " + expectedValue);
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eqFilter = (PropertyIsEqualTo)filter;
        Assert.assertEquals((Object)"attr", (Object)((PropertyName)eqFilter.getExpression1()).getPropertyName());
        Assert.assertEquals((Object)Long.parseLong(expectedValue), (Object)((Literal)eqFilter.getExpression2()).getValue());
    }

    @Test
    public void parenRoundtripExpression() throws Exception {
        this.testEqualsExpressions("ATTR1 > ((1 + 2) / 3)");
        this.testEqualsExpressions("ATTR1 < (1 + ((2 / 3) * 4))");
    }

    @Test
    public void bracketRoundtripFilter() throws Exception {
        this.testEqualsExpressions("ATTR1 > [[1 + 2] / 3]");
        Filter f1 = this.parseFilter("[[[ X < 4 ] AND NOT [ Y < 4 ]] AND [ Z < 4 ]]");
        Assert.assertTrue((boolean)(f1 instanceof And));
        Filter f2 = this.parseFilter("[X<4 AND Y<4 ] OR Z<4");
        Or orf2 = (Or)f2;
        Filter leftf2 = (Filter)orf2.getChildren().get(0);
        Assert.assertTrue((boolean)(leftf2 instanceof And));
        Filter rightf2 = (Filter)orf2.getChildren().get(1);
        Assert.assertTrue((boolean)(rightf2 instanceof PropertyIsLessThan));
        Filter f3 = this.parseFilter("[([ X < 4 ] AND NOT [ Y < 4 ]) AND [ Z < 4 ]]");
        Assert.assertTrue((boolean)(f3 instanceof And));
    }

    private void testEqualsExpressions(String cqlSample) throws Exception {
        Filter expected = FilterCQLSample.getSample(cqlSample);
        Filter actual = this.parseFilter(cqlSample);
        Assert.assertNotNull((String)"expects filter not null", (Object)actual);
        Assert.assertEquals((String)"this is not the filter expected", (Object)expected, (Object)actual);
    }
}

