/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.temporal.Period;
import org.geotools.api.temporal.Position;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.CQLTemporalPredicateTest;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPosition;
import org.junit.Assert;
import org.junit.Test;

public class ECQLTemporalPredicateTest
extends CQLTemporalPredicateTest {
    public ECQLTemporalPredicateTest() {
        super(Language.ECQL);
    }

    @Test
    public void dateTimeExpresionBeforeDateTimeExpresion() throws CQLException {
        String predicate = "2006-11-30T01:00:00Z BEFORE 2006-11-30T01:30:00Z ";
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"2006-11-30T01:00:00Z BEFORE 2006-11-30T01:30:00Z ");
        Assert.assertTrue((boolean)(resultFilter instanceof Before));
        Before lessFilter = (Before)resultFilter;
        Literal expr1 = (Literal)lessFilter.getExpression1();
        Date leftHandDate = (Date)expr1.getValue();
        Assert.assertTrue((boolean)(leftHandDate instanceof Date));
        Literal expr2 = (Literal)lessFilter.getExpression2();
        Date rightHandDate = (Date)expr2.getValue();
        Assert.assertTrue((boolean)(rightHandDate instanceof Date));
        Assert.assertTrue((boolean)resultFilter.evaluate(null));
    }

    @Test
    public void dateTimeExpresionAfterDateTimeExpresion() throws CQLException {
        String predicate = "2006-11-30T01:00:00Z AFTER 2006-11-30T01:30:00Z";
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"2006-11-30T01:00:00Z AFTER 2006-11-30T01:30:00Z");
        Assert.assertTrue((boolean)(resultFilter instanceof After));
        After lessFilter = (After)resultFilter;
        Literal expr1 = (Literal)lessFilter.getExpression1();
        Date leftHandDate = (Date)expr1.getValue();
        Assert.assertTrue((boolean)(leftHandDate instanceof Date));
        Literal expr2 = (Literal)lessFilter.getExpression2();
        Date rightHandDate = (Date)expr2.getValue();
        Assert.assertTrue((boolean)(rightHandDate instanceof Date));
        Assert.assertFalse((boolean)resultFilter.evaluate(null));
    }

    @Test
    public void dateTimeDuringPeriod() throws CQLException {
        String predicate = "2006-11-30T01:00:00Z DURING 2006-11-30T00:30:00Z/2006-11-30T01:30:00Z ";
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"2006-11-30T01:00:00Z DURING 2006-11-30T00:30:00Z/2006-11-30T01:30:00Z ");
        Assert.assertTrue((boolean)(resultFilter instanceof During));
        During lessFilter = (During)resultFilter;
        Literal expr1 = (Literal)lessFilter.getExpression1();
        Assert.assertTrue((boolean)(expr1.getValue() instanceof Date));
        Literal expr2 = (Literal)lessFilter.getExpression2();
        Assert.assertTrue((boolean)(expr2.getValue() instanceof Period));
        Assert.assertTrue((boolean)resultFilter.evaluate(null));
    }

    @Test(expected=CQLException.class)
    public void beforeInvalidLeftHandExpression() throws CQLException {
        String predicate = "(1+2) BEFORE 2006-11-30T01:30:00Z ";
        CompilerUtil.parseFilter((Language)this.language, (String)"(1+2) BEFORE 2006-11-30T01:30:00Z ");
    }

    @Test
    public void filterWithOgcInstantToEcql() throws Exception {
        Date date = new Date();
        FilterFactoryImpl ff = new FilterFactoryImpl();
        After filter = ff.after((Expression)ff.property("attName"), (Expression)ff.literal((Object)new DefaultInstant((Position)new DefaultPosition(date))));
        String cql = ECQL.toCQL((Filter)filter);
        Assert.assertEquals((Object)("attName AFTER " + this.getEcqlCompliantDate(date)), (Object)cql);
    }

    @Test
    public void beforeFilterWithOgcInstantToEcql() throws Exception {
        Date date = new Date();
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Before filter = ff.before((Expression)ff.property("attName"), (Expression)ff.literal((Object)new DefaultInstant((Position)new DefaultPosition(date))));
        String cql = ECQL.toCQL((Filter)filter);
        Assert.assertEquals((Object)("attName BEFORE " + this.getEcqlCompliantDate(date)), (Object)cql);
    }

    private String getEcqlCompliantDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        return formatter.format(date).replace("GMT", "");
    }
}

