/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import org.geotools.filter.text.cql2.FilterToCQLTest;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.text.ecql.FilterToECQL;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

public class FilterToECQLTest
extends FilterToCQLTest {
    @Test
    public void id() throws Exception {
        this.cqlTest("IN (1,2,3,4)");
    }

    @Test
    public void idString() throws Exception {
        this.cqlTest("IN ('foo','bar')");
    }

    @Test
    public void idUUID() throws Exception {
        this.cqlTest("IN ('cb606c93-8642-4cff-84e8-1817e8307097')");
    }

    public void intersectWhithGeomExpressions() throws Exception {
        this.cqlTest("INTERSECTS(POLYGON((1 2, 2 2, 2 3, 1 2)), POINT(1 2))");
    }

    @Test
    public void likeWithFunction() throws Exception {
        this.cqlTest("strConcat('aa','bbcc') LIKE '%bb%'");
    }

    @Override
    protected void cqlTest(String cql) throws Exception {
        Filter filter = ECQL.toFilter((String)cql);
        Assert.assertNotNull((Object)filter);
        FilterToECQL toECQL = new FilterToECQL();
        String output = filter.accept((FilterVisitor)toECQL, null).toString();
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((String)cql, (Object)cql, (Object)output);
    }
}

