/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.CQLGeoOperationTest;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.referencing.FactoryException;

public final class ECQLGeoOperationTest
extends CQLGeoOperationTest {
    public ECQLGeoOperationTest() {
        super(Language.ECQL);
    }

    @Override
    @Test
    public void disjoint() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"DISJOINT(the_geom, POINT(1 2))");
        Assert.assertTrue((String)"Disjoint was expected", (boolean)(resultFilter instanceof Disjoint));
    }

    @Override
    @Test
    public void Intersects() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"INTERSECTS(the_geom, POINT(1 2))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
    }

    @Test
    public void IntersectsWithExpressions() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"INTERSECTS(POLYGON((1 2, 2 2, 2 3, 1 2)), POINT(1 2))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
    }

    @Override
    @Test
    public void touches() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"TOUCHES(the_geom, POINT(1 2))");
        Assert.assertTrue((String)"Touches was expected", (boolean)(resultFilter instanceof Touches));
    }

    @Override
    @Test
    public void crosses() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"CROSSES(the_geom, POINT(1 2))");
        Assert.assertTrue((String)"Crosses was expected", (boolean)(resultFilter instanceof Crosses));
    }

    @Override
    @Test
    public void contains() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"CONTAINS(the_geom, POINT(1 2))");
        Assert.assertTrue((String)"Contains was expected", (boolean)(resultFilter instanceof Contains));
    }

    @Override
    @Test
    public void overlaps() throws Exception {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"OVERLAPS(the_geom, POINT(1 2))");
        Assert.assertTrue((String)"Overlaps was expected", (boolean)(resultFilter instanceof Overlaps));
    }

    @Override
    @Test
    public void equals() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"EQUALS(the_geom, POINT(1 2))");
        Assert.assertTrue((String)"not an instance of Equals", (boolean)(resultFilter instanceof Equals));
    }

    @Test
    public void functionAsFirstArgument() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"INTERSECTS(centroid(the_geom), POINT(1 2))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
    }

    @Test
    public void functionAsSecondArgument() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"INTERSECTS(the_geom, buffer(POINT(1 2),10))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"INTERSECTS(the_geom, buffer(the_geom,10))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
    }

    @Test
    public void functionAsFirstAndSecondArgument() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"INTERSECTS(centroid(the_geom), buffer(POINT(1 2) ,10))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
    }

    @Test
    public void intersectsWithReferencedGeometry() throws CQLException, FactoryException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"INTERSECTS(the_geom, SRID=4326;POINT(1 2))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
        Intersects intersects = (Intersects)resultFilter;
        Literal geomLiteral = (Literal)intersects.getExpression2();
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326", (boolean)true), (Object)((Geometry)geomLiteral.evaluate(null, Geometry.class)).getUserData());
    }

    @Test
    public void testIntersectsEnvelope() throws CQLException {
        Filter filter = CompilerUtil.parseFilter((Language)this.language, (String)"INTERSECTS(geom, ENVELOPE(10, 40, 40, 10))");
        Intersects intersects = (Intersects)filter;
        PropertyName pn = (PropertyName)intersects.getExpression1();
        Assert.assertEquals((Object)"geom", (Object)pn.getPropertyName());
        Polygon polygon = (Polygon)intersects.getExpression2().evaluate(null, Polygon.class);
        Assert.assertNotNull((Object)polygon);
        Assert.assertTrue((boolean)polygon.isRectangle());
        Assert.assertEquals((Object)new Envelope(10.0, 40.0, 10.0, 40.0), (Object)polygon.getEnvelopeInternal());
    }
}

