/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.TEquals;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.Position;

public class FilterCQLSample {
    private static final FilterFactory FACTORY;
    public static final String DATE_FORMATTER = "yyyy-MM-dd";
    public static final String DATE_TIME_FORMATTER = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String DATE_TIME_FORMATTER_MILLIS = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final Calendar CALENDAR;
    public static final String LESS_FILTER_SAMPLE = "ATTR1 < 1";
    public static final String LESS_EQ_FILTER_SAMPLE = "ATTR1 <= 1";
    public static final String NOT_EQ_FILTER = "ATTR1 <> 1";
    public static final String EQ_FILTER = "ATTR1 = 1";
    public static final String FILTER_WITH_PAREN_ROUNDTRIP_EXPR = "ATTR1 > ((1 + 2) / 3)";
    public static final String FILTER_WITH_NESTED_PAREN_EXPR = "ATTR1 < (1 + ((2 / 3) * 4))";
    public static final String FILTER_SIMPLE_EXPR = "ATTR1 > 1 + 2";
    public static final String FILTER_WITH_BRACKET_ROUNDTRIP_EXPR = "ATTR1 > [[1 + 2] / 3]";
    public static final String PROPERTY_IS_NULL = "ATTR1 IS NULL";
    public static final String PROPERTY_IS_NOT_NULL = "ATTR1 IS NOT NULL";
    public static final String FIRST_DATE = "2006-11-30T01:30:00Z";
    public static final String LAST_DATE = "2006-12-31T01:30:00Z";
    public static final String FIRST_DATE_MILLIS = "2006-11-30T01:30:00.123Z";
    public static final String LAST_DATE_MILLIS = "2006-12-31T01:30:00.456Z";
    public static final String FILTER_EQUAL_DATETIME = "ATTR1 TEQUALS 2006-11-30T01:30:00Z";
    public static final String FILTER_BEFORE_DATE = "ATTR1 BEFORE 2006-11-30T01:30:00Z";
    public static final String FILTER_BEFORE_DATE_MILLIS = "ATTR1 BEFORE 2006-11-30T01:30:00.123Z";
    public static final String FILTER_BEFORE_PERIOD_BETWEEN_DATES = "ATTR1 BEFORE 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z";
    public static final String FILTER_BEFORE_PERIOD_BETWEEN_DATES_MILLIS = "ATTR1 BEFORE 2006-11-30T01:30:00.123Z/2006-12-31T01:30:00.456Z";
    public static final String FILTER_BEFORE_PERIOD_DATE_AND_DAYS = "ATTR1 BEFORE  2006-11-30T01:30:00Z/P30D";
    public static final String FILTER_BEFORE_PERIOD_DATE_AND_YEARS = "ATTR1 BEFORE 2006-11-30T01:30:00Z/P1Y";
    public static final String FILTER_BEFORE_PERIOD_DATE_AND_MONTHS = "ATTR1 BEFORE 2006-11-30T01:30:00Z/P12M";
    public static final String FILTER_AFTER_DATE = "ATTR1 AFTER 2006-12-31T01:30:00Z";
    public static final String FILTER_AFTER_PERIOD_BETWEEN_DATES = "ATTR1 AFTER 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z";
    private static final String DURATION_DATE = "10";
    public static final String FILTER_AFTER_PERIOD_DATE_DAYS = "ATTR1 AFTER 2006-11-30T01:30:00Z/P10D";
    public static final String FILTER_AFTER_PERIOD_DATE_MONTH = "ATTR1 AFTER 2006-11-30T01:30:00Z/P10M";
    public static final String FILTER_AFTER_PERIOD_DATE_YEARS = "ATTR1 AFTER 2006-11-30T01:30:00Z/P10Y";
    public static final String FILTER_AFTER_PERIOD_DATE_YEARS_MONTH = "ATTR1 AFTER 2006-11-30T01:30:00Z/P10Y10M";
    private static final String DURATION_TIME = "5";
    public static final String FILTER_AFTER_PERIOD_DATE_HOURS = "ATTR1 AFTER 2006-11-30T01:30:00Z/T5H";
    public static final String FILTER_AFTER_PERIOD_DATE_MINUTES = "ATTR1 AFTER 2006-11-30T01:30:00Z/T5M";
    public static final String FILTER_AFTER_PERIOD_DATE_SECONDS = "ATTR1 AFTER 2006-11-30T01:30:00Z/T5S";
    public static final String FILTER_AFTER_PERIOD_DATE_YMD_HMS = "ATTR1 AFTER 2006-11-30T01:30:00Z/P10Y10M10DT5H5M5S";
    public static final String FILTER_DURING_PERIOD_BETWEEN_DATES = "ATTR1 DURING 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z";
    public static final String FILTER_DURING_PERIOD_DATE_YMD_HMS = "ATTR1 DURING 2006-11-30T01:30:00Z/P10Y10M10DT5H5M5S";
    public static final String FILTER_DURING_PERIOD_YMD_HMS_DATE = "ATTR1 DURING P10Y10M10DT5H5M5S/2006-12-31T01:30:00Z";
    public static final String FILTER_BEFORE_PERIOD_YMD_HMS_DATE = "ATTR1 BEFORE P10Y10M10DT5H5M5S/2006-12-31T01:30:00Z";
    public static final String FILTER_BEFORE_OR_DURING_PERIOD_BETWEEN_DATES = "ATTR1 BEFORE OR DURING 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z";
    public static final String FILTER_BEFORE_OR_DURING_PERIOD_YMD_HMS_DATE = "ATTR1 BEFORE OR DURING P10Y10M10DT5H5M5S/2006-12-31T01:30:00Z";
    public static final String FILTER_BEFORE_OR_DURING_PERIOD_DATE_YMD_HMS = "ATTR1 BEFORE OR DURING 2006-11-30T01:30:00Z/P10Y10M10DT5H5M5S";
    public static final String FILTER_DURING_OR_AFTER_PERIOD_BETWEEN_DATES = "ATTR1 DURING OR AFTER 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z";
    public static final String FILTER_DURING_OR_AFTER_PERIOD_YMD_HMS_DATE = "ATTR1 DURING OR AFTER P10Y10M10DT5H5M5S/2006-12-31T01:30:00Z";
    public static final String FILTER_DURING_OR_AFTER_PERIOD_DATE_YMD_HMS = "ATTR1 DURING OR AFTER 2006-11-30T01:30:00Z/P10Y10M10DT5H5M5S";
    public static final String ATTRIBUTE_NAME_EXISTS = "ATTR1 EXISTS";
    public static final String ATTRIBUTE_NAME_DOES_NOT_EXIST = "ATTR1 DOES-NOT-EXIST";
    public static final String FILTER_AND = "ATTR1 < 10 AND ATTR2 < 2";
    public static final String FILTER_OR = "ATTR1 > 10 OR ATTR2 < 2";
    public static final String FILTER_OR_AND = "ATTR1 < 10 AND ATTR2 < 2 OR ATTR3 > 10";
    public static final String FILTER_OR_AND_PARENTHESIS = "ATTR3 < 4 AND (ATTR1 > 10 OR ATTR2 < 2)";
    public static final String FILTER_AND_NOT_AND = "ATTR3 < 4 AND (NOT( ATTR1 < 10 AND ATTR2 < 2))";
    public static final String FILTER_AND_NOT_COMPARASION = "ATTR1 < 1 AND (NOT (ATTR2 < 2)) AND ATTR3 < 3";
    public static final String FILTER_WITH_FUNCTION_ABS = "ATTR1 < abs(10)";
    public static final String FILTER__WITH_FUNCTION_STR_CONCAT = "ATTR1 = strConcat(A, '1')";
    public static final String LIKE_FILTER = "ATTR1 LIKE 'abc%'";
    public static final String NOT_LIKE_FILTER = "ATTR1 NOT LIKE 'abc%'";
    public static final String BETWEEN_FILTER = "ATTR1 BETWEEN 10 AND 20";
    public static final String NOT_BETWEEN_FILTER = "ATTR1 NOT BETWEEN 10 AND 20";
    public static Map<String, Object> SAMPLES;

    private static Or buildDuringOrAfterFilter(PropertyName property, Period period) throws ParseException {
        During during = FACTORY.during((Expression)property, (Expression)FACTORY.literal((Object)period));
        Date lastDate = period.getEnding().getPosition().getDate();
        After after = FACTORY.after((Expression)property, (Expression)FACTORY.literal((Object)lastDate));
        Or filter = FACTORY.or((Filter)during, (Filter)after);
        return filter;
    }

    protected FilterCQLSample() {
    }

    private static Or buildBeforeOrDuringFilter(PropertyName property, Date firstDate, Date lastDate) {
        Before before = FACTORY.before((Expression)property, (Expression)FACTORY.literal((Object)firstDate));
        Period period = FilterCQLSample.createPeriod(firstDate, lastDate);
        During during = FACTORY.during((Expression)property, (Expression)FACTORY.literal((Object)period));
        Or filter = FACTORY.or((Filter)before, (Filter)during);
        return filter;
    }

    private static Date strToDate(String firstDate) throws ParseException {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_TIME_FORMATTER);
        dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormatter.parse(firstDate);
    }

    private static Period createPeriod(String firstDate, String lastDate) throws ParseException {
        return new DefaultPeriod(FilterCQLSample.dateToInstant(firstDate), FilterCQLSample.dateToInstant(lastDate));
    }

    private static Period createPeriod(Date firstDate, Date lastDate) {
        DefaultInstant i1 = new DefaultInstant((Position)new DefaultPosition(firstDate));
        DefaultInstant i2 = new DefaultInstant((Position)new DefaultPosition(lastDate));
        return new DefaultPeriod((Instant)i1, (Instant)i2);
    }

    private static Date addDuration(Date date, String durationDate, String durationTime) {
        CALENDAR.setTime(date);
        int durDate = Integer.parseInt(durationDate);
        CALENDAR.add(1, durDate);
        CALENDAR.add(2, durDate);
        CALENDAR.add(5, durDate);
        int durTime = Integer.parseInt(durationTime);
        CALENDAR.add(10, durTime);
        CALENDAR.add(12, durTime);
        CALENDAR.add(13, durTime);
        Date lastDate = CALENDAR.getTime();
        return lastDate;
    }

    private static Date subtractDuration(Date lastDate, String durationDate, String durationTime) {
        CALENDAR.setTime(lastDate);
        int durDate = -1 * Integer.parseInt(durationDate);
        CALENDAR.add(1, durDate);
        CALENDAR.add(2, durDate);
        CALENDAR.add(5, durDate);
        int durTime = -1 * Integer.parseInt(durationTime);
        CALENDAR.add(10, durTime);
        CALENDAR.add(12, durTime);
        CALENDAR.add(13, durTime);
        Date firstDate = CALENDAR.getTime();
        return firstDate;
    }

    public static Filter getSample(String sampleRequested) {
        Filter sample = (Filter)SAMPLES.get(sampleRequested);
        assert (sample != null) : "There is not a sample for " + sampleRequested;
        return sample;
    }

    private static Instant dateToInstant(String strDate) throws ParseException {
        Date date;
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_TIME_FORMATTER);
        dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            date = dateFormatter.parse(strDate);
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            throw e;
        }
        DefaultInstant instant = new DefaultInstant((Position)new DefaultPosition(date));
        return instant;
    }

    static {
        PropertyName property;
        PropertyName property2;
        Or filter;
        Date lastDate;
        Date firstDate;
        Date firstDate2;
        Date lastDate2;
        Date dateTime;
        SimpleDateFormat dateFormatter;
        FACTORY = CommonFactoryFinder.getFilterFactory(null);
        CALENDAR = Calendar.getInstance();
        SAMPLES = new HashMap<String, Object>();
        PropertyIsLessThan filter2 = FACTORY.less((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal(1));
        SAMPLES.put(LESS_FILTER_SAMPLE, filter2);
        filter2 = FACTORY.lessOrEqual((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal(1));
        SAMPLES.put(LESS_EQ_FILTER_SAMPLE, filter2);
        filter2 = FACTORY.not((Filter)FACTORY.equals((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal(1)));
        SAMPLES.put(NOT_EQ_FILTER, filter2);
        filter2 = FACTORY.equals((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal(1));
        SAMPLES.put(EQ_FILTER, filter2);
        filter2 = FACTORY.greater((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.divide((Expression)FACTORY.add((Expression)FACTORY.literal(1), (Expression)FACTORY.literal(2)), (Expression)FACTORY.literal(3)));
        SAMPLES.put(FILTER_WITH_PAREN_ROUNDTRIP_EXPR, filter2);
        filter2 = FACTORY.greater((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.divide((Expression)FACTORY.add((Expression)FACTORY.literal(1), (Expression)FACTORY.literal(2)), (Expression)FACTORY.literal(3)));
        SAMPLES.put(FILTER_WITH_BRACKET_ROUNDTRIP_EXPR, filter2);
        filter2 = FACTORY.less((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.add((Expression)FACTORY.literal(1), (Expression)FACTORY.multiply((Expression)FACTORY.divide((Expression)FACTORY.literal(2), (Expression)FACTORY.literal(3)), (Expression)FACTORY.literal(4))));
        SAMPLES.put(FILTER_WITH_NESTED_PAREN_EXPR, filter2);
        filter2 = FACTORY.greater((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.add((Expression)FACTORY.literal(1), (Expression)FACTORY.literal(2)));
        SAMPLES.put(FILTER_SIMPLE_EXPR, filter2);
        PropertyIsNull nullFilter = FACTORY.isNull((Expression)FACTORY.property("ATTR1"));
        SAMPLES.put(PROPERTY_IS_NULL, nullFilter);
        Not notNullFilter = FACTORY.not((Filter)FACTORY.isNull((Expression)FACTORY.property("ATTR1")));
        SAMPLES.put(PROPERTY_IS_NOT_NULL, notNullFilter);
        TEquals tEqualsFilter = null;
        try {
            dateFormatter = new SimpleDateFormat(DATE_TIME_FORMATTER);
            dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            dateTime = dateFormatter.parse(FIRST_DATE);
            tEqualsFilter = FACTORY.tequals((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)dateTime));
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        SAMPLES.put(FILTER_EQUAL_DATETIME, tEqualsFilter);
        Before beforeFilter = null;
        try {
            dateFormatter = new SimpleDateFormat(DATE_TIME_FORMATTER);
            dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            dateTime = dateFormatter.parse(FIRST_DATE);
            beforeFilter = FACTORY.before((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)dateTime));
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        SAMPLES.put(FILTER_BEFORE_DATE, beforeFilter);
        SAMPLES.put(FILTER_BEFORE_PERIOD_BETWEEN_DATES, beforeFilter);
        SAMPLES.put(FILTER_BEFORE_PERIOD_DATE_AND_DAYS, beforeFilter);
        SAMPLES.put(FILTER_BEFORE_PERIOD_DATE_AND_YEARS, beforeFilter);
        SAMPLES.put(FILTER_BEFORE_PERIOD_DATE_AND_MONTHS, beforeFilter);
        try {
            lastDate2 = FilterCQLSample.strToDate(LAST_DATE);
            Date firstDate3 = FilterCQLSample.subtractDuration(lastDate2, DURATION_DATE, DURATION_TIME);
            Before before = FACTORY.before((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)firstDate3));
            SAMPLES.put(FILTER_BEFORE_PERIOD_YMD_HMS_DATE, before);
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        beforeFilter = null;
        try {
            SimpleDateFormat dateFormatterWithMillis = new SimpleDateFormat(DATE_TIME_FORMATTER_MILLIS);
            dateFormatterWithMillis.setTimeZone(TimeZone.getTimeZone("GMT"));
            dateTime = dateFormatterWithMillis.parse(FIRST_DATE_MILLIS);
            beforeFilter = FACTORY.before((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)dateTime));
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        SAMPLES.put(FILTER_BEFORE_DATE_MILLIS, beforeFilter);
        SAMPLES.put(FILTER_BEFORE_PERIOD_BETWEEN_DATES_MILLIS, beforeFilter);
        After afterFilter = null;
        try {
            dateFormatter = new SimpleDateFormat(DATE_TIME_FORMATTER);
            dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            dateTime = dateFormatter.parse(LAST_DATE);
            afterFilter = FACTORY.after((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)dateTime));
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        SAMPLES.put(FILTER_AFTER_DATE, afterFilter);
        SAMPLES.put(FILTER_AFTER_PERIOD_BETWEEN_DATES, afterFilter);
        try {
            firstDate2 = FilterCQLSample.strToDate(FIRST_DATE);
            CALENDAR.setTime(firstDate2);
            int days = Integer.parseInt(DURATION_DATE);
            CALENDAR.add(5, days);
            Date lastDate3 = CALENDAR.getTime();
            afterFilter = FACTORY.after((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)lastDate3));
            SAMPLES.put(FILTER_AFTER_PERIOD_DATE_DAYS, afterFilter);
            int years = Integer.parseInt(DURATION_DATE);
            CALENDAR.setTime(firstDate2);
            CALENDAR.add(1, years);
            lastDate3 = CALENDAR.getTime();
            afterFilter = FACTORY.after((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)lastDate3));
            SAMPLES.put(FILTER_AFTER_PERIOD_DATE_YEARS, afterFilter);
            CALENDAR.setTime(firstDate2);
            int months = Integer.parseInt(DURATION_DATE);
            CALENDAR.add(2, months);
            lastDate3 = CALENDAR.getTime();
            afterFilter = FACTORY.after((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)lastDate3));
            SAMPLES.put(FILTER_AFTER_PERIOD_DATE_MONTH, afterFilter);
            CALENDAR.setTime(firstDate2);
            int duration = Integer.parseInt(DURATION_DATE);
            CALENDAR.add(1, duration);
            CALENDAR.add(2, duration);
            lastDate3 = CALENDAR.getTime();
            afterFilter = FACTORY.after((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)lastDate3));
            SAMPLES.put(FILTER_AFTER_PERIOD_DATE_YEARS_MONTH, afterFilter);
            CALENDAR.setTime(firstDate2);
            int hours = Integer.parseInt(DURATION_TIME);
            CALENDAR.add(10, hours);
            lastDate3 = CALENDAR.getTime();
            afterFilter = FACTORY.after((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)lastDate3));
            SAMPLES.put(FILTER_AFTER_PERIOD_DATE_HOURS, afterFilter);
            CALENDAR.setTime(firstDate2);
            int minutes = Integer.parseInt(DURATION_TIME);
            CALENDAR.add(12, minutes);
            lastDate3 = CALENDAR.getTime();
            afterFilter = FACTORY.after((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)lastDate3));
            SAMPLES.put(FILTER_AFTER_PERIOD_DATE_MINUTES, afterFilter);
            CALENDAR.setTime(firstDate2);
            int seconds = Integer.parseInt(DURATION_TIME);
            CALENDAR.add(13, seconds);
            lastDate3 = CALENDAR.getTime();
            afterFilter = FACTORY.after((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)lastDate3));
            SAMPLES.put(FILTER_AFTER_PERIOD_DATE_SECONDS, afterFilter);
            lastDate3 = FilterCQLSample.addDuration(firstDate2, DURATION_DATE, DURATION_TIME);
            afterFilter = FACTORY.after((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)lastDate3));
            SAMPLES.put(FILTER_AFTER_PERIOD_DATE_YMD_HMS, afterFilter);
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        try {
            Period period = FilterCQLSample.createPeriod(FIRST_DATE, LAST_DATE);
            During duringFilter = FACTORY.during((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)period));
            SAMPLES.put(FILTER_DURING_PERIOD_BETWEEN_DATES, duringFilter);
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        try {
            firstDate = FilterCQLSample.strToDate(FIRST_DATE);
            lastDate2 = FilterCQLSample.addDuration(firstDate, DURATION_DATE, DURATION_TIME);
            Period period = FilterCQLSample.createPeriod(firstDate, lastDate2);
            During duringFilter = FACTORY.during((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)period));
            SAMPLES.put(FILTER_DURING_PERIOD_DATE_YMD_HMS, duringFilter);
            lastDate = FilterCQLSample.strToDate(LAST_DATE);
            firstDate2 = FilterCQLSample.subtractDuration(lastDate, DURATION_DATE, DURATION_TIME);
            period = FilterCQLSample.createPeriod(firstDate2, lastDate);
            duringFilter = FACTORY.during((Expression)FACTORY.property("ATTR1"), (Expression)FACTORY.literal((Object)period));
            SAMPLES.put(FILTER_DURING_PERIOD_YMD_HMS_DATE, duringFilter);
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        try {
            firstDate = FilterCQLSample.strToDate(FIRST_DATE);
            lastDate2 = FilterCQLSample.strToDate(LAST_DATE);
            PropertyName property3 = FACTORY.property("ATTR1");
            filter = FilterCQLSample.buildBeforeOrDuringFilter(property3, firstDate, lastDate2);
            SAMPLES.put(FILTER_BEFORE_OR_DURING_PERIOD_BETWEEN_DATES, filter);
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        try {
            lastDate = FilterCQLSample.strToDate(LAST_DATE);
            firstDate2 = FilterCQLSample.subtractDuration(lastDate, DURATION_DATE, DURATION_TIME);
            PropertyName property4 = FACTORY.property("ATTR1");
            filter = FilterCQLSample.buildBeforeOrDuringFilter(property4, firstDate2, lastDate);
            SAMPLES.put(FILTER_BEFORE_OR_DURING_PERIOD_YMD_HMS_DATE, filter);
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        try {
            firstDate = FilterCQLSample.strToDate(FIRST_DATE);
            lastDate2 = FilterCQLSample.addDuration(firstDate, DURATION_DATE, DURATION_TIME);
            PropertyName property5 = FACTORY.property("ATTR1");
            filter = FilterCQLSample.buildBeforeOrDuringFilter(property5, firstDate, lastDate2);
            SAMPLES.put(FILTER_BEFORE_OR_DURING_PERIOD_DATE_YMD_HMS, filter);
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        try {
            property2 = FACTORY.property("ATTR1");
            Period period = FilterCQLSample.createPeriod(FIRST_DATE, LAST_DATE);
            Or filter3 = FilterCQLSample.buildDuringOrAfterFilter(property2, period);
            SAMPLES.put(FILTER_DURING_OR_AFTER_PERIOD_BETWEEN_DATES, filter3);
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        try {
            lastDate = FilterCQLSample.strToDate(LAST_DATE);
            firstDate2 = FilterCQLSample.subtractDuration(lastDate, DURATION_DATE, DURATION_TIME);
            Period period = FilterCQLSample.createPeriod(firstDate2, lastDate);
            property = FACTORY.property("ATTR1");
            Or filter4 = FilterCQLSample.buildDuringOrAfterFilter(property, period);
            SAMPLES.put(FILTER_DURING_OR_AFTER_PERIOD_YMD_HMS_DATE, filter4);
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        try {
            firstDate = FilterCQLSample.strToDate(FIRST_DATE);
            lastDate2 = FilterCQLSample.addDuration(firstDate, DURATION_DATE, DURATION_TIME);
            PropertyName property6 = FACTORY.property("ATTR1");
            Period period = FilterCQLSample.createPeriod(firstDate, lastDate2);
            Or filter5 = FilterCQLSample.buildDuringOrAfterFilter(property6, period);
            SAMPLES.put(FILTER_DURING_OR_AFTER_PERIOD_DATE_YMD_HMS, filter5);
        }
        catch (ParseException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        try {
            Expression[] args = new Expression[]{FACTORY.literal((Object)"ATTR1")};
            Function function = FACTORY.function("PropertyExists", args);
            Literal literalTrue = FACTORY.literal((Object)Boolean.TRUE);
            PropertyIsEqualTo propExists = FACTORY.equals((Expression)function, (Expression)literalTrue);
            SAMPLES.put(ATTRIBUTE_NAME_EXISTS, propExists);
            Not notEq = FACTORY.not((Filter)propExists);
            SAMPLES.put(ATTRIBUTE_NAME_DOES_NOT_EXIST, notEq);
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        try {
            PropertyName attr1 = FACTORY.property("ATTR1");
            PropertyName attr2 = FACTORY.property("ATTR2");
            PropertyName attr3 = FACTORY.property("ATTR3");
            And andFilter = FACTORY.and((Filter)FACTORY.less((Expression)attr1, (Expression)FACTORY.literal(10)), (Filter)FACTORY.less((Expression)attr2, (Expression)FACTORY.literal(2)));
            SAMPLES.put(FILTER_AND, andFilter);
            Or orFilter = FACTORY.or((Filter)FACTORY.greater((Expression)attr1, (Expression)FACTORY.literal(10)), (Filter)FACTORY.less((Expression)attr2, (Expression)FACTORY.literal(2)));
            SAMPLES.put(FILTER_OR, orFilter);
            Or orAndFilter = FACTORY.or((Filter)andFilter, (Filter)FACTORY.greater((Expression)attr3, (Expression)FACTORY.literal(10)));
            SAMPLES.put(FILTER_OR_AND, orAndFilter);
            And parenthesisFilter = FACTORY.and((Filter)FACTORY.less((Expression)attr3, (Expression)FACTORY.literal(4)), (Filter)orFilter);
            SAMPLES.put(FILTER_OR_AND_PARENTHESIS, parenthesisFilter);
            And andNotAnd = FACTORY.and((Filter)FACTORY.less((Expression)attr3, (Expression)FACTORY.literal(4)), (Filter)FACTORY.not((Filter)FACTORY.and((Filter)FACTORY.less((Expression)attr1, (Expression)FACTORY.literal(10)), (Filter)FACTORY.less((Expression)attr2, (Expression)FACTORY.literal(2)))));
            SAMPLES.put(FILTER_AND_NOT_AND, andNotAnd);
            And andNotComparasion = FACTORY.and((Filter)FACTORY.and((Filter)FACTORY.less((Expression)attr1, (Expression)FACTORY.literal(1)), (Filter)FACTORY.not((Filter)FACTORY.less((Expression)attr2, (Expression)FACTORY.literal(2)))), (Filter)FACTORY.less((Expression)attr3, (Expression)FACTORY.literal(3)));
            SAMPLES.put(FILTER_AND_NOT_COMPARASION, andNotComparasion);
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        try {
            Expression[] absArgs = new Expression[]{FACTORY.literal(10)};
            Function abs = FACTORY.function("abs", absArgs);
            PropertyIsLessThan lessFilter = FACTORY.less((Expression)FACTORY.property("ATTR1"), (Expression)abs);
            SAMPLES.put(FILTER_WITH_FUNCTION_ABS, lessFilter);
            Expression[] strConcatArgs = new Expression[]{FACTORY.literal((Object)"A"), FACTORY.literal((Object)"1")};
            Function strConcat = FACTORY.function("strConcat", strConcatArgs);
            PropertyIsEqualTo eqFilter = FACTORY.equals((Expression)FACTORY.property("ATTR1"), (Expression)strConcat);
            SAMPLES.put(FILTER__WITH_FUNCTION_STR_CONCAT, eqFilter);
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        try {
            String WC_MULTI = "%";
            String WC_SINGLE = "_";
            String ESCAPE = "\\";
            property = FACTORY.property("ATTR1");
            PropertyIsLike likeFilter = FACTORY.like((Expression)property, "abc%", "%", "_", "\\");
            SAMPLES.put(LIKE_FILTER, likeFilter);
            Not notLikeFileter = FACTORY.not((Filter)likeFilter);
            SAMPLES.put(NOT_LIKE_FILTER, notLikeFileter);
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        try {
            property2 = FACTORY.property("ATTR1");
            Literal inf = FACTORY.literal(10);
            Literal sup = FACTORY.literal(20);
            PropertyIsBetween betweenFilter = FACTORY.between((Expression)property2, (Expression)inf, (Expression)sup);
            SAMPLES.put(BETWEEN_FILTER, betweenFilter);
            Not notBetweenFileter = FACTORY.not((Filter)betweenFilter);
            SAMPLES.put(NOT_BETWEEN_FILTER, notBetweenFileter);
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
    }
}

