/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.FilterCQLSample;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.Filter;

public class CQLNullPredicateTest {
    protected final Language language;

    public CQLNullPredicateTest() {
        this(Language.CQL);
    }

    protected CQLNullPredicateTest(Language language) {
        assert (language != null) : "language cannot be null";
        this.language = language;
    }

    protected void testNullPredicate(String samplePredicate, Filter expected) throws Exception {
        Filter actual = this.parseFilter(samplePredicate);
        Assert.assertNotNull((String)"expects a not null filter", (Object)actual);
        Assert.assertEquals((String)"Filter error", (Object)expected, (Object)actual);
    }

    protected Filter parseFilter(String samplePredicate) throws CQLException {
        return CompilerUtil.parseFilter((Language)this.language, (String)samplePredicate);
    }

    @Test
    public void propertyIsNull() throws Exception {
        String samplePredicate = "ATTR1 IS NULL";
        Filter expected = FilterCQLSample.getSample("ATTR1 IS NULL");
        this.testNullPredicate("ATTR1 IS NULL", expected);
    }

    @Test
    public void propertyIsNotNull() throws Exception {
        String samplePredicate = "ATTR1 IS NOT NULL";
        Filter expected = FilterCQLSample.getSample("ATTR1 IS NOT NULL");
        this.testNullPredicate("ATTR1 IS NOT NULL", expected);
    }
}

