/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import org.geotools.filter.function.FilterFunction_relatePattern;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.referencing.CRS;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CQLLiteralTest {
    protected final Language language;

    public CQLLiteralTest() {
        this(Language.CQL);
    }

    protected CQLLiteralTest(Language language) {
        assert (language != null) : "language cannot be null value";
        this.language = language;
    }

    @Test
    public void geometryLiterals() throws Exception {
        BinarySpatialOperator result = (BinarySpatialOperator)CompilerUtil.parseFilter((Language)this.language, (String)"WITHIN(ATTR1, POINT(1 2))");
        Literal geom = (Literal)result.getExpression2();
        Assert.assertNotNull((Object)geom.getValue());
        Assert.assertTrue((boolean)(geom.getValue() instanceof Point));
        result = (BinarySpatialOperator)CompilerUtil.parseFilter((Language)this.language, (String)"WITHIN(ATTR1, LINESTRING(1 2, 10 15))");
        geom = (Literal)result.getExpression2();
        Assert.assertNotNull((Object)geom.getValue());
        Assert.assertTrue((boolean)(geom.getValue() instanceof LineString));
        result = (BinarySpatialOperator)CompilerUtil.parseFilter((Language)this.language, (String)"WITHIN(ATTR1, POLYGON((1 2, 15 2, 15 20, 15 21, 1 2)))");
        geom = (Literal)result.getExpression2();
        Assert.assertNotNull((Object)geom.getValue());
        Assert.assertTrue((boolean)(geom.getValue() instanceof Polygon));
        result = (BinarySpatialOperator)CompilerUtil.parseFilter((Language)this.language, (String)"WITHIN(ATTR1, MULTIPOINT( (1 2), (15 2), (15 20), (15 21), (1 2) ))");
        geom = (Literal)result.getExpression2();
        Assert.assertNotNull((Object)geom.getValue());
        Assert.assertTrue((boolean)(geom.getValue() instanceof MultiPoint));
        result = (BinarySpatialOperator)CompilerUtil.parseFilter((Language)this.language, (String)"WITHIN(ATTR1, MULTILINESTRING((10 10, 20 20),(15 15,30 15)) )");
        geom = (Literal)result.getExpression2();
        Assert.assertNotNull((Object)geom.getValue());
        Assert.assertTrue((boolean)(geom.getValue() instanceof MultiLineString));
        result = (BinarySpatialOperator)CompilerUtil.parseFilter((Language)this.language, (String)"WITHIN(ATTR1, MULTIPOLYGON( ((10 10, 10 20, 20 20, 20 15, 10 10)),((60 60, 70 70, 80 60, 60 60 )) ) )");
        geom = (Literal)result.getExpression2();
        Assert.assertNotNull((Object)geom.getValue());
        Assert.assertTrue((boolean)(geom.getValue() instanceof MultiPolygon));
        result = (BinarySpatialOperator)CompilerUtil.parseFilter((Language)this.language, (String)"WITHIN(ATTR1, ENVELOPE( 10, 20, 30, 40) )");
        geom = (Literal)result.getExpression2();
        Assert.assertNotNull((Object)geom.getValue());
        Assert.assertTrue((boolean)(geom.getValue() instanceof Polygon));
    }

    @Test(expected=CQLException.class)
    public void geometryLiteralsError() throws CQLException {
        String filterError = "WITHIN(ATTR1, POLYGON(1 2, 10 15), (10 15, 1 2)))";
        CompilerUtil.parseFilter((Language)this.language, (String)"WITHIN(ATTR1, POLYGON(1 2, 10 15), (10 15, 1 2)))");
    }

    @Test
    public void characterStringLiteral() throws Exception {
        String strWithSpace = "ALL PRACTICES";
        Filter filterWithSpace = CompilerUtil.parseFilter((Language)this.language, (String)"practice='ALL PRACTICES'");
        Assert.assertNotNull((Object)filterWithSpace);
        Assert.assertTrue((boolean)(filterWithSpace instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eqFilter = (PropertyIsEqualTo)filterWithSpace;
        Expression spacesLiteral = eqFilter.getExpression2();
        Assert.assertEquals((Object)"ALL PRACTICES", (Object)spacesLiteral.toString());
        Filter emptyFilter = CompilerUtil.parseFilter((Language)this.language, (String)"MAJOR_WATERSHED_SYSTEM = ''");
        Assert.assertNotNull((Object)emptyFilter);
        Assert.assertTrue((boolean)(emptyFilter instanceof PropertyIsEqualTo));
        eqFilter = (PropertyIsEqualTo)emptyFilter;
        Expression emptyLiteral = eqFilter.getExpression2();
        Assert.assertEquals((Object)"", (Object)emptyLiteral.toString());
        String expectedWithout = "ab";
        Filter filterWithoutQuote = CompilerUtil.parseFilter((Language)this.language, (String)"MAJOR_WATERSHED_SYSTEM = 'ab'");
        Assert.assertNotNull((Object)filterWithoutQuote);
        Assert.assertTrue((boolean)(filterWithoutQuote instanceof PropertyIsEqualTo));
        eqFilter = (PropertyIsEqualTo)filterWithoutQuote;
        Expression actualWhithoutQuote = eqFilter.getExpression2();
        Assert.assertEquals((Object)"ab", (Object)actualWhithoutQuote.toString());
        String expected = "cde'' fg";
        Filter filter = CQL.toFilter((String)"MAJOR_WATERSHED_SYSTEM = 'cde'' fg'");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        eqFilter = (PropertyIsEqualTo)filter;
        Expression actual = eqFilter.getExpression2();
        Assert.assertEquals((Object)"cde'' fg".replaceAll("''", "'"), (Object)actual.toString());
        String otherChars = "\u00fc\u00e4";
        filter = CompilerUtil.parseFilter((Language)this.language, (String)"NAME = '\u00fc\u00e4'");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        eqFilter = (PropertyIsEqualTo)filter;
        actual = eqFilter.getExpression2();
        Assert.assertEquals((Object)"\u00fc\u00e4", (Object)actual.toString());
    }

    @Test
    public void russianCharacterStringLiteral() throws Exception {
        this.testCharacterString("\u0414\u041e\u0411\u0420\u0418\u0427");
        this.testCharacterString("\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        this.testCharacterString("\u0444\u0430\u043c\u0438\u043b\u0438\u044f");
        this.testCharacterString("\u0441\u0440\u0435\u0434\u044b");
    }

    @Test
    public void japanCharacterStringLiteral() throws Exception {
        this.testCharacterString("\u540d");
        this.testCharacterString("\u59d3");
        this.testCharacterString("\u74b0\u5883");
    }

    private void testCharacterString(String str) throws Exception {
        Filter filter = CompilerUtil.parseFilter((Language)this.language, (String)("NAME = '" + str + "'"));
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eqFilter = (PropertyIsEqualTo)filter;
        Expression actual = eqFilter.getExpression2();
        Assert.assertEquals((Object)str, (Object)actual.toString());
    }

    @Test
    public void doubleLiteral() throws Exception {
        String expected = "4.20082008E4";
        Expression expr = CompilerUtil.parseExpression((Language)this.language, (String)"4.20082008E4");
        Literal doubleLiteral = (Literal)expr;
        Double actual = (Double)doubleLiteral.getValue();
        Assert.assertEquals((double)Double.parseDouble("4.20082008E4"), (double)actual, (double)8.0);
    }

    @Test
    public void longLiteral() throws Exception {
        String expected = "123456789012345";
        Expression expr = CompilerUtil.parseExpression((Language)this.language, (String)"123456789012345");
        Literal intLiteral = (Literal)expr;
        Long actual = (Long)intLiteral.getValue();
        Assert.assertEquals((long)Long.parseLong("123456789012345"), (long)actual);
        String maxLongValue = "9223372036854775807";
        expr = CompilerUtil.parseExpression((Language)this.language, (String)"9223372036854775807");
        intLiteral = (Literal)expr;
        actual = (Long)intLiteral.getValue();
        Assert.assertEquals((long)Long.parseLong("9223372036854775807"), (long)actual);
    }

    @Test
    public void clashLongLiteralandDE9IM() throws Exception {
        String expected = "201000002";
        Expression expr = CompilerUtil.parseExpression((Language)this.language, (String)"201000002");
        Literal intLiteral = (Literal)expr;
        Long actual = (Long)intLiteral.getValue();
        Assert.assertEquals((long)Long.parseLong("201000002"), (long)actual);
        PropertyIsEqualTo resultFilter = (PropertyIsEqualTo)CompilerUtil.parseFilter((Language)this.language, (String)"RELATE(the_geom, LINESTRING (-134.921387 58.687767, -135.303391 59.092838), 201000002)");
        Expression relateFunction = resultFilter.getExpression1();
        Assert.assertTrue((boolean)(relateFunction instanceof FilterFunction_relatePattern));
        Literal trueLiteral = (Literal)resultFilter.getExpression2();
        Assert.assertTrue((boolean)(trueLiteral.getValue() instanceof Boolean));
    }

    @Test
    public void relatePatterns() throws CQLException {
        this.testRelatePatten("T******F*");
        this.testRelatePatten("T012**FF*");
        this.testRelatePatten("100000001");
        this.testRelatePatten("200000000");
    }

    private void testRelatePatten(String pattern) throws CQLException {
        PropertyIsEqualTo resultFilter = (PropertyIsEqualTo)CompilerUtil.parseFilter((Language)this.language, (String)("RELATE(the_geom, LINESTRING (-134.921387 58.687767, -135.303391 59.092838), " + pattern + ")"));
        Expression relateFunction = resultFilter.getExpression1();
        Assert.assertTrue((boolean)(relateFunction instanceof FilterFunction_relatePattern));
        Literal trueLiteral = (Literal)resultFilter.getExpression2();
        Assert.assertTrue((boolean)(trueLiteral.getValue() instanceof Boolean));
    }

    @Test
    public void dateLiteral() throws Exception {
        String expectedDate = "2009-08-01";
        Filter filter = CompilerUtil.parseFilter((Language)this.language, (String)"END_DATE = '2009-08-01'");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eq = (PropertyIsEqualTo)filter;
        Expression exp = eq.getExpression2();
        Assert.assertTrue((boolean)(exp instanceof Literal));
        Literal actualDate = (Literal)exp;
        Assert.assertEquals((Object)"2009-08-01", (Object)actualDate.toString());
    }

    @Test
    public void timeLiteral() throws Exception {
        String expectedTime = "12:08:01";
        Filter filter = CompilerUtil.parseFilter((Language)this.language, (String)"END_TIME = '12:08:01'");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eq = (PropertyIsEqualTo)filter;
        Expression exp = eq.getExpression2();
        Assert.assertTrue((boolean)(exp instanceof Literal));
        Literal actualTime = (Literal)exp;
        Assert.assertEquals((Object)"12:08:01", (Object)actualTime.toString());
    }

    @Test
    public void timeStampLiteral() throws Exception {
        String expectedDateTime = "2009-08-01 12:08:01";
        Filter filter = CompilerUtil.parseFilter((Language)this.language, (String)"END_DATE = '2009-08-01 12:08:01'");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eq = (PropertyIsEqualTo)filter;
        Expression exp = eq.getExpression2();
        Assert.assertTrue((boolean)(exp instanceof Literal));
        Literal actualDateTime = (Literal)exp;
        Assert.assertEquals((Object)"2009-08-01 12:08:01", (Object)actualDateTime.toString());
    }

    protected void assertEqualsReferencedGeometries(String strGeomExpected, Geometry actualGeometry, int expectedSrid) throws Exception {
        CoordinateReferenceSystem expectedCRS = CRS.decode((String)("EPSG:" + expectedSrid));
        MatcherAssert.assertThat((Object)actualGeometry.getUserData(), (Matcher)CoreMatchers.equalTo((Object)expectedCRS));
        this.assertEqualsGeometries(strGeomExpected, actualGeometry);
    }

    protected void assertEqualsGeometries(String strGeomExpected, Geometry actualGeometry) throws Exception {
        WKTReader reader = new WKTReader();
        Geometry expectedGeometry = reader.read(strGeomExpected);
        if (expectedGeometry instanceof GeometryCollection) {
            Assert.assertTrue((boolean)expectedGeometry.equalsExact(actualGeometry));
        } else {
            Assert.assertTrue((boolean)expectedGeometry.equalsTopo(actualGeometry));
        }
    }
}

