/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import java.util.List;
import org.geotools.filter.function.FilterFunction_relatePattern;
import org.geotools.filter.function.FilterFunction_strConcat;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.FilterCQLSample;
import org.geotools.filter.text.ecql.ECQL;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class CQLExtensionTest {
    private static final String DELIMITER = ";";

    @Test
    public void testIncludeFilter() throws Exception {
        Filter filter = CQL.toFilter((String)"INCLUDE");
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)filter);
        filter = CQL.toFilter((String)"INCLUDE and a < 1");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsLessThan));
        filter = CQL.toFilter((String)"INCLUDE or a < 1");
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)filter);
    }

    @Test
    public void testExcludeFilter() throws Exception {
        Filter filter = CQL.toFilter((String)"EXCLUDE");
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)Filter.EXCLUDE, (Object)filter);
        filter = CQL.toFilter((String)"EXCLUDE and a < 1");
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)Filter.EXCLUDE, (Object)filter);
        filter = CQL.toFilter((String)"EXCLUDE or a < 1");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsLessThan));
    }

    @Test
    public void testSequenceOfSearchConditionsWithOneFilter() throws Exception {
        String valueWithDelimiter = "text;with;delimiter";
        String singleFilterStr = "attr3 = '" + valueWithDelimiter + "'";
        List filters = CQL.toFilterList((String)singleFilterStr);
        Assert.assertNotNull((Object)filters);
        Assert.assertEquals((long)1L, (long)filters.size());
        Assert.assertTrue((boolean)(filters.get(0) instanceof PropertyIsEqualTo));
        PropertyIsEqualTo filter = (PropertyIsEqualTo)filters.get(0);
        Assert.assertEquals((Object)"attr3", (Object)((PropertyName)filter.getExpression1()).getPropertyName());
        Assert.assertEquals((Object)valueWithDelimiter, (Object)((Literal)filter.getExpression2()).getValue());
    }

    @Test
    public void testSequenceOfSearchConditionsWithManyFilters() throws Exception {
        String valueWithDelimiter = "text;with;delimiter";
        String filterListStr = "attr1 > 5;attr2 between 1 and 7;attr3 = '" + valueWithDelimiter + "'";
        List filters = CQL.toFilterList((String)filterListStr);
        Assert.assertNotNull((Object)filters);
        Assert.assertEquals((long)3L, (long)filters.size());
        Assert.assertTrue((boolean)(filters.get(0) instanceof PropertyIsGreaterThan));
        Assert.assertTrue((boolean)(filters.get(1) instanceof PropertyIsBetween));
        Assert.assertTrue((boolean)(filters.get(2) instanceof PropertyIsEqualTo));
        PropertyIsGreaterThan gt = (PropertyIsGreaterThan)filters.get(0);
        Assert.assertEquals((Object)"attr1", (Object)((PropertyName)gt.getExpression1()).getPropertyName());
        Assert.assertEquals((Object)5L, (Object)((Literal)gt.getExpression2()).getValue());
        PropertyIsBetween btw = (PropertyIsBetween)filters.get(1);
        Assert.assertEquals((Object)"attr2", (Object)((PropertyName)btw.getExpression()).getPropertyName());
        Assert.assertEquals((Object)1L, (Object)((Literal)btw.getLowerBoundary()).getValue());
        Assert.assertEquals((Object)7L, (Object)((Literal)btw.getUpperBoundary()).getValue());
        PropertyIsEqualTo equals = (PropertyIsEqualTo)filters.get(2);
        Assert.assertEquals((Object)"attr3", (Object)((PropertyName)equals.getExpression1()).getPropertyName());
        Assert.assertEquals((Object)valueWithDelimiter, (Object)((Literal)equals.getExpression2()).getValue());
    }

    @Test
    public void testParseFilterListWithEmptyFilter() throws Exception {
        String valueWithDelimiter = "text;with;delimiter";
        String filterListStr = "attr1 > 5;INCLUDE; attr3 = '" + valueWithDelimiter + "'";
        List filters = CQL.toFilterList((String)filterListStr);
        Assert.assertNotNull((Object)filters);
        Assert.assertEquals((long)3L, (long)filters.size());
        Assert.assertTrue((boolean)(filters.get(0) instanceof PropertyIsGreaterThan));
        Assert.assertTrue((boolean)(filters.get(1) instanceof IncludeFilter));
        Assert.assertTrue((boolean)(filters.get(2) instanceof PropertyIsEqualTo));
        PropertyIsGreaterThan gt = (PropertyIsGreaterThan)filters.get(0);
        Assert.assertEquals((Object)"attr1", (Object)((PropertyName)gt.getExpression1()).getPropertyName());
        Assert.assertEquals((Object)5L, (Object)((Literal)gt.getExpression2()).getValue());
        PropertyIsEqualTo equals = (PropertyIsEqualTo)filters.get(2);
        Assert.assertEquals((Object)"attr3", (Object)((PropertyName)equals.getExpression1()).getPropertyName());
        Assert.assertEquals((Object)valueWithDelimiter, (Object)((Literal)equals.getExpression2()).getValue());
        filterListStr = "EXCLUDE;INCLUDE;attr3 = '" + valueWithDelimiter + "'";
        filters = CQL.toFilterList((String)filterListStr);
        Assert.assertTrue((boolean)(filters.get(0) instanceof ExcludeFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof IncludeFilter));
        Assert.assertTrue((boolean)(filters.get(2) instanceof PropertyIsEqualTo));
    }

    @Test
    public void testNullFilterFactory() throws Exception {
        CQL.toFilter((String)"attName > 20", null);
        CQL.toExpression((String)"2+2", null);
    }

    @Test
    public void testFuncitionExpression() throws Exception {
        String cqlExpression = "strConcat(A, B)";
        Expression resultExpr = CQL.toExpression((String)"strConcat(A, B)");
        Assert.assertNotNull((Object)resultExpr);
        Assert.assertTrue((boolean)(resultExpr instanceof Function));
        Function function1 = (Function)resultExpr;
        Assert.assertEquals((long)2L, (long)function1.getParameters().size());
        Expression arg1 = (Expression)function1.getParameters().get(0);
        Assert.assertTrue((boolean)(arg1 instanceof PropertyName));
        Assert.assertEquals((Object)"A", (Object)((PropertyName)arg1).getPropertyName());
        Expression arg2 = (Expression)function1.getParameters().get(1);
        Assert.assertTrue((boolean)(arg2 instanceof PropertyName));
        Assert.assertEquals((Object)"B", (Object)((PropertyName)arg2).getPropertyName());
        String arg1Name = "gmd:aa:bb.gmd:cc.gmd:dd";
        String arg2Name = "gmd:ee:ff.gmd:gg.gmd:hh";
        String cqlExpression2 = "strConcat(gmd:aa:bb.gmd:cc.gmd:dd, gmd:ee:ff.gmd:gg.gmd:hh)";
        resultExpr = CQL.toExpression((String)"strConcat(gmd:aa:bb.gmd:cc.gmd:dd, gmd:ee:ff.gmd:gg.gmd:hh)");
        Assert.assertNotNull((Object)resultExpr);
        Assert.assertTrue((boolean)(resultExpr instanceof Function));
        Function function = (Function)resultExpr;
        Assert.assertEquals((long)2L, (long)function.getParameters().size());
        arg1 = (Expression)function.getParameters().get(0);
        Assert.assertTrue((boolean)(arg1 instanceof PropertyName));
        String arg1Expected = "gmd:aa:bb.gmd:cc.gmd:dd".replace('.', '/');
        Assert.assertEquals((Object)arg1Expected, (Object)((PropertyName)arg1).getPropertyName());
        arg2 = (Expression)function.getParameters().get(1);
        Assert.assertTrue((boolean)(arg2 instanceof PropertyName));
        String arg2Expected = "gmd:ee:ff.gmd:gg.gmd:hh".replace('.', '/');
        Assert.assertEquals((Object)arg2Expected, (Object)((PropertyName)arg2).getPropertyName());
    }

    @Test
    public void testFunctionComposition() throws Exception {
        String cqlExpression = "strConcat(A, abs(B))";
        Expression expression = CQL.toExpression((String)cqlExpression);
        cqlExpression = "strConcat(A, strConcat(B, strConcat(C, '.')))";
        expression = CQL.toExpression((String)cqlExpression);
        Assert.assertNotNull((Object)expression);
        Assert.assertTrue((boolean)(expression instanceof Function));
        Function function = (Function)expression;
        Assert.assertEquals((long)2L, (long)function.getParameters().size());
        Expression propertyName = (Expression)function.getParameters().get(0);
        Assert.assertTrue((boolean)(propertyName instanceof PropertyName));
        Assert.assertEquals((Object)"A", (Object)((PropertyName)propertyName).getPropertyName());
        Expression arg2 = (Expression)function.getParameters().get(1);
        Assert.assertTrue((boolean)(arg2 instanceof Function));
        function = (Function)arg2;
        propertyName = (Expression)function.getParameters().get(0);
        Assert.assertTrue((boolean)(propertyName instanceof PropertyName));
        Assert.assertEquals((Object)"B", (Object)((PropertyName)propertyName).getPropertyName());
        arg2 = (Expression)function.getParameters().get(1);
        Assert.assertTrue((boolean)(arg2 instanceof Function));
        function = (Function)arg2;
        propertyName = (Expression)function.getParameters().get(0);
        Assert.assertTrue((boolean)(propertyName instanceof PropertyName));
        Assert.assertEquals((Object)"C", (Object)((PropertyName)propertyName).getPropertyName());
        arg2 = (Expression)function.getParameters().get(1);
        Assert.assertTrue((boolean)(arg2 instanceof Literal));
        Assert.assertEquals((Object)".", (Object)((Literal)arg2).getValue());
    }

    @Test
    public void testFunctionCompositionComplexCase() throws Exception {
        Expression result = CQL.toExpression((String)"strConcat( strConcat(QS, strConcat('/', RT)), strConcat(strConcat('/', NUMB), strConcat('/', BSUFF)) )");
        this.assertFunctionCompositionComplex(result);
    }

    @Test
    public void testFunctionCompositionComplexCaseInFilter() throws Exception {
        String propName = "A";
        Filter result = CQL.toFilter((String)"A = strConcat( strConcat(QS, strConcat('/', RT)), strConcat(strConcat('/', NUMB), strConcat('/', BSUFF)) )");
        Assert.assertTrue((boolean)(result instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eq = (PropertyIsEqualTo)result;
        Expression expr1 = eq.getExpression1();
        Assert.assertTrue((boolean)(expr1 instanceof PropertyName));
        PropertyName prop = (PropertyName)expr1;
        Assert.assertEquals((Object)"A", (Object)prop.getPropertyName());
        Expression expr2 = eq.getExpression2();
        this.assertFunctionCompositionComplex(expr2);
    }

    private void assertFunctionCompositionComplex(Expression result) {
        Assert.assertTrue((boolean)(result instanceof Function));
        Function function = (Function)result;
        Assert.assertEquals((long)2L, (long)function.getParameters().size());
        Expression arg1 = (Expression)function.getParameters().get(0);
        Assert.assertTrue((boolean)(arg1 instanceof Function));
        Function function1 = (Function)arg1;
        Assert.assertEquals((long)2L, (long)function1.getParameters().size());
        Expression funcion1Arg1 = (Expression)function1.getParameters().get(0);
        Assert.assertTrue((boolean)(funcion1Arg1 instanceof PropertyName));
        Assert.assertEquals((Object)"QS", (Object)((PropertyName)funcion1Arg1).getPropertyName());
        Expression arg11 = (Expression)function1.getParameters().get(1);
        Assert.assertTrue((boolean)(arg11 instanceof Function));
        Function function11 = (Function)arg11;
        Expression funcion11Arg1 = (Expression)function11.getParameters().get(0);
        Assert.assertTrue((boolean)(funcion11Arg1 instanceof Literal));
        Assert.assertEquals((Object)"/", (Object)((Literal)funcion11Arg1).getValue());
        Expression arg2 = (Expression)function.getParameters().get(1);
        Assert.assertTrue((boolean)(arg2 instanceof Function));
    }

    @Test
    public void testUnaryExpressionFunction() throws Exception {
        String cqlUnaryExp = "ATTR1 < abs(10)";
        Filter result = CQL.toFilter((String)cqlUnaryExp);
        Assert.assertNotNull((String)"filter expected", (Object)result);
        Filter expected = FilterCQLSample.getSample(cqlUnaryExp);
        Assert.assertEquals((String)"Equals Functions is expected", (Object)expected, (Object)result);
        cqlUnaryExp = "ATTR1 = strConcat(A, '1')";
        result = CQL.toFilter((String)cqlUnaryExp);
        Assert.assertNotNull((String)"filter expected", (Object)result);
        expected = FilterCQLSample.getSample(cqlUnaryExp);
        Assert.assertTrue((String)"Functions", (boolean)(result instanceof PropertyIsEqualTo));
        Assert.assertTrue((String)"Attribute is expecteced", (boolean)(((PropertyIsEqualTo)result).getExpression1() instanceof PropertyName));
        Assert.assertTrue((String)"Attribute is expecteced", (boolean)(((PropertyIsEqualTo)result).getExpression2() instanceof FilterFunction_strConcat));
        cqlUnaryExp = "A = strConcat(B, 'testParam')";
        result = CQL.toFilter((String)cqlUnaryExp);
        Assert.assertTrue((boolean)(result instanceof PropertyIsEqualTo));
        Expression expression = ((PropertyIsEqualTo)result).getExpression2();
        Assert.assertNotNull((Object)expression);
        Assert.assertTrue((boolean)(expression instanceof Function));
        Function function = (Function)expression;
        Assert.assertEquals((long)2L, (long)function.getParameters().size());
        Expression arg1 = (Expression)function.getParameters().get(0);
        Expression arg2 = (Expression)function.getParameters().get(1);
        Assert.assertTrue((boolean)(arg1 instanceof PropertyName));
        Assert.assertTrue((boolean)(arg2 instanceof Literal));
        Assert.assertEquals((Object)"B", (Object)((PropertyName)arg1).getPropertyName());
        Assert.assertEquals((Object)"testParam", (Object)((Literal)arg2).getValue());
    }

    @Test
    public void relateFunction() throws CQLException {
        Filter resultFilter = ECQL.toFilter((String)"ATTR = relatePattern(the_geom, 'LINESTRING (27.3 37, 27.3 37.6)', '**1****') ");
        Assert.assertTrue((boolean)(resultFilter instanceof PropertyIsEqualTo));
        resultFilter = ECQL.toFilter((String)"relatePattern(the_geom, 'LINESTRING (27.3 37, 27.3 37.6)', '**1****') = TRUE");
        Assert.assertTrue((boolean)(resultFilter instanceof PropertyIsEqualTo));
        Expression resultExpression = ECQL.toExpression((String)"relatePattern(the_geom, 'LINESTRING (27.3 37, 27.3 37.6)', '**1****') ");
        Assert.assertTrue((boolean)(resultExpression instanceof FilterFunction_relatePattern));
    }
}

