/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import java.awt.Color;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.IsNullImpl;
import org.geotools.filter.function.FilterFunction_relatePattern;
import org.geotools.filter.function.PropertyExistsFunction;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.text.ecql.FilterECQLSample;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.temporal.Before;

public final class ECQLTest {
    @Test
    public void include() throws CQLException {
        IncludeFilter filter = this.assertFilter("INCLUDE", IncludeFilter.class);
        Assert.assertSame((Object)Filter.INCLUDE, (Object)filter);
    }

    @Test
    public void exclude() throws CQLException {
        ExcludeFilter filter = this.assertFilter("EXCLUDE", ExcludeFilter.class);
        Assert.assertSame((Object)Filter.EXCLUDE, (Object)filter);
    }

    @Test
    public void betweenPredicate() throws CQLException {
        this.assertFilter("ATTR1 BETWEEN 10 AND 20", PropertyIsBetween.class);
    }

    @Test
    public void comparisonPredicate() throws Exception {
        this.assertFilter("POP_RANK > 6", PropertyIsGreaterThan.class);
        this.assertFilter("Area(the_geom) < 3000", PropertyIsLessThan.class);
    }

    @Test
    public void relateGeoOperation() throws CQLException {
        PropertyIsEqualTo filter = this.assertFilter("RELATE(geometry,LINESTRING (-134.921387 58.687767, -135.303391 59.092838),T*****FF*)", PropertyIsEqualTo.class);
        Assert.assertTrue((String)"Relate Pattern Function was expected", (boolean)(filter.getExpression1() instanceof FilterFunction_relatePattern));
        Assert.assertTrue((String)"Literal TRUE was expected", (boolean)(filter.getExpression2() instanceof Literal));
    }

    @Test
    public void geoOperationPredicate() throws CQLException {
        this.assertFilter("INTERSECTS(the_geom, POINT (1 2))", Intersects.class);
        this.assertFilter("INTERSECTS(buffer(the_geom,10), POINT (1 2))", Intersects.class);
    }

    @Test
    public void dwithinGeometry() throws Exception {
        this.assertFilter("DWITHIN(buffer(the_geom,5), POINT (1 2), 10.0, kilometers)", DistanceBufferOperator.class);
    }

    @Test
    public void dwithinReferencedGeometry() throws Exception {
        this.assertFilter("DWITHIN(buffer(the_geom,5), SRID=3857;POINT (1 2), 10.0, kilometers)", DistanceBufferOperator.class);
    }

    @Test
    public void temporalPredicate() throws Exception {
        Filter filter = ECQL.toFilter((String)"ATTR1 BEFORE 2006-12-31T01:30:00Z");
        Assert.assertTrue((boolean)(filter instanceof Before));
        this.assertFilter("ATTR1 BEFORE 2006-12-31T01:30:00+00:00", Before.class);
    }

    @Test
    public void booleanPredicate() throws Exception {
        this.assertFilter("ATTR1 < 10 AND ATTR2 < 2", And.class);
        this.assertFilter("ATTR1 < 10 OR ATTR2 < 2", Or.class);
        this.assertFilter("NOT (ATTR < 10)", Not.class);
        this.assertFilter("(A = 1 OR B = 2) AND C = 3", And.class);
        this.assertFilter("(A = 1 OR B = 2) AND NOT (C = 3)", And.class);
    }

    @Test
    public void idPredicate() throws Exception {
        this.assertFilter("IN (1,2,3,4)", Id.class);
        this.assertFilter("IN ('river.1','river.2')", Id.class);
    }

    private <F extends Expression> F assertExpression(String ecql, Class<F> expected) throws CQLException {
        Expression expression = ECQL.toExpression((String)ecql);
        Assert.assertTrue((String)expected.getSimpleName(), (boolean)expected.isInstance(expression));
        Assert.assertEquals((String)ecql, (Object)ecql, (Object)ECQL.toCQL((Expression)expression));
        return (F)((Expression)expected.cast(expression));
    }

    private <F extends Filter> F assertFilter(String ecql, Class<F> type) throws CQLException {
        Filter filter = ECQL.toFilter((String)ecql);
        Assert.assertTrue((String)type.getSimpleName(), (boolean)type.isInstance(filter));
        Assert.assertEquals((String)ecql, (Object)ecql, (Object)ECQL.toCQL((Filter)filter));
        return (F)((Filter)type.cast(filter));
    }

    private <F extends Filter> F assertFilter(String ecql, String expected, Class<F> type) throws CQLException {
        Filter filter = ECQL.toFilter((String)ecql);
        Assert.assertEquals((String)ecql, (Object)expected, (Object)ECQL.toCQL((Filter)filter));
        return (F)((Filter)type.cast(filter));
    }

    @Test
    public void inPredicate() throws CQLException {
        this.assertFilter("length IN (4100001,4100002,4100003)", Or.class);
        this.assertFilter("A IN (1,2,3)", Or.class);
        this.assertFilter("(A IN (1,2,3)) OR B = 1", Or.class);
        this.assertFilter("(A IN (1,2,3)) OR (B = 1 AND C = 3)", Or.class);
        this.assertFilter("(A IN (1,2,3)) OR (B IN (4,5))", Or.class);
        this.assertFilter("(A IN (1,2,3)) AND (B IN (5,6,7,8))", And.class);
        this.assertFilter("(A = 1 OR A = 2)", "A IN (1,2)", Or.class);
        this.assertFilter("A = 1 OR A = 2 OR A = 3", "(A IN (1,2)) OR A = 3", Or.class);
    }

    @Test
    public void likePredicate() throws Exception {
        this.assertFilter("aProperty LIKE '%bb%'", PropertyIsLike.class);
        PropertyIsLike like = this.assertFilter("strToUpperCase(anAttribute) LIKE '%BB%'", PropertyIsLike.class);
        Assert.assertTrue((boolean)(like.getExpression() instanceof Function));
    }

    @Test
    public void isNullPredicate() throws Exception {
        this.assertFilter("centroid(the_geom) IS NULL", IsNullImpl.class);
    }

    @Test
    public void existProperty() throws Exception {
        PropertyIsEqualTo eq = this.assertFilter("aProperty EXISTS", PropertyIsEqualTo.class);
        Expression expr = eq.getExpression1();
        Assert.assertTrue((boolean)(expr instanceof PropertyExistsFunction));
    }

    @Test
    public void expression() throws Exception {
        this.assertExpression("A + 1", Add.class);
    }

    @Test
    public void listOfPredicates() throws Exception {
        List list = ECQL.toFilterList((String)"A=1; B<4");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof PropertyIsEqualTo));
        Assert.assertTrue((boolean)(list.get(1) instanceof PropertyIsLessThan));
    }

    @Test
    public void greaterFilterToCQL() throws Exception {
        String expectedECQL = "aProperty > -1";
        Filter filter = FilterECQLSample.getSample(expectedECQL);
        String resultECQL = ECQL.toCQL((Filter)filter);
        Assert.assertEquals((Object)expectedECQL, (Object)resultECQL);
    }

    @Test
    public void likeFilterToCQL() throws Exception {
        String expectedECQL = "'aabbcc' LIKE '%bb%'";
        Filter filter = FilterECQLSample.getSample(expectedECQL);
        String resultECQL = ECQL.toCQL((Filter)filter);
        Assert.assertEquals((Object)expectedECQL, (Object)resultECQL);
    }

    @Test
    public void functionExpressionToCQL() throws Exception {
        Expression[] absArgs = new Expression[1];
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        absArgs[0] = ff.literal(10);
        Function abs = ff.function("abs", absArgs);
        String resultECQL = ECQL.toCQL((Expression)abs);
        Assert.assertEquals((Object)"abs(10)", (Object)resultECQL);
    }

    @Test
    public void toFilterUsesProvidedFilterFactory() throws Exception {
        final boolean[] called = new boolean[]{false};
        FilterFactoryImpl ff = new FilterFactoryImpl(){

            public PropertyName property(String propName) {
                called[0] = true;
                return super.property(propName);
            }
        };
        ECQL.toFilter((String)"attName > 20", (FilterFactory)ff);
        Assert.assertTrue((String)"Provided FilterFactory was not called", (boolean)called[0]);
    }

    @Test
    public void filterListToECQL() throws Exception {
        String expectedECQL = "QUANTITY = 1; YEAR < 1963";
        List list = ECQL.toFilterList((String)expectedECQL);
        Assert.assertEquals((long)2L, (long)list.size());
        String cqlResult = ECQL.toCQL((List)list);
        Assert.assertEquals((Object)expectedECQL, (Object)cqlResult);
    }

    @Test
    public void filterListToECQLWithRefencedGeometries() throws Exception {
        String expectedECQL = "INTERSECTS(the_geom, SRID=4326;POINT (1 2)); INTERSECTS(abcd, SRID=4962;POINT (0 0))";
        List list = ECQL.toFilterList((String)expectedECQL);
        Assert.assertEquals((long)2L, (long)list.size());
        String cqlResult = ECQL.toCQL((List)list);
        Assert.assertEquals((Object)expectedECQL, (Object)cqlResult);
    }

    @Test
    public void filterToECQL() throws Exception {
        String expectedECQL = "QUANTITY = 1";
        Filter list = ECQL.toFilter((String)expectedECQL);
        String cqlResult = ECQL.toCQL((Filter)list);
        Assert.assertEquals((Object)expectedECQL, (Object)cqlResult);
    }

    @Test
    public void filterListToCQL() throws Exception {
        String expectedCQL = "QUANTITY = 1; YEAR < 1963";
        List list = CQL.toFilterList((String)expectedCQL);
        Assert.assertEquals((long)2L, (long)list.size());
        String cqlResult = CQL.toCQL((List)list);
        Assert.assertEquals((Object)expectedCQL, (Object)cqlResult);
    }

    @Test
    public void toExpressionUsesProvidedFilterFactory() throws Exception {
        final boolean[] called = new boolean[]{false};
        FilterFactoryImpl ff = new FilterFactoryImpl(){

            public PropertyName property(String propName) {
                called[0] = true;
                return super.property(propName);
            }
        };
        ECQL.toExpression((String)"attName", (FilterFactory)ff);
        Assert.assertTrue((String)"Provided FilterFactory was not called", (boolean)called[0]);
    }

    @Test
    public void testDivideEncode() throws Exception {
        FilterFactory2 filterFactory2 = CommonFactoryFinder.getFilterFactory2();
        PropertyIsLessThan javaFilter = filterFactory2.less((Expression)filterFactory2.divide((Expression)filterFactory2.property("population"), (Expression)filterFactory2.literal(2)), (Expression)filterFactory2.divide((Expression)filterFactory2.property("pop2000"), (Expression)filterFactory2.literal(2)));
        Assert.assertEquals((Object)"population/2<pop2000/2", (Object)ECQL.toCQL((Filter)javaFilter).replace(" ", ""));
    }

    @Test
    public void testQuotedComparison() throws Exception {
        Filter filter = ECQL.toFilter((String)"\"a\"=\"b\"");
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        PropertyIsEqualTo expected = ff.equal((Expression)ff.property("a"), (Expression)ff.property("b"), false);
        Assert.assertEquals((Object)expected, (Object)filter);
    }

    @Test
    public void colorLiterals() throws CQLException {
        String expected = "Interpolate(population,0,'#FF0000',10,'#0000FF')";
        Expression expr = ECQL.toExpression((String)expected);
        String actual = ECQL.toCQL((Expression)expr);
        Assert.assertEquals((String)"color literals", (Object)expected, (Object)actual);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Function function = ff.function("Interpolate", new Expression[]{ff.property("population"), ff.literal(0), ff.literal((Object)Color.RED), ff.literal(10), ff.literal((Object)Color.BLUE)});
        actual = ECQL.toCQL((Expression)function);
        Assert.assertEquals((String)"color literals", (Object)expected, (Object)actual);
    }
}

