/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import java.awt.Color;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.FilterToCQL;
import org.geotools.filter.text.ecql.ECQL;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

public class FilterToCQLTest {
    @Test
    public void testSample() throws Exception {
        Filter filter = CQL.toFilter((String)"ATTR1 < 1");
        FilterToCQL toCQL = new FilterToCQL();
        String output = filter.accept((FilterVisitor)toCQL, null).toString();
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((Object)"ATTR1 < 1", (Object)output);
    }

    @Test
    public void testNotBetween() throws Exception {
        this.cqlTest("NOT (ATTR1 BETWEEN 10 AND 20)");
    }

    @Test
    public void testANDOR() throws Exception {
        this.cqlTest("(ATTR1 < 10 AND ATTR2 < 2) OR ATTR3 > 10");
    }

    @Test
    public void testOR() throws Exception {
        this.cqlTest("ATTR1 > 10 OR ATTR2 < 2");
    }

    @Test
    public void testLike() throws Exception {
        this.cqlTest("ATTR1 LIKE '%ABC%'");
    }

    @Test
    public void testNotEqualTo() throws Exception {
        String cql = "ATTR1 <> 'foo'";
        Filter filter = CQL.toFilter((String)cql);
        Assert.assertNotNull((Object)filter);
        String cql2 = "NOT (ATTR1 = 'foo')";
        String output2 = CQL.toFilter((String)cql2).accept((FilterVisitor)new FilterToCQL(), null).toString();
        FilterToCQL toCQL = new FilterToCQL();
        String output = filter.accept((FilterVisitor)toCQL, null).toString();
        Assert.assertEquals((Object)output2, (Object)output);
    }

    @Test(expected=CQLException.class)
    public void testFailNotEqualTo() throws Exception {
        this.cqlTest("ATTR1 != 'foo'");
    }

    @Test
    public void testBbox() throws Exception {
        this.cqlTest("BBOX(the_geom, 10.0,20.0,30.0,40.0)");
    }

    @Test
    public void testAfter() throws Exception {
        this.cqlTest("attr AFTER 2006-12-31T01:30:00+00:00");
    }

    @Test
    public void testBefore() throws Exception {
        this.cqlTest("attr BEFORE 2006-12-31T01:30:00+00:00");
    }

    @Test
    public void testBeforeAndAfter() throws Exception {
        this.cqlTest("dateAttr AFTER 2006-10-10T01:30:00+00:00 AND dateAttr BEFORE 2010-12-31T01:30:00+00:00");
    }

    @Test
    public void testDuring() throws Exception {
        this.cqlTest("dateAttr DURING 2006-10-10T01:30:00+00:00/2010-12-31T01:30:00+00:00");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testEndedByUnsuported() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        EndedBy filter = ff.endedBy((Expression)ff.property("date"), (Expression)this.newSampleDate());
        FilterToCQL toCQL = new FilterToCQL();
        filter.accept((FilterVisitor)toCQL, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testEndsUnsuported() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Ends filter = ff.ends((Expression)ff.property("date"), (Expression)this.newSampleDate());
        FilterToCQL toCQL = new FilterToCQL();
        filter.accept((FilterVisitor)toCQL, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testMeetsUnsuported() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Meets filter = ff.meets((Expression)ff.property("date"), (Expression)this.newSampleDate());
        FilterToCQL toCQL = new FilterToCQL();
        filter.accept((FilterVisitor)toCQL, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testMetByUnsuported() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        MetBy filter = ff.metBy((Expression)ff.property("date"), (Expression)this.newSampleDate());
        FilterToCQL toCQL = new FilterToCQL();
        filter.accept((FilterVisitor)toCQL, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testOverlappedByUnsuported() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        OverlappedBy filter = ff.overlappedBy((Expression)ff.property("date"), (Expression)this.newSampleDate());
        FilterToCQL toCQL = new FilterToCQL();
        filter.accept((FilterVisitor)toCQL, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testTContainsUnsuported() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        TContains filter = ff.tcontains((Expression)ff.property("date"), (Expression)this.newSampleDate());
        FilterToCQL toCQL = new FilterToCQL();
        filter.accept((FilterVisitor)toCQL, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testTEqualsUnsuported() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        TEquals filter = ff.tequals((Expression)ff.property("date"), (Expression)this.newSampleDate());
        FilterToCQL toCQL = new FilterToCQL();
        filter.accept((FilterVisitor)toCQL, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testTOverlapsUnsuported() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        TOverlaps filter = ff.toverlaps((Expression)ff.property("date"), (Expression)this.newSampleDate());
        FilterToCQL toCQL = new FilterToCQL();
        filter.accept((FilterVisitor)toCQL, null);
    }

    protected Literal newSampleDate() throws ParseException {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Date dateTime = dateFormatter.parse("2006-11-30T01:30:00Z");
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        return ff.literal((Object)dateTime);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testBeginsUnsuported() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Begins filter = ff.begins((Expression)ff.property("date"), (Expression)this.newSampleDate());
        FilterToCQL toCQL = new FilterToCQL();
        filter.accept((FilterVisitor)toCQL, null);
    }

    @Test
    public void testColorLiteral() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        PropertyIsEqualTo filter = ff.equal((Expression)ff.property("color"), (Expression)ff.literal((Object)Color.RED), false);
        FilterToCQL toCQL = new FilterToCQL();
        StringBuilder cql = (StringBuilder)toCQL.visit(filter, null);
        Assert.assertEquals((Object)"color = '#FF0000'", (Object)cql.toString());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testBegunByUnsuported() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BegunBy filter = ff.begunBy((Expression)ff.property("date"), (Expression)this.newSampleDate());
        FilterToCQL toCQL = new FilterToCQL();
        filter.accept((FilterVisitor)toCQL, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAnyInteractsUnsuported() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        AnyInteracts filter = ff.anyInteracts((Expression)ff.property("date"), (Expression)this.newSampleDate());
        FilterToCQL toCQL = new FilterToCQL();
        filter.accept((FilterVisitor)toCQL, null);
    }

    @Test
    public void testIntersectsPoint() throws Exception {
        this.cqlTest("INTERSECTS(the_geom, POINT (1 2))");
    }

    @Test
    public void testIntersects() throws Exception {
        this.cqlTest("INTERSECTS(theGeom, POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0)))");
    }

    @Test
    public void testOverlaps() throws Exception {
        this.cqlTest("OVERLAPS(theGeom, POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0)))");
    }

    @Test
    public void testCrosses() throws Exception {
        this.cqlTest("CROSSES(theGeom, POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0)))");
    }

    @Test
    public void testContains() throws Exception {
        this.cqlTest("CONTAINS(theGeom, POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0)))");
    }

    @Test
    public void testTouches() throws Exception {
        this.cqlTest("TOUCHES(theGeom, POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0)))");
    }

    @Ignore
    @Test
    public void testAttributeContainsQuote() throws Exception {
        String cql = "INTERSECTS(\"the\"\"geom\", POINT (1 2))";
        Filter filter = CQL.toFilter((String)cql);
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)"the\"geom", (Object)((PropertyName)((Intersects)filter).getExpression1()).getPropertyName());
        FilterToCQL toCQL = new FilterToCQL();
        String output = filter.accept((FilterVisitor)toCQL, null).toString();
        Assert.assertEquals((Object)cql, (Object)output);
    }

    @Ignore
    @Test
    public void testAttributeContainsSpace() throws Exception {
        this.cqlTest("INTERSECTS(\"the geom\", POINT (1 2))");
    }

    @Test
    public void testAttributeContainsOperator() throws Exception {
        this.cqlTest("INTERSECTS(\"the-geom\", POINT (1 2))");
    }

    @Test
    public void testAttributeContainsComma() throws Exception {
        this.cqlTest("INTERSECTS(\"the,geom\", POINT (1 2))");
    }

    @Test
    public void testAttributeIsReservedUpperCase() throws Exception {
        this.cqlTest("INTERSECTS(\"POINT\", POINT (1 2))");
    }

    @Test
    public void testAttributeIsReservedLowerCase() throws Exception {
        this.cqlTest("INTERSECTS(\"point\", POINT (1 2))");
    }

    @Test
    public void testAttributeEqualsBoolean() throws Exception {
        this.cqlTest("foo = true");
    }

    @Test
    public void testFunctionOr() throws Exception {
        this.ecqlReparseTest("PropertyExists('name') = true OR PropertyExists('name') = false");
        this.ecqlReparseTest("PropertyExists('name') IN (true, false)");
    }

    protected void cqlTest(String cql) throws Exception {
        Filter filter = CQL.toFilter((String)cql);
        Assert.assertNotNull((Object)filter);
        FilterToCQL toCQL = new FilterToCQL();
        String output = filter.accept((FilterVisitor)toCQL, null).toString();
        Assert.assertEquals((Object)cql, (Object)output);
    }

    protected void ecqlReparseTest(String cql) throws Exception {
        Filter filter = ECQL.toFilter((String)cql);
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)ECQL.toFilter((String)ECQL.toCQL((Filter)filter)), (Object)filter);
    }
}

