/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.FilterCQLSample;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.Filter;

public class CQLLikePredicateTest {
    protected final Language language;

    public CQLLikePredicateTest() {
        this(Language.CQL);
    }

    protected CQLLikePredicateTest(Language language) {
        assert (language != null) : "language cannot be null";
        this.language = language;
    }

    @Test
    public void likePredicate() throws Exception {
        Filter resultFilter = this.parseFilter("ATTR1 LIKE 'abc%'");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Filter expected = FilterCQLSample.getSample("ATTR1 LIKE 'abc%'");
        Assert.assertEquals((String)"like filter was expected", (Object)expected, (Object)resultFilter);
    }

    protected Filter parseFilter(String likeFilter) throws CQLException {
        return CompilerUtil.parseFilter((Language)this.language, (String)likeFilter);
    }

    @Test
    public void notLikePredicate() throws Exception {
        Filter resultFilter = this.parseFilter("ATTR1 NOT LIKE 'abc%'");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Filter expected = FilterCQLSample.getSample("ATTR1 NOT LIKE 'abc%'");
        Assert.assertEquals((String)"like filter was expected", (Object)expected, (Object)resultFilter);
    }
}

