/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cqljson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.filter.text.commons.ICompiler;
import org.geotools.filter.text.commons.IToken;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cqljson.CQLJsonFilterBuilder;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.io.ParseException;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class CQLJsonCompiler
implements ICompiler {
    static final Logger LOGGER = Logging.getLogger(CQLJsonCompiler.class);
    private final String source;
    private final ObjectMapper mapper = new ObjectMapper();
    private CQLJsonFilterBuilder builder;
    private Filter filter;

    public CQLJsonCompiler(String cqlSource, FilterFactory2 filterFactory) {
        assert (filterFactory != null) : "filterFactory cannot be null";
        this.source = cqlSource;
        this.builder = new CQLJsonFilterBuilder(filterFactory);
    }

    public String getSource() {
        return this.source;
    }

    public void compileFilter() throws CQLException {
        try {
            JsonNode cql2Expression = this.mapper.readTree(this.source);
            this.filter = this.convertToFilter(cql2Expression);
        }
        catch (IOException | ParseException e) {
            throw new CQLException(e.getMessage());
        }
    }

    public Filter getFilter() throws CQLException {
        return this.filter;
    }

    public void compileExpression() throws CQLException {
    }

    public Expression getExpression() throws CQLException {
        return null;
    }

    public void compileFilterList() throws CQLException {
    }

    public List<Filter> getFilterList() throws CQLException {
        return null;
    }

    public IToken getTokenInPosition(int position) {
        return null;
    }

    public Filter convertToFilter(JsonNode cql2Expression) throws CQLException, IOException, ParseException {
        Filter out = null;
        if (this.isCql2Expression(cql2Expression)) {
            String op;
            switch (op = cql2Expression.get("op").textValue()) {
                case "like": {
                    out = this.builder.convertLike((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "=": {
                    out = this.builder.convertEquals((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "<>": {
                    out = this.builder.convertNotEquals((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case ">": {
                    out = this.builder.convertGreaterThan((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "<": {
                    out = this.builder.convertLessThan((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case ">=": {
                    out = this.builder.convertGreaterThanOrEq((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "<=": {
                    out = this.builder.convertLessThanOrEq((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "between": {
                    out = this.builder.convertBetween((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "in": {
                    out = this.builder.convertIn((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "isNull": {
                    out = this.builder.convertIsNull((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "or": {
                    out = this.builder.convertOr(this, (ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "and": {
                    out = this.builder.convertAnd(this, (ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "s_contains": {
                    out = this.builder.convertContains((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "s_crosses": {
                    out = this.builder.convertCrosses((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "s_disjoint": {
                    out = this.builder.convertDisjoint((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "s_equals": {
                    out = this.builder.convertSEquals((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "s_intersects": {
                    out = this.builder.convertIntersects((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "s_overlaps": {
                    out = this.builder.convertOverlaps((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "s_touches": {
                    out = this.builder.convertTouches((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "s_within": {
                    out = this.builder.convertWithin((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "not": {
                    out = this.builder.convertNot(this, (ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_after": {
                    out = this.builder.convertAfter((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_before": {
                    out = this.builder.convertBefore((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_disjoint": {
                    out = this.builder.convertTDisjoint((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_during": {
                    out = this.builder.convertDuring((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_equals": {
                    out = this.builder.convertEquals((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_finishedBy": {
                    out = this.builder.convertFinishedBy((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_finishing": {
                    out = this.builder.convertFinishing((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_intersects": {
                    out = this.builder.convertTIntersects((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_meets": {
                    out = this.builder.convertMeets((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_metBy": {
                    out = this.builder.convertMetBy((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_overlappedBy": {
                    out = this.builder.convertOverlappedBy((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_overlaps": {
                    out = this.builder.convertTOverlaps((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_startedBy": {
                    out = this.builder.convertStartedBy((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "t_starts": {
                    out = this.builder.convertStarts((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "a_containedBy": {
                    out = this.builder.convertAContainedBy((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "a_contains": {
                    out = this.builder.convertAContaining((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "a_equals": {
                    out = this.builder.convertArrayEquals((ArrayNode)cql2Expression.get("args"));
                    break;
                }
                case "a_overlaps": {
                    out = this.builder.convertAOverlaps((ArrayNode)cql2Expression.get("args"));
                }
            }
        }
        return out;
    }

    private boolean isCql2Expression(JsonNode node) {
        boolean out = false;
        if (node.getNodeType() == JsonNodeType.OBJECT && node.get("op") != null && node.get("op").getNodeType() == JsonNodeType.STRING && node.get("args") != null && node.get("args").getNodeType() == JsonNodeType.ARRAY) {
            return true;
        }
        return out;
    }
}

