/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cqljson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cqljson.CQLJsonCompiler;
import org.geotools.filter.text.cqljson.CQLJsonFilterBuilder;
import org.geotools.filter.text.cqljson.ExpressionToCQL2Json;
import org.geotools.filter.text.cqljson.FilterToCQL2Json;
import org.locationtech.jts.io.ParseException;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;

public class CQL2Json {
    private static ObjectMapper objectMapper = new ObjectMapper();

    private CQL2Json() {
    }

    public static JsonNode toCQL2Json(Filter filter) {
        FilterToCQL2Json toCQL2Json = new FilterToCQL2Json(objectMapper);
        return (JsonNode)filter.accept((FilterVisitor)toCQL2Json, (Object)objectMapper.createObjectNode());
    }

    public static String toCQL2(Filter filter) {
        return CQL2Json.toCQL2Json(filter).toString();
    }

    public static Filter toFilter(String cql2Json) throws CQLException {
        CQLJsonCompiler cqlJsonCompiler = new CQLJsonCompiler(cql2Json, (FilterFactory2)new FilterFactoryImpl());
        cqlJsonCompiler.compileFilter();
        return cqlJsonCompiler.getFilter();
    }

    public static String toCQL2(Expression expression) {
        return CQL2Json.toCQL2Json(expression).toString();
    }

    public static JsonNode toCQL2Json(Expression expression) {
        ExpressionToCQL2Json expVisitor = new ExpressionToCQL2Json(objectMapper);
        return (JsonNode)expression.accept((ExpressionVisitor)expVisitor, (Object)objectMapper.createArrayNode());
    }

    public static Expression toExpression(String cql2Json) throws CQLException, IOException, ParseException {
        CQLJsonFilterBuilder cqlJsonFilterBuilder = new CQLJsonFilterBuilder((FilterFactory2)new FilterFactoryImpl());
        return cqlJsonFilterBuilder.getExpression(objectMapper.readTree(cql2Json));
    }
}

