/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.utils.imagepyramid;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.utils.CoverageToolsConstants;
import org.geotools.utils.progress.BaseArgumentsManager;
import org.geotools.utils.progress.ExceptionEvent;
import org.geotools.utils.progress.ProcessingEvent;
import org.geotools.utils.progress.ProcessingEventListener;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class PyramidLayerBuilder
extends BaseArgumentsManager
implements Runnable,
ProcessingEventListener {
    private static Set<String> scalingAlgorithms = new HashSet<String>();
    private static Set<String> outputFormats;
    private static final Logger LOGGER;
    private static final String VERSION = "0.3";
    private static final String NAME = "PyramidLayerBuilder";
    private Option inputLocationOpt = this.optionBuilder.withShortName("s").withLongName("source_directory").withArgument(this.argumentBuilder.withName("source").withMinimum(1).withMaximum(1).withValidator(new Validator(){

        public void validate(List args) throws InvalidArgumentException {
            int size = args.size();
            if (size > 1) {
                throw new InvalidArgumentException("Only one location can be chosen");
            }
            File source = new File((String)args.get(0));
            if (!source.isFile() || !source.exists()) {
                throw new InvalidArgumentException("The provided source is invalid! ");
            }
        }
    }).create()).withDescription("path where files are located").withRequired(true).create();
    private Option outputLocationOpt = this.optionBuilder.withShortName("d").withLongName("dest_directory").withArgument(this.argumentBuilder.withName("destination").withMinimum(0).withMaximum(1).create()).withDescription("output directory, if none is provided, the \"tiled\" directory will be used").withRequired(false).create();
    private Option tileDimOpt = this.optionBuilder.withShortName("t").withLongName("tiled_dimension").withArgument(this.argumentBuilder.withName("t").withMinimum(1).withMaximum(1).create()).withDescription("tile dimensions as a couple width,height in pixels").withRequired(true).create();
    private Option scaleAlgorithmOpt;
    private Option outFormatOpt;
    private double tileW;
    private double tileH;
    private File inputLocation;
    private File outputLocation;
    private String scaleAlgorithm;
    private String outputFormat;
    private Option scaleFactorOpt = this.optionBuilder.withShortName("f").withLongName("scale_factor").withArgument(this.argumentBuilder.withName("f").withMinimum(1).withMaximum(1).withValidator(new Validator(){

        public void validate(List args) throws InvalidArgumentException {
            int size = args.size();
            if (size > 1) {
                throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
            }
            int factor = Integer.parseInt((String)args.get(0));
            if (factor <= 0) {
                throw new InvalidArgumentException("The provided scale factor is negative! ");
            }
            if (factor == 1) {
                LOGGER.warning("The scale factor is 1!");
                System.exit(0);
            }
        }
    }).create()).withDescription("integer scale factor").withRequired(true).create();
    private int scaleFactor;
    private Option compressionRatioOpt;
    private Option compressionTypeOpt;
    private Option internalTileDimOpt;
    private int internalTileWidth = 512;
    private int internalTileHeight = 512;
    private String compressionScheme = "LZW";
    private double compressionRatio = 0.75;

    public PyramidLayerBuilder() {
        super(NAME, VERSION);
        this.scaleAlgorithmOpt = this.optionBuilder.withShortName("a").withLongName("scaling_algorithm").withArgument(this.argumentBuilder.withName("a").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                if (!scalingAlgorithms.contains(args.get(0))) {
                    throw new InvalidArgumentException("The output format " + args.get(0) + " is not permitted");
                }
            }
        }).create()).withDescription("name of the scaling algorithm, eeither one of average (a), filtered\t (f), bilinear (bil), nearest neigbhor (nn)").withRequired(false).create();
        this.outFormatOpt = this.optionBuilder.withShortName("o").withLongName("out_format").withArgument(this.argumentBuilder.withName("o").withMinimum(0).withMaximum(1).withDescription("output format").withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one output format at a time can be specified");
                }
                if (!outputFormats.contains(args.get(0))) {
                    throw new InvalidArgumentException("The output format " + args.get(0) + " is not permitted");
                }
            }
        }).create()).withDescription("output format").withRequired(false).create();
        this.compressionTypeOpt = this.optionBuilder.withShortName("z").withLongName("compressionType").withDescription("compression type.").withArgument(this.argumentBuilder.withName("compressionType").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
            }
        }).create()).withRequired(false).create();
        this.compressionRatioOpt = this.optionBuilder.withShortName("r").withLongName("compressionRatio").withDescription("compression ratio.").withArgument(this.argumentBuilder.withName("compressionRatio").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                String val = (String)args.get(0);
                double value = Double.parseDouble(val);
                if (value <= 0.0 || value > 1.0) {
                    throw new InvalidArgumentException("Invalid compressio ratio");
                }
            }
        }).create()).withRequired(false).create();
        this.internalTileDimOpt = this.optionBuilder.withShortName("it").withLongName("internal_tile_dimension").withArgument(this.argumentBuilder.withName("it").withMinimum(0).withMaximum(1).create()).withDescription("Internal width and height of each tile we generate").withRequired(false).create();
        this.addOption(this.compressionTypeOpt);
        this.addOption(this.compressionRatioOpt);
        this.addOption(this.inputLocationOpt);
        this.addOption(this.tileDimOpt);
        this.addOption(this.scaleFactorOpt);
        this.addOption(this.scaleAlgorithmOpt);
        this.addOption(this.internalTileDimOpt);
        this.finishInitialization();
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException, InterruptedException {
        PyramidLayerBuilder pyramidBuilder = new PyramidLayerBuilder();
        pyramidBuilder.addProcessingEventListener(pyramidBuilder);
        if (pyramidBuilder.parseArgs(args)) {
            Thread t = new Thread((Runnable)pyramidBuilder, "PyramidBuilder");
            t.setPriority(pyramidBuilder.getPriority());
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else {
            LOGGER.fine("Exiting...");
        }
    }

    @Override
    public boolean parseArgs(String[] args) {
        if (!super.parseArgs(args)) {
            return false;
        }
        this.inputLocation = new File((String)this.getOptionValue(this.inputLocationOpt));
        String tileDim = (String)this.getOptionValue(this.tileDimOpt);
        String[] pairs = tileDim.split(",");
        this.tileW = Integer.parseInt(pairs[0]);
        this.tileH = Integer.parseInt(pairs[1]);
        String scaleF = (String)this.getOptionValue(this.scaleFactorOpt);
        this.scaleFactor = Integer.parseInt(scaleF);
        this.outputLocation = this.hasOption(this.outputLocationOpt) ? new File((String)this.getOptionValue(this.outputLocationOpt)) : new File(this.inputLocation.getParentFile(), String.valueOf(this.scaleFactor));
        this.scaleAlgorithm = (String)this.getOptionValue(this.scaleAlgorithmOpt);
        if (this.scaleAlgorithm == null) {
            this.scaleAlgorithm = "nn";
        }
        this.outputFormat = (String)this.getOptionValue(this.outFormatOpt);
        return true;
    }

    @Override
    public void run() {
        StringBuilder message = new StringBuilder("Requested scale factor is ").append(this.scaleFactor);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        message = new StringBuilder("Acquiring a mosaic reader to mosaic ").append(this.inputLocation);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        ImageMosaicReader inReader = null;
        try {
            inReader = new ImageMosaicReader((Object)this.inputLocation, new Hints((RenderingHints.Key)Hints.OVERVIEW_POLICY, (Object)OverviewPolicy.IGNORE));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            this.fireException(e);
            return;
        }
        if (!this.outputLocation.exists()) {
            this.outputLocation.mkdir();
        }
        GeneralEnvelope envelope = inReader.getOriginalEnvelope();
        message = new StringBuilder("Original envelope is ").append(envelope.toString());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        GridEnvelope range = inReader.getOriginalGridRange();
        message = new StringBuilder("Original range is ").append(range.toString());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        double newWidth = (double)range.getSpan(0) * 1.0 / (double)this.scaleFactor;
        double newHeight = (double)range.getSpan(1) * 1.0 / (double)this.scaleFactor;
        if (this.tileW > newWidth) {
            this.tileW = newWidth;
        }
        if (this.tileH > newHeight) {
            this.tileH = newHeight;
        }
        message = new StringBuilder("New dimension is (W,H)==(").append(newWidth).append(",").append(newHeight).append(")");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        int newCols = (int)(newWidth / this.tileW);
        int newRows = (int)(newHeight / this.tileH);
        boolean hasRemainingColum = newWidth % this.tileW != 0.0;
        boolean hasRemainingRow = newHeight % this.tileH != 0.0;
        message = new StringBuilder("New matrix dimension is (cols,rows)==(").append(newCols).append(",").append(newRows).append(")");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        double minx = envelope.getMinimum(0);
        double miny = envelope.getMinimum(1);
        double maxx = envelope.getMaximum(0);
        double maxy = envelope.getMaximum(1);
        double _maxx = 0.0;
        double _maxy = 0.0;
        double _minx = 0.0;
        double _miny = 0.0;
        double totalNumberOfFile = (newRows += hasRemainingRow ? 1 : 0) * (newCols += hasRemainingColum ? 1 : 0);
        double tileGeoWidth = envelope.getSpan(0) / (double)newCols;
        double tileGeoHeight = envelope.getSpan(1) / (double)newRows;
        int[] uppers = range.getHigh().getCoordinateValues();
        uppers[0] = uppers[0] + 1;
        uppers[1] = uppers[1] + 1;
        double[] newRange = new double[]{uppers[0] / newCols, uppers[1] / newRows};
        CoverageProcessor processor = CoverageProcessor.getInstance();
        for (int i = 0; i < newRows; ++i) {
            for (int j = 0; j < newCols; ++j) {
                GridCoverage2D gc;
                File fileOut;
                _maxx = minx + (double)(j + 1) * tileGeoWidth;
                _minx = minx + (double)j * tileGeoWidth;
                _maxy = miny + (double)(i + 1) * tileGeoHeight;
                _miny = miny + (double)i * tileGeoHeight;
                if (_maxx > maxx) {
                    _maxx = maxx;
                }
                if (_maxy > maxy) {
                    _maxy = maxy;
                }
                if ((fileOut = new File(this.outputLocation, "mosaic" + "_" + Integer.toString(i * newCols + j) + "." + "tiff")).exists()) {
                    fileOut.delete();
                }
                message = new StringBuilder("Preparing tile (col,row)==(").append(j).append(",").append(i).append(") to file ").append(fileOut);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)(j + i * newCols) / totalNumberOfFile);
                ParameterValue gg = ImageMosaicFormat.READ_GRIDGEOMETRY2D.createValue();
                GeneralEnvelope cropEnvelope = new GeneralEnvelope(new double[]{_minx, _miny}, new double[]{_maxx, _maxy});
                cropEnvelope.setCoordinateReferenceSystem(inReader.getCrs());
                gg.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(new Rectangle(0, 0, 800, 800)), (Envelope)cropEnvelope));
                message = new StringBuilder("Reading with grid envelope ").append(cropEnvelope.toString());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)(j + i * newCols) / totalNumberOfFile);
                try {
                    gc = inReader.read(new GeneralParameterValue[]{gg});
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    this.fireEvent(e.getLocalizedMessage(), 0.0);
                    return;
                }
                ParameterValueGroup param = processor.getOperation("CoverageCrop").getParameters();
                param.parameter("Source").setValue((Object)gc);
                param.parameter("Envelope").setValue((Object)cropEnvelope);
                param.parameter("ConserveEnvelope").setValue((Object)Boolean.TRUE);
                GridCoverage2D cropped = (GridCoverage2D)processor.doOperation(param);
                GridEnvelope2D newGridrange = new GridEnvelope2D(new Rectangle2D.Double(0.0, 0.0, newRange[0], newRange[1]).getBounds());
                GridGeometry2D scaledGridGeometry = new GridGeometry2D((GridEnvelope)newGridrange, (Envelope)cropEnvelope);
                param = processor.getOperation("Resample").getParameters();
                param.parameter("Source").setValue((Object)cropped);
                param.parameter("CoordinateReferenceSystem").setValue((Object)inReader.getCrs());
                param.parameter("GridGeometry").setValue((Object)scaledGridGeometry);
                param.parameter("InterpolationType").setValue((Object)Interpolation.getInstance((int)0));
                gc = (GridCoverage2D)processor.doOperation(param);
                message = new StringBuilder("Scaling...");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), 0.0);
                if (this.scaleAlgorithm.equalsIgnoreCase("nn")) {
                    param = processor.getOperation("Scale").getParameters();
                    param.parameter("Source").setValue((Object)gc);
                    param.parameter("xScale").setValue((Object)new Float(1.0 / (double)this.scaleFactor));
                    param.parameter("yScale").setValue((Object)new Float(1.0 / (double)this.scaleFactor));
                    param.parameter("xTrans").setValue((Object)new Float(0.0f));
                    param.parameter("yTrans").setValue((Object)new Float(0.0f));
                    param.parameter("Interpolation").setValue((Object)Interpolation.getInstance((int)1));
                    gc = (GridCoverage2D)CoverageToolsConstants.SCALE_FACTORY.doOperation(param, new Hints());
                } else if (this.scaleAlgorithm.equalsIgnoreCase("filt")) {
                    param = CoverageToolsConstants.FILTERED_SUBSAMPLE_FACTORY.getParameters();
                    param.parameter("source").setValue((Object)gc);
                    param.parameter("scaleX").setValue((Object)new Integer(this.scaleFactor));
                    param.parameter("scaleY").setValue((Object)new Integer(this.scaleFactor));
                    param.parameter("qsFilterArray").setValue((Object)new float[]{0.5f, 0.33333334f, 0.0f, -0.083333336f});
                    param.parameter("Interpolation").setValue((Object)new InterpolationNearest());
                    gc = (GridCoverage2D)CoverageToolsConstants.FILTERED_SUBSAMPLE_FACTORY.doOperation(param, new Hints());
                } else if (this.scaleAlgorithm.equalsIgnoreCase("bil")) {
                    param = processor.getOperation("Scale").getParameters();
                    param.parameter("Source").setValue((Object)gc);
                    param.parameter("xScale").setValue((Object)new Float(1.0 / (double)this.scaleFactor));
                    param.parameter("yScale").setValue((Object)new Float(1.0 / (double)this.scaleFactor));
                    param.parameter("xTrans").setValue((Object)new Float(0.0f));
                    param.parameter("yTrans").setValue((Object)new Float(0.0f));
                    param.parameter("Interpolation").setValue((Object)Interpolation.getInstance((int)1));
                    gc = (GridCoverage2D)CoverageToolsConstants.SCALE_FACTORY.doOperation(param, new Hints());
                } else if (this.scaleAlgorithm.equalsIgnoreCase("avg")) {
                    param = processor.getOperation("SubsampleAverage").getParameters();
                    param.parameter("Source").setValue((Object)gc);
                    param.parameter("scaleX").setValue((Object)new Double(1.0 / (double)this.scaleFactor));
                    param.parameter("scaleY").setValue((Object)new Double(1.0 / (double)this.scaleFactor));
                    param.parameter("Interpolation").setValue(this.scaleFactor);
                    gc = (GridCoverage2D)CoverageToolsConstants.SUBSAMPLE_AVERAGE_FACTORY.doOperation(param, new Hints());
                } else {
                    throw new IllegalArgumentException("The provided scale algorithm is not availaible");
                }
                message = new StringBuilder("Writing out...");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)(j + i * newCols) / totalNumberOfFile);
                try {
                    GeoTiffWriter writerWI = new GeoTiffWriter((Object)fileOut);
                    GeoToolsWriteParams wp = ((AbstractGridFormat)writerWI.getFormat()).getDefaultImageIOWriteParameters();
                    if (this.compressionScheme != null) {
                        wp.setCompressionMode(2);
                        wp.setCompressionType(this.compressionScheme);
                        wp.setCompressionQuality((float)this.compressionRatio);
                    }
                    wp.setTilingMode(2);
                    wp.setTiling(this.internalTileWidth, this.internalTileHeight, 0, 0);
                    writerWI.write((GridCoverage)gc, null);
                    writerWI.dispose();
                    continue;
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    this.fireEvent(e.getLocalizedMessage(), 0.0);
                    return;
                }
            }
        }
        message = new StringBuilder("Done...");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 100.0);
    }

    @Override
    public void getNotification(ProcessingEvent event) {
        LOGGER.info("Progress is at " + event.getPercentage() + "\n" + "attached message is: " + event.getMessage());
    }

    @Override
    public void exceptionOccurred(ExceptionEvent event) {
        LOGGER.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    public void setInputLocation(File inputLocation) {
        this.inputLocation = inputLocation;
    }

    public void setOutputLocation(File outputLocation) {
        this.outputLocation = outputLocation;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getScaleAlgorithm() {
        return this.scaleAlgorithm;
    }

    public void setScaleAlgorithm(String scaleAlgorithm) {
        this.scaleAlgorithm = scaleAlgorithm;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(int scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public File getInputLocation() {
        return this.inputLocation;
    }

    public File getOutputLocation() {
        return this.outputLocation;
    }

    public double getTileHeight() {
        return this.tileH;
    }

    public void setTileHeight(int tileH) {
        this.tileH = tileH;
    }

    public double getTileWidth() {
        return this.tileW;
    }

    public void setTileWidth(int tileW) {
        this.tileW = tileW;
    }

    public double getCompressionRatio() {
        return this.compressionRatio;
    }

    public String getCompressionScheme() {
        return this.compressionScheme;
    }

    public void setCompressionRatio(double compressionRatio) {
        this.compressionRatio = compressionRatio;
    }

    public void setCompressionScheme(String compressionScheme) {
        this.compressionScheme = compressionScheme;
    }

    public int getInternalTileHeight() {
        return this.internalTileHeight;
    }

    public int getInternalTileWidth() {
        return this.internalTileWidth;
    }

    public void setInternalTileHeight(int internalTileHeight) {
        this.internalTileHeight = internalTileHeight;
    }

    public void setInternalTileWidth(int internalTileWidth) {
        this.internalTileWidth = internalTileWidth;
    }

    static {
        scalingAlgorithms.add("nn");
        scalingAlgorithms.add("bil");
        scalingAlgorithms.add("avg");
        scalingAlgorithms.add("filt");
        outputFormats = new HashSet<String>();
        outputFormats.add("tiff");
        outputFormats.add("tif");
        outputFormats.add("gtiff");
        outputFormats.add("gtif");
        outputFormats.add("png");
        outputFormats.add("jpeg");
        LOGGER = Logging.getLogger((String)PyramidLayerBuilder.class.toString());
    }
}

