/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.utils.imageoverviews;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.operator.ScaleDescriptor;
import org.geotools.resources.image.ImageUtilities;

class Utils {
    Utils() {
    }

    static ImageLayout createTiledLayout(int tileWidth, int tileHeight, int tileGrdiOffseX, int tileGrdiOffseY) {
        ImageLayout layout = new ImageLayout();
        layout.setTileGridXOffset(tileGrdiOffseX);
        layout.setTileGridYOffset(tileGrdiOffseY);
        layout.setValid(16);
        layout.setValid(32);
        layout.setTileWidth(tileWidth);
        layout.setTileHeight(tileHeight);
        layout.setValid(128);
        layout.setValid(64);
        return layout;
    }

    static RenderedOp filteredSubsample(RenderedImage src, TileCache scaleTC, int downsampleStep, float[] lowPassFilter) {
        RenderingHints newHints = new RenderingHints(JAI.KEY_TILE_CACHE, scaleTC);
        newHints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        ParameterBlockJAI pb = new ParameterBlockJAI("filteredsubsample");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Integer(downsampleStep));
        pb.setParameter("scaleY", (Object)new Integer(downsampleStep));
        pb.setParameter("qsFilterArray", (Object)lowPassFilter);
        pb.setParameter("Interpolation", (Object)new InterpolationNearest());
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb, (RenderingHints)newHints);
    }

    static RenderedOp scaleAverage(RenderedImage src, TileCache scaleTC, int downsampleStep, BorderExtender borderExtender) {
        RenderingHints newHints = new RenderingHints(JAI.KEY_TILE_CACHE, scaleTC);
        newHints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        newHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, borderExtender));
        ParameterBlockJAI pb = new ParameterBlockJAI("SubsampleAverage");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Double(1.0 / (double)downsampleStep));
        pb.setParameter("scaleY", (Object)new Double(1.0 / (double)downsampleStep));
        return JAI.create((String)"SubsampleAverage", (ParameterBlock)pb, (RenderingHints)newHints);
    }

    static RenderedOp subsample(RenderedOp src, TileCache scaleTC, Interpolation interpolation, int downsampleStep, BorderExtender borderExtender) {
        RenderingHints newHints = new RenderingHints(JAI.KEY_TILE_CACHE, scaleTC);
        newHints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        newHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, borderExtender));
        return ScaleDescriptor.create((RenderedImage)src, (Float)Float.valueOf(1.0f / (float)downsampleStep), (Float)Float.valueOf(1.0f / (float)downsampleStep), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)interpolation, (RenderingHints)newHints);
    }
}

