/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import org.geotools.api.coverage.CannotEvaluateException;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.geometry.PixelTranslation;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.TransformedPosition;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.DimensionFilter;
import org.geotools.util.Classes;
import org.geotools.util.factory.Hints;

public class GridGeometry2D
extends GeneralGridGeometry {
    private static final long serialVersionUID = -3989363771504614419L;
    private static volatile ReferencingFactoryContainer FACTORIES;
    private final CoordinateReferenceSystem crs2D;
    public final int gridDimensionX;
    public final int gridDimensionY;
    public final int axisDimensionX;
    public final int axisDimensionY;
    private final MathTransform2D gridToCRS2D;
    private final MathTransform2D gridFromCRS2D;
    private MathTransform2D cornerToCRS2D;
    private transient MathTransform2D crsToCorner2D;
    private transient TransformedPosition arbitraryToInternal;

    private boolean isValid() {
        if (this.gridToCRS != null) {
            int sourceDim = this.gridToCRS.getSourceDimensions();
            int targetDim = this.gridToCRS.getTargetDimensions();
            assert (this.gridToCRS.equals(this.gridToCRS2D) == (sourceDim == 2 && targetDim == 2));
            assert (!this.gridToCRS2D.equals(this.cornerToCRS2D));
            assert (this.gridRange == null || sourceDim == this.gridRange.getDimension()) : this.gridRange;
            assert (this.envelope == null || targetDim == this.envelope.getDimension()) : this.envelope;
            assert (this.gridDimensionY < sourceDim) : this.gridDimensionY;
            assert (this.axisDimensionY < targetDim) : this.axisDimensionY;
        }
        assert (this.gridDimensionX < this.gridDimensionY) : this.gridDimensionX;
        assert (this.axisDimensionX < this.axisDimensionY) : this.axisDimensionX;
        return this.crs2D == null || this.crs2D.getCoordinateSystem().getDimension() == 2;
    }

    GridGeometry2D(GridGeometry2D gm, CoordinateReferenceSystem crs) {
        super(gm, crs);
        this.gridDimensionX = gm.gridDimensionX;
        this.gridDimensionY = gm.gridDimensionY;
        this.axisDimensionX = gm.axisDimensionX;
        this.axisDimensionY = gm.axisDimensionY;
        this.gridFromCRS2D = gm.gridFromCRS2D;
        this.gridToCRS2D = gm.gridToCRS2D;
        this.cornerToCRS2D = gm.cornerToCRS2D;
        this.crs2D = this.createCRS2D();
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(GridGeometry other) {
        super(other);
        if (other instanceof GridGeometry2D) {
            GridGeometry2D gg = (GridGeometry2D)other;
            this.gridToCRS2D = gg.gridToCRS2D;
            this.gridFromCRS2D = gg.gridFromCRS2D;
            this.gridDimensionX = gg.gridDimensionX;
            this.gridDimensionY = gg.gridDimensionY;
            this.axisDimensionX = gg.axisDimensionX;
            this.axisDimensionY = gg.axisDimensionY;
            this.crs2D = gg.crs2D;
            this.cornerToCRS2D = gg.cornerToCRS2D;
        } else {
            int[] dimensions = new int[4];
            this.gridToCRS2D = GridGeometry2D.getMathTransform2D(this.gridToCRS, this.gridRange, dimensions, null);
            this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
            this.gridDimensionX = dimensions[0];
            this.gridDimensionY = dimensions[1];
            this.axisDimensionX = dimensions[2];
            this.axisDimensionY = dimensions[3];
            this.crs2D = this.createCRS2D();
        }
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(GridEnvelope gridRange, MathTransform gridToCRS, CoordinateReferenceSystem crs) throws IllegalArgumentException, MismatchedDimensionException {
        this(gridRange, PixelInCell.CELL_CENTER, gridToCRS, crs, null);
    }

    public GridGeometry2D(GridEnvelope gridRange, PixelInCell anchor, MathTransform gridToCRS, CoordinateReferenceSystem crs, Hints hints) throws MismatchedDimensionException, IllegalArgumentException {
        super(gridRange, anchor, gridToCRS, crs);
        int[] dimensions = new int[4];
        this.gridToCRS2D = GridGeometry2D.getMathTransform2D(this.gridToCRS, gridRange, dimensions, hints);
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.gridDimensionX = dimensions[0];
        this.gridDimensionY = dimensions[1];
        this.axisDimensionX = dimensions[2];
        this.axisDimensionY = dimensions[3];
        this.crs2D = this.createCRS2D();
        if (PixelInCell.CELL_CORNER.equals((Object)anchor)) {
            this.cornerToCRS2D = GridGeometry2D.getMathTransform2D(gridToCRS, gridRange, dimensions, hints);
        }
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(GridEnvelope gridRange, PixelOrientation anchor, MathTransform gridToCRS, CoordinateReferenceSystem crs, Hints hints) throws IllegalArgumentException, MismatchedDimensionException {
        this(gridRange, anchor, gridToCRS, new int[4], crs, hints);
    }

    private GridGeometry2D(GridEnvelope gridRange, PixelOrientation anchor, MathTransform gridToCRS, int[] dimensions, CoordinateReferenceSystem crs, Hints hints) {
        this(gridRange, anchor, gridToCRS != null && gridToCRS.getSourceDimensions() == 2 && gridToCRS.getTargetDimensions() == 2 && PixelOrientation.UPPER_LEFT.equals((Object)anchor) ? PixelInCell.CELL_CORNER : PixelInCell.CELL_CENTER, gridToCRS, GridGeometry2D.getMathTransform2D(gridToCRS, gridRange, dimensions, hints), dimensions, crs);
    }

    private GridGeometry2D(GridEnvelope gridRange, PixelOrientation anchor, PixelInCell anchorND, MathTransform gridToCRS, MathTransform2D gridToCRS2D, int[] dimensions, CoordinateReferenceSystem crs) {
        super(gridRange, anchorND, PixelTranslation.translate((MathTransform)gridToCRS, (PixelOrientation)anchor, (PixelOrientation)PixelTranslation.getPixelOrientation((PixelInCell)anchorND), (int)dimensions[0], (int)dimensions[1]), crs);
        this.gridDimensionX = dimensions[0];
        this.gridDimensionY = dimensions[1];
        this.axisDimensionX = dimensions[2];
        this.axisDimensionY = dimensions[3];
        if (gridToCRS == gridToCRS2D) {
            this.gridToCRS2D = (MathTransform2D)this.gridToCRS;
        } else {
            int xdim = this.gridDimensionX < this.gridDimensionY ? 0 : 1;
            this.gridToCRS2D = (MathTransform2D)PixelTranslation.translate((MathTransform)gridToCRS2D, (PixelOrientation)anchor, (PixelOrientation)PixelOrientation.CENTER, (int)xdim, (int)(xdim ^ 1));
        }
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.crs2D = this.createCRS2D();
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(PixelInCell anchor, MathTransform gridToCRS, Bounds envelope, Hints hints) throws MismatchedDimensionException, IllegalArgumentException {
        super(anchor, gridToCRS, envelope);
        int[] dimensions = new int[4];
        this.gridToCRS2D = GridGeometry2D.getMathTransform2D(this.gridToCRS, this.gridRange, dimensions, hints);
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.gridDimensionX = dimensions[0];
        this.gridDimensionY = dimensions[1];
        this.axisDimensionX = dimensions[2];
        this.axisDimensionY = dimensions[3];
        this.crs2D = this.createCRS2D();
        if (PixelInCell.CELL_CORNER.equals((Object)anchor)) {
            this.cornerToCRS2D = GridGeometry2D.getMathTransform2D(gridToCRS, this.gridRange, dimensions, hints);
        }
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(GridEnvelope gridRange, Bounds userRange) throws IllegalArgumentException, MismatchedDimensionException {
        this(gridRange, userRange, null, false, true);
    }

    private GridGeometry2D(GridEnvelope gridRange, Bounds userRange, boolean[] reverse, boolean swapXY, boolean automatic) throws IllegalArgumentException, MismatchedDimensionException {
        super(gridRange, userRange, reverse, swapXY, automatic);
        int[] dimensions = new int[4];
        this.gridToCRS2D = GridGeometry2D.getMathTransform2D(this.gridToCRS, gridRange, dimensions, null);
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.gridDimensionX = dimensions[0];
        this.gridDimensionY = dimensions[1];
        this.axisDimensionX = dimensions[2];
        this.axisDimensionY = dimensions[3];
        this.crs2D = this.createCRS2D();
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(Rectangle gridRange, Rectangle2D userRange) {
        this(gridRange instanceof GridEnvelope2D ? (GridEnvelope2D)gridRange : new GridEnvelope2D(gridRange), (Bounds)(userRange instanceof Bounds ? (Bounds)userRange : ReferencedEnvelope.create((Rectangle2D)userRange, null)));
    }

    public static GridGeometry2D wrap(GridGeometry other) {
        if (other == null || other instanceof GridGeometry2D) {
            return (GridGeometry2D)other;
        }
        return new GridGeometry2D(other);
    }

    private static MathTransform2D getMathTransform2D(MathTransform transform, GridEnvelope gridRange, int[] axis, Hints hints) throws IllegalArgumentException {
        if (transform == null || transform instanceof MathTransform2D) {
            axis[3] = 1;
            axis[1] = 1;
            return (MathTransform2D)transform;
        }
        DimensionFilter filter = DimensionFilter.getInstance((Hints)hints);
        if (gridRange != null) {
            int dimension = gridRange.getDimension();
            for (int i = 0; i < dimension; ++i) {
                if (gridRange.getSpan(i) <= 1) continue;
                filter.addSourceDimension(i);
            }
        } else {
            filter.addSourceDimensionRange(0, 2);
        }
        Throwable cause = null;
        int[] dimensions = filter.getSourceDimensions();
        if (dimensions.length == 2) {
            axis[0] = dimensions[0];
            axis[1] = dimensions[1];
            try {
                MathTransform candidate = filter.separate(transform);
                if (candidate.getTargetDimensions() != 2) {
                    filter.clear();
                    filter.addSourceDimensions(dimensions);
                    filter.addTargetDimensions(dimensions);
                    candidate = filter.separate(transform);
                }
                dimensions = filter.getTargetDimensions();
                axis[2] = dimensions[0];
                axis[3] = dimensions[1];
                try {
                    return (MathTransform2D)candidate;
                }
                catch (ClassCastException exception) {
                    cause = exception;
                }
            }
            catch (FactoryException exception) {
                cause = exception;
            }
        }
        throw new IllegalArgumentException("No two-dimensional transform available for this geometry.", cause);
    }

    private static MathTransform2D inverse(MathTransform2D gridToCRS2D) throws IllegalArgumentException {
        if (gridToCRS2D == null) {
            return null;
        }
        try {
            return gridToCRS2D.inverse();
        }
        catch (NoninvertibleTransformException exception) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal transform of type \"{0}\".", Classes.getClass((Object)gridToCRS2D)), exception);
        }
    }

    private CoordinateReferenceSystem createCRS2D() throws InvalidGridGeometryException {
        if (!super.isDefined(1)) {
            return null;
        }
        CoordinateReferenceSystem crs = super.getCoordinateReferenceSystem();
        try {
            crs = this.reduce(crs);
        }
        catch (FactoryException exception) {
            ReferenceIdentifier arg1 = crs.getName();
            throw new InvalidGridGeometryException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "crs", arg1), exception);
        }
        return crs;
    }

    public ReferencedEnvelope reduce(Bounds bounds) {
        if (bounds == null) {
            return null;
        }
        return new ReferencedEnvelope(bounds.getMinimum(this.axisDimensionX), bounds.getMinimum(this.axisDimensionY), bounds.getSpan(this.axisDimensionX), bounds.getSpan(this.axisDimensionY), this.crs2D);
    }

    public CoordinateReferenceSystem reduce(CoordinateReferenceSystem crs) throws FactoryException {
        if (crs == null || crs.getCoordinateSystem().getDimension() <= 2) {
            return crs;
        }
        if (FACTORIES == null) {
            FACTORIES = ReferencingFactoryContainer.instance(null);
        }
        CoordinateReferenceSystem reducedCRS = FACTORIES.separate(crs, new int[]{this.axisDimensionX, this.axisDimensionY});
        assert (reducedCRS.getCoordinateSystem().getDimension() == 2) : reducedCRS;
        return reducedCRS;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem2D() throws InvalidGridGeometryException {
        if (this.crs2D != null) {
            assert (this.isDefined(1));
            return this.crs2D;
        }
        assert (!this.isDefined(1));
        throw new InvalidGridGeometryException("Coordinate reference system is unspecified.");
    }

    public ReferencedEnvelope getEnvelope2D() throws InvalidGridGeometryException {
        if (this.envelope != null && !this.envelope.isNull()) {
            assert (this.isDefined(2));
            return ReferencedEnvelope.rect((double)this.envelope.getMinimum(this.axisDimensionX), (double)this.envelope.getMinimum(this.axisDimensionY), (double)this.envelope.getSpan(this.axisDimensionX), (double)this.envelope.getSpan(this.axisDimensionY), (CoordinateReferenceSystem)this.crs2D);
        }
        assert (!this.isDefined(2));
        throw new InvalidGridGeometryException(this.gridToCRS == null ? "Unspecified coordinates transform." : "Unspecified image's size.");
    }

    public GridEnvelope2D getGridRange2D() throws InvalidGridGeometryException {
        if (this.gridRange != null) {
            assert (this.isDefined(4));
            return new GridEnvelope2D(this.gridRange.getLow(this.gridDimensionX), this.gridRange.getLow(this.gridDimensionY), this.gridRange.getSpan(this.gridDimensionX), this.gridRange.getSpan(this.gridDimensionY));
        }
        assert (!this.isDefined(4));
        throw new InvalidGridGeometryException("Unspecified image's size.");
    }

    public MathTransform2D getGridToCRS2D() throws InvalidGridGeometryException {
        if (this.gridToCRS2D != null) {
            return this.gridToCRS2D;
        }
        throw new InvalidGridGeometryException("No two-dimensional transform available for this geometry.");
    }

    public MathTransform2D getCRSToGrid2D() throws InvalidGridGeometryException {
        if (this.gridFromCRS2D != null) {
            return this.gridFromCRS2D;
        }
        throw new InvalidGridGeometryException("Transform is not invertible.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransform2D getGridToCRS2D(PixelOrientation orientation) {
        if (this.gridToCRS2D == null) {
            throw new InvalidGridGeometryException("No two-dimensional transform available for this geometry.");
        }
        if (!PixelOrientation.UPPER_LEFT.equals((Object)orientation)) {
            return this.computeGridToCRS2D(orientation);
        }
        GridGeometry2D gridGeometry2D = this;
        synchronized (gridGeometry2D) {
            if (this.cornerToCRS2D == null) {
                this.cornerToCRS2D = this.gridToCRS.getSourceDimensions() == 2 && this.gridToCRS.getTargetDimensions() == 2 ? (MathTransform2D)super.getGridToCRS(PixelInCell.CELL_CORNER) : this.computeGridToCRS2D(orientation);
            }
        }
        return this.cornerToCRS2D;
    }

    public MathTransform2D getCRSToGrid2D(PixelOrientation orientation) {
        if (this.gridToCRS2D == null) {
            throw new InvalidGridGeometryException("No two-dimensional transform available for this geometry.");
        }
        if (!PixelOrientation.UPPER_LEFT.equals((Object)orientation)) {
            try {
                return this.computeGridToCRS2D(orientation).inverse();
            }
            catch (NoninvertibleTransformException nte) {
                throw new InvalidGridGeometryException("Transform is not invertible.");
            }
        }
        if (this.crsToCorner2D == null) {
            try {
                this.crsToCorner2D = this.getGridToCRS2D(PixelOrientation.UPPER_LEFT).inverse();
            }
            catch (NoninvertibleTransformException nte) {
                throw new InvalidGridGeometryException("Transform is not invertible.");
            }
        }
        return this.crsToCorner2D;
    }

    private MathTransform2D computeGridToCRS2D(PixelOrientation orientation) {
        int xdim = this.gridDimensionX < this.gridDimensionY ? 0 : 1;
        return (MathTransform2D)PixelTranslation.translate((MathTransform)this.gridToCRS2D, (PixelOrientation)PixelOrientation.CENTER, (PixelOrientation)orientation, (int)xdim, (int)(xdim ^ 1));
    }

    public MathTransform getGridToCRS(PixelOrientation orientation) {
        if (this.gridToCRS == null) {
            throw new InvalidGridGeometryException("Unspecified coordinates transform.");
        }
        return PixelTranslation.translate((MathTransform)this.gridToCRS, (PixelOrientation)PixelOrientation.CENTER, (PixelOrientation)orientation, (int)this.gridDimensionX, (int)this.gridDimensionY);
    }

    public final GridCoordinates2D worldToGrid(Position point) throws InvalidGridGeometryException, TransformException {
        double TOL = 1.0E-6;
        Point2D trPoint = this.toPoint2D(point);
        if (this.gridFromCRS2D != null) {
            if (Math.abs(trPoint.getX() - this.getEnvelope2D().getMaxX()) <= 1.0E-6) {
                trPoint.setLocation(trPoint.getX() - 1.0E-6, trPoint.getY());
            }
            if (Math.abs(trPoint.getY() - this.getEnvelope2D().getMinY()) <= 1.0E-6) {
                trPoint.setLocation(trPoint.getX(), trPoint.getY() + 1.0E-6);
            }
            if (Math.abs(trPoint.getX() - this.getEnvelope2D().getMinX()) <= 1.0E-6) {
                trPoint.setLocation(trPoint.getX() + 1.0E-6, trPoint.getY());
            }
            if (Math.abs(trPoint.getY() - this.getEnvelope2D().getMaxY()) <= 1.0E-6) {
                trPoint.setLocation(trPoint.getX(), trPoint.getY() - 1.0E-6);
            }
            GridCoordinates2D gc2D = new GridCoordinates2D();
            this.gridFromCRS2D.transform(trPoint, (Point2D)gc2D);
            return gc2D;
        }
        throw new InvalidGridGeometryException("Transform is not invertible.");
    }

    public final GridEnvelope2D worldToGrid(BoundingBox envelope) throws TransformException, InvalidGridGeometryException {
        CoordinateReferenceSystem targetCRS;
        MathTransform2D mt = this.getCRSToGrid2D(PixelOrientation.UPPER_LEFT);
        CoordinateReferenceSystem sourceCRS = envelope.getCoordinateReferenceSystem();
        if (sourceCRS != null && !CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)(targetCRS = this.getCoordinateReferenceSystem()))) {
            throw new IllegalArgumentException(MessageFormat.format("Coordinate system of type '{0}' are incompatible with CRS of type '{1}'.", sourceCRS, targetCRS));
        }
        Point2D lc = this.toPoint2D(envelope.getLowerCorner());
        Point lcGrid = new Point();
        mt.transform(lc, (Point2D)lcGrid);
        Point2D uc = this.toPoint2D(envelope.getUpperCorner());
        Point ucGrid = new Point();
        mt.transform(uc, (Point2D)ucGrid);
        GridEnvelope2D gridEnv = new GridEnvelope2D(Math.min(lcGrid.x, ucGrid.x), Math.min(lcGrid.y, ucGrid.y), Math.abs(lcGrid.x - ucGrid.x), Math.abs(lcGrid.y - ucGrid.y));
        return gridEnv;
    }

    public final GridEnvelope2D worldToGrid(ReferencedEnvelope envelope) throws TransformException, InvalidGridGeometryException {
        CoordinateReferenceSystem targetCRS;
        MathTransform2D mt = this.getCRSToGrid2D(PixelOrientation.UPPER_LEFT);
        CoordinateReferenceSystem sourceCRS = envelope.getCoordinateReferenceSystem();
        if (sourceCRS != null && !CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)(targetCRS = this.getCoordinateReferenceSystem()))) {
            throw new IllegalArgumentException(MessageFormat.format("Coordinate system of type '{0}' are incompatible with CRS of type '{1}'.", sourceCRS, targetCRS));
        }
        Point2D lc = this.toPoint2D(envelope.getLowerCorner());
        Point lcGrid = new Point();
        mt.transform(lc, (Point2D)lcGrid);
        Point2D uc = this.toPoint2D(envelope.getUpperCorner());
        Point ucGrid = new Point();
        mt.transform(uc, (Point2D)ucGrid);
        GridEnvelope2D gridEnv = new GridEnvelope2D(Math.min(lcGrid.x, ucGrid.x), Math.min(lcGrid.y, ucGrid.y), Math.abs(lcGrid.x - ucGrid.x), Math.abs(lcGrid.y - ucGrid.y));
        return gridEnv;
    }

    public final Position gridToWorld(GridCoordinates2D point) throws TransformException {
        if (this.getGridRange2D().contains(point)) {
            Point2D trPoint = this.getGridToCRS2D().transform((Point2D)point, null);
            return new Position2D(this.getCoordinateReferenceSystem2D(), trPoint.getX(), trPoint.getY());
        }
        throw new IllegalArgumentException(MessageFormat.format("Coordinate ({0}) is outside coverage.", point));
    }

    public final ReferencedEnvelope gridToWorld(GridEnvelope2D gridEnv) throws TransformException {
        MathTransform2D mt = this.getGridToCRS2D();
        if (this.getGridRange2D().contains(gridEnv)) {
            GridCoordinates2D low = gridEnv.getLow();
            Point2D trLow = mt.transform((Point2D)new Point2D.Double((double)low.x - 0.5, (double)low.y - 0.5), null);
            GridCoordinates2D high = gridEnv.getHigh();
            Point2D trHigh = mt.transform((Point2D)new Point2D.Double((double)high.x + 0.5, (double)high.y + 0.5), null);
            return new ReferencedEnvelope(trLow.getX(), trHigh.getX(), trLow.getY(), trHigh.getY(), this.crs2D);
        }
        throw new IllegalArgumentException(MessageFormat.format("Coordinate ({0}) is outside coverage.", gridEnv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point2D toPoint2D(Position point) throws CannotEvaluateException, MismatchedDimensionException {
        CoordinateReferenceSystem sourceCRS = point.getCoordinateReferenceSystem();
        if (sourceCRS != null) {
            GridGeometry2D gridGeometry2D = this;
            synchronized (gridGeometry2D) {
                if (this.arbitraryToInternal == null) {
                    CoordinateReferenceSystem targetCRS = this.getCoordinateReferenceSystem2D();
                    this.arbitraryToInternal = new TransformedPosition(sourceCRS, targetCRS, null);
                }
                try {
                    this.arbitraryToInternal.transform(point);
                }
                catch (TransformException exception) {
                    String arg0 = AbstractGridCoverage.toString(point, Locale.getDefault());
                    throw new CannotEvaluateException(MessageFormat.format("Can't evaluate a value for coordinate ({0}).", arg0), (Throwable)exception);
                }
                return this.arbitraryToInternal.toPoint2D();
            }
        }
        if (point.getDimension() < 2) {
            Integer arg0 = point.getDimension();
            throw new MismatchedDimensionException(MessageFormat.format("Mismatched object dimension: {0}D and {1}D.", arg0, 2));
        }
        if (point instanceof Point2D) {
            return (Point2D)point;
        }
        assert (this.axisDimensionX < this.axisDimensionY);
        return new Point2D.Double(point.getOrdinate(this.axisDimensionX), point.getOrdinate(this.axisDimensionY));
    }

    final Point2D inverseTransform(Point2D point) throws InvalidGridGeometryException {
        if (this.gridFromCRS2D != null) {
            try {
                return this.gridFromCRS2D.transform(point, null);
            }
            catch (TransformException exception) {
                String arg0 = AbstractGridCoverage.toString(point, Locale.getDefault());
                throw new CannotEvaluateException(MessageFormat.format("Can't evaluate a value for coordinate ({0}).", new Object[]{arg0, exception}));
            }
        }
        throw new InvalidGridGeometryException("No two-dimensional transform available for this geometry.");
    }

    final Rectangle inverseTransform(Rectangle2D bounds) {
        if (bounds != null && this.gridFromCRS2D != null) {
            try {
                bounds = CRS.transform((MathTransform2D)this.gridFromCRS2D, (Rectangle2D)bounds, null);
                int xmin = (int)Math.floor(bounds.getMinX() - 0.5);
                int ymin = (int)Math.floor(bounds.getMinY() - 0.5);
                int xmax = (int)Math.ceil(bounds.getMaxX() - 0.5);
                int ymax = (int)Math.ceil(bounds.getMaxY() - 0.5);
                return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            GridGeometry2D that = (GridGeometry2D)object;
            return this.gridDimensionX == that.gridDimensionX && this.gridDimensionY == that.gridDimensionY && this.axisDimensionX == that.axisDimensionX && this.axisDimensionY == that.axisDimensionY;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.crs2D, this.gridDimensionX, this.gridDimensionY, this.axisDimensionX, this.axisDimensionY, this.gridToCRS2D, this.gridFromCRS2D, this.cornerToCRS2D, this.crsToCorner2D, this.arbitraryToInternal);
    }

    static String checkConsistency(RenderedImage image, GridGeometry2D grid) {
        GridEnvelope range = grid.getGridRange();
        int dimension = range.getDimension();
        for (int i = 0; i < dimension; ++i) {
            Object label;
            int length;
            int min;
            if (i == grid.gridDimensionX) {
                min = image.getMinX();
                length = image.getWidth();
                label = "\"X\"";
            } else if (i == grid.gridDimensionY) {
                min = image.getMinY();
                length = image.getHeight();
                label = "\"Y\"";
            } else {
                min = range.getLow(i);
                length = Math.min(Math.max(range.getHigh(i) + 1, 0), 1);
                label = i;
            }
            if (range.getLow(i) == min && range.getSpan(i) == length) continue;
            return MessageFormat.format("Illegal grid range [{1} .. {2}] for dimension {0}.", label, min, min + length);
        }
        return null;
    }

    public GridGeometry2D toCanonical() {
        int lowX = this.gridRange.getLow(0);
        int lowY = this.gridRange.getLow(1);
        if (lowX == 0 && lowY == 0) {
            return this;
        }
        GridEnvelope2D canonicalRange = new GridEnvelope2D(0, 0, this.gridRange.getSpan(0), this.gridRange.getSpan(1));
        AffineTransform2D translation = new AffineTransform2D(1.0, 0.0, 0.0, 1.0, (double)lowX, (double)lowY);
        MathTransform canonicalTransform = ConcatenatedTransform.create((MathTransform)translation, (MathTransform)this.gridToCRS2D);
        return new GridGeometry2D(canonicalRange, canonicalTransform, this.getCoordinateReferenceSystem());
    }
}

