/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio;

import com.sun.media.jai.operator.ImageReadDescriptor;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public enum ReadType {
    DIRECT_READ{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RenderedImage read(ImageReadParam readParameters, int imageIndex, URL granuleUrl, Rectangle rasterDimensions, ImageReader reader, Hints hints, boolean closeElements) {
            BufferedImage bufferedImage;
            try {
                if (CoverageUtilities.checkEmptySourceRegion(readParameters, rasterDimensions)) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Provided an emptu source region to this read method ");
                    }
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                if (granuleUrl == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Provided a null URL to this read method ");
                    }
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                if (reader == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Unable to get reader for URL " + String.valueOf(granuleUrl));
                    }
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "reading file: " + String.valueOf(granuleUrl));
                }
                bufferedImage = reader.read(imageIndex, readParameters);
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to compute source area for URL " + String.valueOf(granuleUrl), e);
                }
                RenderedImage renderedImage = null;
                return renderedImage;
            }
            finally {
                try {
                    if (closeElements && reader != null) {
                        reader.dispose();
                    }
                }
                catch (Throwable throwable) {}
            }
            return bufferedImage;
        }
    }
    ,
    JAI_IMAGEREAD{

        @Override
        public RenderedImage read(ImageReadParam readParameters, int imageIndex, URL granuleUrl, Rectangle rasterDimensions, ImageReader reader, Hints hints, boolean closeElements) {
            try {
                if (CoverageUtilities.checkEmptySourceRegion(readParameters, rasterDimensions)) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Provided an emptu source region to this read method ");
                    }
                    return null;
                }
                if (granuleUrl == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Provided a null URL to this read method ");
                    }
                    return null;
                }
                if (reader == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Unable to get reader for URL " + String.valueOf(granuleUrl));
                    }
                    return null;
                }
                ImageInputStream inStream = (ImageInputStream)reader.getInput();
                inStream.seek(0L);
                RenderedOp raster = ImageReadDescriptor.create((ImageInputStream)inStream, (Integer)imageIndex, (Boolean)false, (Boolean)false, (Boolean)false, null, null, (ImageReadParam)readParameters, (ImageReader)reader, (RenderingHints)hints);
                if (raster != null) {
                    raster.getWidth();
                }
                return raster;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                }
                return null;
            }
        }
    }
    ,
    UNSPECIFIED{

        @Override
        public RenderedImage read(ImageReadParam readParameters, int imageIndex, URL granuleUrl, Rectangle rasterDimensions, ImageReader reader, Hints hints, boolean closeElements) {
            throw new UnsupportedOperationException(Errors.format((int)205, (Object)"read"));
        }
    };

    private static final Logger LOGGER;

    public static ReadType getDefault() {
        return JAI_IMAGEREAD;
    }

    public abstract RenderedImage read(ImageReadParam var1, int var2, URL var3, Rectangle var4, ImageReader var5, Hints var6, boolean var7);

    static {
        LOGGER = Logging.getLogger(ReadType.class);
    }
}

