/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio;

import it.geosolutions.imageio.core.SourceSPIProvider;
import it.geosolutions.imageio.maskband.DatasetLayout;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ROI;
import org.geotools.image.ImageWorker;
import org.geotools.image.io.ImageIOExt;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;

public class MaskOverviewProvider {
    private static final boolean DEFAULT_SKIP_EXTERNAL_FILES_LOOKUP = ImageIOUtilities.isSkipExternalFilesLookup();
    private static final Logger LOGGER = Logging.getLogger(MaskOverviewProvider.class);
    public static final String OVR_EXTENSION = ".ovr";
    private ImageReaderSpi overviewReaderSpi;
    private ImageInputStreamSpi overviewStreamSpi;
    private SourceSPIProvider sourceSpiProvider;
    private DatasetLayout layout;
    private URL fileURL;
    private URL ovrURL;
    private int numOverviews;
    private final boolean hasDatasetLayout;
    private int numInternalOverviews;
    private int numExternalOverviews;
    private int numInternalMasks;
    private int numExternalMasks;
    private int numExternalMasksOverviews;
    private boolean hasExternalMasks;
    private boolean hasExternalMasksOverviews;
    private URL maskURL;
    private ImageInputStreamSpi maskStreamSpi;
    private ImageReaderSpi maskReaderSpi;
    private URL maskOvrURL;
    private ImageInputStreamSpi maskOvrStreamSpi;
    private ImageReaderSpi maskOvrReaderSpi;
    private boolean skipExternalLookup;

    public MaskOverviewProvider(DatasetLayout layout, File inputFile) throws IOException {
        this(layout, inputFile, (ImageReaderSpi)null);
    }

    public MaskOverviewProvider(DatasetLayout layout, File inputFile, ImageReaderSpi suggestedSPI) throws IOException {
        this(layout, inputFile, new SpiHelper(URLs.fileToUrl((File)inputFile), suggestedSPI));
    }

    public MaskOverviewProvider(DatasetLayout layout, URL inputUrl) throws IOException {
        this(layout, inputUrl, (ImageReaderSpi)null);
    }

    public MaskOverviewProvider(DatasetLayout layout, URL inputUrl, ImageReaderSpi suggestedSPI) throws IOException {
        this(layout, inputUrl, new SpiHelper(inputUrl, suggestedSPI), DEFAULT_SKIP_EXTERNAL_FILES_LOOKUP);
    }

    public MaskOverviewProvider(DatasetLayout layout, File inputFile, SpiHelper spiHelper) throws IOException {
        this(layout, URLs.fileToUrl((File)inputFile), spiHelper, DEFAULT_SKIP_EXTERNAL_FILES_LOOKUP);
    }

    public MaskOverviewProvider(DatasetLayout layout, URL inputUrl, SpiHelper spiHelper) throws IOException {
        this(layout, inputUrl, spiHelper, DEFAULT_SKIP_EXTERNAL_FILES_LOOKUP);
    }

    public MaskOverviewProvider(DatasetLayout dtLayout, File inputFile, boolean skipOverviews) throws IOException {
        this(dtLayout, URLs.fileToUrl((File)inputFile), new SpiHelper(URLs.fileToUrl((File)inputFile), null), skipOverviews);
    }

    public MaskOverviewProvider(DatasetLayout layout, URL inputFile, SpiHelper spiHelper, boolean skipExternalLookup) throws IOException {
        block29: {
            this.sourceSpiProvider = spiHelper.getSourceSpiProvider();
            ImageReaderSpi readerSpi = this.sourceSpiProvider.getReaderSpi();
            ImageInputStreamSpi streamSpi = this.sourceSpiProvider.getStreamSpi();
            this.fileURL = this.sourceSpiProvider.getSourceUrl();
            this.layout = layout;
            this.skipExternalLookup = skipExternalLookup;
            this.hasDatasetLayout = layout != null;
            boolean hasExternalOverviews = false;
            SourceSPIProvider ovrProvider = null;
            if (this.hasDatasetLayout) {
                this.numInternalOverviews = layout.getNumInternalOverviews();
                this.numExternalOverviews = layout.getNumExternalOverviews() > 0 ? layout.getNumExternalOverviews() : 0;
                hasExternalOverviews = this.externalOverviewsCheck(inputFile, streamSpi, readerSpi) != null;
            } else if (!spiHelper.isMultidim()) {
                this.numInternalOverviews = this.getNumOverviews(this.sourceSpiProvider);
                if (this.numInternalOverviews == 0 && !skipExternalLookup) {
                    ovrProvider = this.externalOverviewsCheck(inputFile, streamSpi, readerSpi);
                    hasExternalOverviews = ovrProvider != null;
                }
                this.numExternalOverviews = 0;
                if (hasExternalOverviews) {
                    this.numExternalOverviews = ovrProvider != null ? this.getNumOverviews(ovrProvider) + 1 : this.getNumOverviews(this.ovrURL, this.overviewStreamSpi, this.overviewReaderSpi) + 1;
                }
            }
            int numOverviews = this.numInternalOverviews + this.numExternalOverviews;
            if (numOverviews < 0) {
                numOverviews = 0;
            }
            this.numOverviews = numOverviews;
            if (layout != null) {
                this.numInternalMasks = layout.getNumInternalMasks();
                this.numExternalMasks = layout.getNumExternalMasks() > 0 ? layout.getNumExternalMasks() : 0;
                this.numExternalMasksOverviews = layout.getNumExternalMaskOverviews() > 0 ? layout.getNumExternalMaskOverviews() : 0;
                this.hasExternalMasks = this.numExternalMasks > 0;
                boolean bl = this.hasExternalMasksOverviews = this.hasExternalMasks && this.numExternalMasksOverviews > 0;
                if (this.hasExternalMasks) {
                    this.maskURL = URLs.fileToUrl((File)layout.getExternalMasks());
                    this.maskStreamSpi = MaskOverviewProvider.getInputStreamSPIFromURL(this.maskURL);
                    try (ImageInputStream maskStream = this.maskStreamSpi.createInputStreamInstance(this.maskURL, ImageIO.getUseCache(), ImageIO.getCacheDirectory());){
                        this.maskReaderSpi = MaskOverviewProvider.getReaderSpiFromStream(readerSpi, maskStream);
                    }
                    catch (Exception e) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, "Unable to create a Reader for File: " + String.valueOf(this.maskURL), e);
                        }
                        throw new IllegalArgumentException(e);
                    }
                    if (this.hasExternalMasksOverviews) {
                        this.maskOvrURL = URLs.fileToUrl((File)layout.getExternalMaskOverviews());
                        this.maskOvrStreamSpi = MaskOverviewProvider.getInputStreamSPIFromURL(this.maskOvrURL);
                        try (ImageInputStream maskOvrStream = this.maskOvrStreamSpi.createInputStreamInstance(this.maskOvrURL, ImageIO.getUseCache(), ImageIO.getCacheDirectory());){
                            this.maskOvrReaderSpi = MaskOverviewProvider.getReaderSpiFromStream(readerSpi, maskOvrStream);
                            break block29;
                        }
                        catch (Exception e) {
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, "Unable to create a Reader for File: " + String.valueOf(this.maskOvrURL), e);
                            }
                            throw new IllegalArgumentException(e);
                        }
                    }
                    this.maskOvrStreamSpi = this.maskStreamSpi;
                    this.maskOvrReaderSpi = this.maskReaderSpi;
                } else {
                    this.maskStreamSpi = streamSpi;
                    this.maskReaderSpi = readerSpi;
                }
            }
        }
    }

    private SourceSPIProvider externalOverviewsCheck(URL inputFile, ImageInputStreamSpi streamSpi, ImageReaderSpi readerSpi) throws IOException {
        this.ovrURL = new URL(inputFile.toString() + OVR_EXTENSION);
        if (this.hasDatasetLayout && this.layout.getExternalOverviews() != null) {
            this.ovrURL = URLs.fileToUrl((File)this.layout.getExternalOverviews());
        }
        this.overviewStreamSpi = streamSpi == null ? MaskOverviewProvider.getInputStreamSPIFromURL(this.ovrURL) : streamSpi;
        SourceSPIProvider ovrProvider = this.sourceSpiProvider.getCompatibleSourceProvider(this.ovrURL);
        try (ImageInputStream ovrStream = ovrProvider.getStream();){
            if (ovrStream == null) {
                this.overviewStreamSpi = streamSpi;
                this.overviewReaderSpi = readerSpi;
                ovrProvider = null;
            } else {
                this.overviewReaderSpi = MaskOverviewProvider.getReaderSpiFromStream(null, ovrStream);
                ovrProvider.setReaderSpi(this.overviewReaderSpi);
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to create a reader for overview: " + String.valueOf(this.ovrURL), e);
            }
            return null;
        }
        return ovrProvider;
    }

    public int getNumOverviews(SourceSPIProvider sourceSpiProvider) {
        int numOverviews;
        ImageReader reader = null;
        try (ImageInputStream imageStream = sourceSpiProvider.getStream();){
            reader = sourceSpiProvider.getReader();
            reader.setInput(imageStream, false, false);
            numOverviews = reader.getNumImages(true) - 1;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to create a Reader for: " + String.valueOf(sourceSpiProvider.getSource()), e);
            }
            throw new IllegalArgumentException(e);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
        return numOverviews;
    }

    public int getNumOverviews(URL inputFile, ImageInputStreamSpi streamSpi, ImageReaderSpi readerSpi) {
        int numOverviews;
        ImageReader reader = null;
        try (ImageInputStream imageStream = streamSpi.createInputStreamInstance(inputFile, ImageIO.getUseCache(), ImageIO.getCacheDirectory());){
            reader = readerSpi.createReaderInstance();
            reader.setInput(imageStream, false, false);
            numOverviews = reader.getNumImages(true) - 1;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to create a Reader for File: " + String.valueOf(inputFile), e);
            }
            throw new IllegalArgumentException(e);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
        return numOverviews;
    }

    public int getOverviewIndex(int imageIndex) {
        if (this.numExternalOverviews > 0 && imageIndex >= this.numInternalOverviews + 1) {
            return imageIndex - this.numInternalOverviews - 1;
        }
        if (this.layout != null) {
            return this.layout.getInternalOverviewImageIndex(imageIndex);
        }
        return imageIndex;
    }

    public MaskInfo getMaskInfo(int imageIndex, Rectangle imageBounds, ImageReadParam originalParams) {
        MaskInfo info = null;
        if (this.numInternalMasks + this.numExternalMasks > 0) {
            info = new MaskInfo();
            ImageReadParam readParam = new ImageReadParam();
            readParam.setSourceSubsampling(originalParams.getSourceXSubsampling(), originalParams.getSourceYSubsampling(), originalParams.getSubsamplingXOffset(), originalParams.getSubsamplingYOffset());
            Rectangle sourceRegion = imageBounds;
            if (originalParams.getSourceRegion() != null) {
                sourceRegion = originalParams.getSourceRegion();
            }
            readParam.setSourceRegion(sourceRegion);
            info.readParameters = readParam;
            if (imageIndex > 0) {
                if (imageIndex < this.numInternalMasks) {
                    info.file = URLs.urlToFile((URL)this.fileURL);
                    info.readerSpi = this.sourceSpiProvider.getReaderSpi();
                    info.streamSpi = this.sourceSpiProvider.getStreamSpi();
                    info.index = this.layout.getInternalMaskImageIndex(imageIndex) - 1;
                } else if (this.hasExternalMasks) {
                    if (imageIndex < this.numExternalMasks) {
                        info.file = URLs.urlToFile((URL)this.maskURL);
                        info.readerSpi = this.maskReaderSpi;
                        info.streamSpi = this.maskStreamSpi;
                        info.index = imageIndex;
                    } else if (imageIndex < this.numExternalMasks + this.numExternalMasksOverviews) {
                        info.file = URLs.urlToFile((URL)this.maskOvrURL);
                        info.readerSpi = this.maskOvrReaderSpi;
                        info.streamSpi = this.maskOvrStreamSpi;
                        info.index = imageIndex - this.numExternalMasks;
                    } else if (this.numExternalMasksOverviews > 0) {
                        info.file = URLs.urlToFile((URL)this.maskOvrURL);
                        info.readerSpi = this.maskOvrReaderSpi;
                        info.streamSpi = this.maskOvrStreamSpi;
                        info.index = this.numExternalMasksOverviews - 1;
                    } else {
                        info.file = URLs.urlToFile((URL)this.maskURL);
                        info.readerSpi = this.maskReaderSpi;
                        info.streamSpi = this.maskStreamSpi;
                        info.index = this.numExternalMasks - 1;
                    }
                } else {
                    info.file = URLs.urlToFile((URL)this.fileURL);
                    info.readerSpi = this.sourceSpiProvider.getReaderSpi();
                    info.streamSpi = this.sourceSpiProvider.getStreamSpi();
                    info.index = this.numInternalMasks - 1;
                }
            } else if (imageIndex == 0) {
                if (this.numInternalMasks == 0 && this.hasExternalMasks) {
                    info.file = URLs.urlToFile((URL)this.maskURL);
                    info.readerSpi = this.maskReaderSpi;
                    info.streamSpi = this.maskStreamSpi;
                    info.index = 0;
                } else if (this.numInternalMasks > 0) {
                    info.file = URLs.urlToFile((URL)this.fileURL);
                    info.readerSpi = this.sourceSpiProvider.getReaderSpi();
                    info.streamSpi = this.sourceSpiProvider.getStreamSpi();
                    info.index = this.layout.getInternalMaskImageIndex(0);
                }
            }
        }
        return info;
    }

    public boolean hasMaskIndexForOverview(int imageIndex) {
        if (imageIndex > 0) {
            if (imageIndex < this.numInternalMasks) {
                return true;
            }
            if (this.hasExternalMasks && imageIndex <= this.numExternalMasks + this.numExternalMasksOverviews - 1) {
                return true;
            }
        } else if (imageIndex == 0 && this.numInternalMasks > 0 || this.hasExternalMasks) {
            return true;
        }
        return false;
    }

    public boolean isExternalOverview(int imageIndex) {
        if (this.numExternalOverviews <= 0) {
            return false;
        }
        return imageIndex > this.numInternalOverviews;
    }

    public boolean isExternalMask(int imageIndex) {
        if (this.numExternalMasks <= 0) {
            return false;
        }
        return this.hasExternalMasks && imageIndex > (this.numInternalMasks > 0 ? this.numInternalMasks + 1 : 0);
    }

    public boolean isExternalMaskOverviews(int imageIndex) {
        if (this.numExternalMasksOverviews <= 0) {
            return false;
        }
        return this.isExternalMask(imageIndex) && this.hasExternalMasksOverviews && imageIndex > (this.numInternalMasks > 0 ? this.numInternalMasks + this.numExternalMasks + 2 : this.numExternalMasks + 1);
    }

    public boolean hasExternalMasks() {
        return this.hasExternalMasks;
    }

    public boolean hasExternalMasksOverviews() {
        return this.hasExternalMasksOverviews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double[][] getOverviewResolutions(double span0, double span1) {
        double[][] overviewsResolution = null;
        if (this.numOverviews <= 0) return overviewsResolution;
        ImageInputStream stream = null;
        ImageInputStream streamOvr = null;
        ImageReader reader = null;
        ImageReader readerOvr = null;
        try {
            stream = this.sourceSpiProvider.getStream();
            reader = this.sourceSpiProvider.getReader();
            reader.setInput(stream, false, false);
            if (this.ovrURL != null) {
                SourceSPIProvider ovrProvider = this.sourceSpiProvider.getCompatibleSourceProvider(this.ovrURL);
                streamOvr = ovrProvider.getStream();
                readerOvr = this.overviewReaderSpi.createReaderInstance();
                readerOvr.setInput(streamOvr, false, false);
            }
            overviewsResolution = new double[this.numOverviews][2];
            for (int i = 0; i < this.numOverviews; ++i) {
                int index;
                if (this.numExternalOverviews > 0 && i >= this.numInternalOverviews) {
                    index = i - this.numInternalOverviews;
                    overviewsResolution[i][0] = span0 / (double)readerOvr.getWidth(index);
                    overviewsResolution[i][1] = span1 / (double)readerOvr.getHeight(index);
                    continue;
                }
                index = this.hasDatasetLayout ? this.layout.getInternalOverviewImageIndex(i + 1) : i + 1;
                overviewsResolution[i][0] = span0 / (double)reader.getWidth(index);
                overviewsResolution[i][1] = span1 / (double)reader.getHeight(index);
            }
            return overviewsResolution;
        }
        catch (Exception e) {
            if (!LOGGER.isLoggable(Level.WARNING)) throw new IllegalArgumentException(e);
            LOGGER.log(Level.WARNING, "Unable to create a Reader for File: " + String.valueOf(this.fileURL), e);
            throw new IllegalArgumentException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.dispose();
                    }
                }
            }
            if (streamOvr != null) {
                try {
                    streamOvr.close();
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                finally {
                    if (readerOvr != null) {
                        readerOvr.dispose();
                    }
                }
            }
        }
    }

    public ImageReaderSpi getExternalOverviewReaderSpi() {
        return this.overviewReaderSpi;
    }

    public ImageReaderSpi getImageReaderSpi() {
        return this.sourceSpiProvider.getReaderSpi();
    }

    public ImageInputStreamSpi getExternalOverviewInputStreamSpi() {
        return this.overviewStreamSpi;
    }

    public ImageInputStreamSpi getInputStreamSpi() {
        return this.sourceSpiProvider.getStreamSpi();
    }

    public SourceSPIProvider getSourceSpiProvider() {
        return this.sourceSpiProvider;
    }

    public ImageInputStreamSpi getMaskStreamSpi() {
        return this.maskStreamSpi;
    }

    public ImageReaderSpi getMaskReaderSpi() {
        return this.maskReaderSpi;
    }

    public ImageInputStreamSpi getMaskOvrStreamSpi() {
        return this.maskOvrStreamSpi;
    }

    public ImageReaderSpi getMaskOvrReaderSpi() {
        return this.maskOvrReaderSpi;
    }

    public DatasetLayout getLayout() {
        return this.layout;
    }

    public int getNumOverviews() {
        return this.numOverviews;
    }

    public int getNumInternalOverviews() {
        return this.numInternalOverviews;
    }

    public int getNumExternalOverviews() {
        return this.numExternalOverviews;
    }

    public int getNumInternalMasks() {
        return this.numInternalMasks;
    }

    public int getNumExternalMasks() {
        return this.numExternalMasks;
    }

    public int getNumExternalMasksOverviews() {
        return this.numExternalMasksOverviews;
    }

    public URL getFileURL() {
        return this.fileURL;
    }

    public URL getOvrURL() {
        return this.ovrURL;
    }

    public URL getMaskURL() {
        return this.maskURL;
    }

    public URL getMaskOvrURL() {
        return this.maskOvrURL;
    }

    public boolean isSkipExternalLookup() {
        return this.skipExternalLookup;
    }

    public static ImageInputStreamSpi getInputStreamSPIFromURL(URL fileURL) throws IOException {
        ImageInputStreamSpi streamSPI = ImageIOExt.getImageInputStreamSPI(fileURL, true);
        if (streamSPI == null) {
            File file = URLs.urlToFile((URL)fileURL);
            if (file != null && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, file.getCanonicalPath());
            }
            throw new IllegalArgumentException("Unable to get an input stream for the provided source " + fileURL.toString());
        }
        return streamSPI;
    }

    public static ImageReaderSpi getReaderSpiFromStream(ImageReaderSpi suggestedSPI, ImageInputStream inStream) throws IOException {
        ImageReaderSpi readerSPI = null;
        inStream.mark();
        if (suggestedSPI != null && suggestedSPI.canDecodeInput(inStream)) {
            readerSPI = suggestedSPI;
            inStream.reset();
        } else {
            inStream.mark();
            ImageReader reader = ImageIOExt.getImageioReader(inStream);
            if (reader != null) {
                readerSPI = reader.getOriginatingProvider();
            }
            inStream.reset();
        }
        return readerSPI;
    }

    public static ROI scaleROI(RenderedImage roiRaster, Rectangle bounds) {
        if (roiRaster == null) {
            return null;
        }
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        double scaleX = (double)w / (1.0 * (double)roiRaster.getWidth());
        double scaleY = (double)h / (1.0 * (double)roiRaster.getHeight());
        AffineTransform tr = AffineTransform.getScaleInstance(scaleX, scaleY);
        int transX = x;
        int transY = y;
        tr.concatenate(AffineTransform.getTranslateInstance(transX, transY));
        if (!tr.isIdentity()) {
            LOGGER.fine("Scaling ROI");
        }
        return new ImageWorker(roiRaster).affine(tr, null, null).binarize(1.0).getImageAsROI();
    }

    public static class SpiHelper {
        private static final Set<String> MULTIDIM_SERVICE_PROVIDERS = new HashSet<String>();
        private URL fileURL;
        private SourceSPIProvider sourceSpiProvider;
        private boolean isMultidim;

        public SpiHelper(URL input, ImageReaderSpi suggestedSPI) throws IOException {
            this(input, suggestedSPI, null);
        }

        public SpiHelper(URL input, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedStreamSpi) throws IOException {
            this.fileURL = input;
            ImageInputStreamSpi streamSpi = null;
            ImageReaderSpi readerSpi = null;
            streamSpi = suggestedStreamSpi == null ? MaskOverviewProvider.getInputStreamSPIFromURL(this.fileURL) : suggestedStreamSpi;
            try (ImageInputStream stream = streamSpi.createInputStreamInstance(this.fileURL, ImageIO.getUseCache(), ImageIO.getCacheDirectory());){
                readerSpi = MaskOverviewProvider.getReaderSpiFromStream(suggestedSPI, stream);
                this.isMultidim = readerSpi != null && MULTIDIM_SERVICE_PROVIDERS.contains(readerSpi.getClass().getName());
                this.sourceSpiProvider = new SourceSPIProvider((Object)this.fileURL, readerSpi, streamSpi);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to create a Reader for File: " + String.valueOf(input), e);
                }
                throw new IllegalArgumentException(e);
            }
        }

        public SpiHelper(SourceSPIProvider provider) throws IOException {
            this.sourceSpiProvider = provider;
        }

        public boolean isMultidim() {
            return this.isMultidim;
        }

        public SourceSPIProvider getSourceSpiProvider() {
            return this.sourceSpiProvider;
        }

        static {
            MULTIDIM_SERVICE_PROVIDERS.add("org.geotools.imageio.netcdf.NetCDFImageReaderSpi");
        }
    }

    public static class MaskInfo {
        public File file;
        public int index;
        public ImageReadParam readParameters;
        public ImageReaderSpi readerSpi;
        public ImageInputStreamSpi streamSpi;
    }
}

