/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.impl;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.geotools.api.coverage.CannotEvaluateException;
import org.geotools.api.coverage.PointOutsideCoverageException;
import org.geotools.api.coverage.SampleDimension;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.Record;
import org.geotools.api.util.RecordType;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.io.GridCoverageResponse;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;

public class DefaultGridCoverageResponse
implements GridCoverageResponse {
    private GridCoverage gridCoverage;
    private DateRange temporalExtent;
    private NumberRange<Double> verticalExtent;

    public DefaultGridCoverageResponse(GridCoverage gridCoverage, DateRange temporalExtent, NumberRange<Double> verticalExtent) {
        this.temporalExtent = temporalExtent;
        this.verticalExtent = verticalExtent;
        this.gridCoverage = gridCoverage;
    }

    @Override
    public DateRange getTemporalExtent() {
        return this.temporalExtent;
    }

    @Override
    public NumberRange<Double> getVerticalExtent() {
        return this.verticalExtent;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.gridCoverage.getCoordinateReferenceSystem();
    }

    public Bounds getEnvelope() {
        return this.gridCoverage.getEnvelope();
    }

    public RecordType getRangeType() {
        return this.gridCoverage.getRangeType();
    }

    public Set<Record> evaluate(Position p, Collection<String> list) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.gridCoverage.evaluate(p, list);
    }

    public Object evaluate(Position point) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.gridCoverage.evaluate(point);
    }

    public boolean[] evaluate(Position point, boolean[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    public byte[] evaluate(Position point, byte[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    public int[] evaluate(Position point, int[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    public float[] evaluate(Position point, float[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    public double[] evaluate(Position point, double[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    public int getNumSampleDimensions() {
        return this.gridCoverage.getNumSampleDimensions();
    }

    public SampleDimension getSampleDimension(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getSampleDimension(index);
    }

    public RenderableImage getRenderableImage(int xAxis, int yAxis) throws UnsupportedOperationException, IndexOutOfBoundsException {
        return this.gridCoverage.getRenderableImage(xAxis, yAxis);
    }

    public boolean isDataEditable() {
        return this.gridCoverage.isDataEditable();
    }

    public GridGeometry getGridGeometry() {
        return this.gridCoverage.getGridGeometry();
    }

    public int[] getOptimalDataBlockSizes() {
        return this.gridCoverage.getOptimalDataBlockSizes();
    }

    public int getNumOverviews() {
        return this.gridCoverage.getNumOverviews();
    }

    public GridGeometry getOverviewGridGeometry(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getOverviewGridGeometry(index);
    }

    public GridCoverage getOverview(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getOverview(index);
    }

    public List<GridCoverage> getSources() {
        return this.gridCoverage.getSources();
    }

    public RenderedImage getRenderedImage() {
        return this.gridCoverage.getRenderedImage();
    }

    @Override
    public GridCoverage2D getGridCoverage2D() {
        return (GridCoverage2D)this.gridCoverage;
    }
}

