/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.impl;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.io.GridCoverageResponse;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

public class DefaultGridCoverageResponse
implements GridCoverageResponse {
    private GridCoverage gridCoverage;
    private DateRange temporalExtent;
    private NumberRange<Double> verticalExtent;

    public DefaultGridCoverageResponse(GridCoverage gridCoverage, DateRange temporalExtent, NumberRange<Double> verticalExtent) {
        this.temporalExtent = temporalExtent;
        this.verticalExtent = verticalExtent;
        this.gridCoverage = gridCoverage;
    }

    @Override
    public DateRange getTemporalExtent() {
        return this.temporalExtent;
    }

    @Override
    public NumberRange<Double> getVerticalExtent() {
        return this.verticalExtent;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.gridCoverage.getCoordinateReferenceSystem();
    }

    public Envelope getEnvelope() {
        return this.gridCoverage.getEnvelope();
    }

    public RecordType getRangeType() {
        return this.gridCoverage.getRangeType();
    }

    public Set<Record> evaluate(DirectPosition p, Collection<String> list) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.gridCoverage.evaluate(p, list);
    }

    public Object evaluate(DirectPosition point) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.gridCoverage.evaluate(point);
    }

    public boolean[] evaluate(DirectPosition point, boolean[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    public byte[] evaluate(DirectPosition point, byte[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    public int[] evaluate(DirectPosition point, int[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    public float[] evaluate(DirectPosition point, float[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    public double[] evaluate(DirectPosition point, double[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    public int getNumSampleDimensions() {
        return this.gridCoverage.getNumSampleDimensions();
    }

    public SampleDimension getSampleDimension(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getSampleDimension(index);
    }

    public RenderableImage getRenderableImage(int xAxis, int yAxis) throws UnsupportedOperationException, IndexOutOfBoundsException {
        return this.gridCoverage.getRenderableImage(xAxis, yAxis);
    }

    public boolean isDataEditable() {
        return this.gridCoverage.isDataEditable();
    }

    public GridGeometry getGridGeometry() {
        return this.gridCoverage.getGridGeometry();
    }

    public int[] getOptimalDataBlockSizes() {
        return this.gridCoverage.getOptimalDataBlockSizes();
    }

    public int getNumOverviews() {
        return this.gridCoverage.getNumOverviews();
    }

    public GridGeometry getOverviewGridGeometry(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getOverviewGridGeometry(index);
    }

    public GridCoverage getOverview(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getOverview(index);
    }

    public List<GridCoverage> getSources() {
        return this.gridCoverage.getSources();
    }

    public RenderedImage getRenderedImage() {
        return this.gridCoverage.getRenderedImage();
    }

    @Override
    public GridCoverage2D getGridCoverage2D() {
        return (GridCoverage2D)this.gridCoverage;
    }
}

