/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.range;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;

public abstract class Measure<V extends Number, Q extends Quantity<Q>>
implements Comparable<Measure<V, Q>> {
    abstract V getValue();

    abstract Unit<Q> getUnit();

    abstract Measure<V, Q> to(Unit<Q> var1);

    public Number numericValue(Unit<Q> unit) {
        if (this.getUnit() == unit || this.getUnit().equals(unit)) {
            return this.getValue();
        }
        UnitConverter converter = this.getUnit().getConverterTo(unit);
        return converter.convert(this.getValue());
    }

    public double doubleValue(Unit<Q> unit) {
        Number number = this.numericValue(unit);
        return number.doubleValue();
    }

    public long longValue(Unit<Q> unit) {
        Number number = this.numericValue(unit);
        return number.longValue();
    }

    @Override
    public int compareTo(Measure<V, Q> obj) {
        return Double.compare(this.doubleValue(this.getUnit()), obj.doubleValue(this.getUnit()));
    }
}

