/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.Objects;
import org.geotools.metadata.i18n.Errors;

public class RasterLayout
implements Cloneable {
    int minX = 0;
    int minY = 0;
    int width = 0;
    int height = 0;
    int tileGridXOffset = 0;
    int tileGridYOffset = 0;
    int tileWidth = 0;
    int tileHeight = 0;

    public RasterLayout() {
    }

    public RasterLayout(int minX, int minY, int width, int height, int tileGridXOffset, int tileGridYOffset, int tileWidth, int tileHeight) {
        this.setMinX(minX);
        this.setMinY(minY);
        this.setWidth(width);
        this.setHeight(height);
        this.setTileGridXOffset(tileGridXOffset);
        this.setTileGridYOffset(tileGridYOffset);
        this.setTileWidth(tileWidth);
        this.setTileHeight(tileHeight);
    }

    public RasterLayout(int minX, int minY, int width, int height) {
        this.setMinX(minX);
        this.setMinY(minY);
        this.setWidth(width);
        this.setHeight(height);
    }

    public RasterLayout(RenderedImage im) {
        this(im.getMinX(), im.getMinY(), im.getWidth(), im.getHeight(), im.getTileGridXOffset(), im.getTileGridYOffset(), im.getTileWidth(), im.getTileHeight());
    }

    public RasterLayout(Rectangle bounds) {
        if (bounds == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"bounds"));
        }
        this.height = bounds.height;
        this.width = bounds.width;
        this.minX = bounds.x;
        this.minY = bounds.y;
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.minX, this.minY, this.width, this.height);
    }

    public int getMinX() {
        return this.minX;
    }

    public RasterLayout setMinX(int minX) {
        this.minX = minX;
        return this;
    }

    public int getMinY() {
        return this.minY;
    }

    public RasterLayout setMinY(int minY) {
        this.minY = minY;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public RasterLayout setWidth(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("ImageLayout0");
        }
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public RasterLayout setHeight(int height) {
        if (height <= 0) {
            throw new IllegalArgumentException("ImageLayout0");
        }
        this.height = height;
        return this;
    }

    public int getTileGridXOffset() {
        return this.tileGridXOffset;
    }

    public RasterLayout setTileGridXOffset(int tileGridXOffset) {
        this.tileGridXOffset = tileGridXOffset;
        return this;
    }

    public int getTileGridYOffset() {
        return this.tileGridYOffset;
    }

    public RasterLayout setTileGridYOffset(int tileGridYOffset) {
        this.tileGridYOffset = tileGridYOffset;
        return this;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public RasterLayout setTileWidth(int tileWidth) {
        if (tileWidth <= 0) {
            throw new IllegalArgumentException("ImageLayout0");
        }
        this.tileWidth = tileWidth;
        return this;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public RasterLayout setTileHeight(int tileHeight) {
        if (tileHeight <= 0) {
            throw new IllegalArgumentException("ImageLayout0");
        }
        this.tileHeight = tileHeight;
        return this;
    }

    public String toString() {
        Object s = "RasterLayout[";
        s = (String)s + "MIN_X=" + this.minX;
        s = (String)s + ", ";
        s = (String)s + "MIN_Y=" + this.minY;
        s = (String)s + ", ";
        s = (String)s + "WIDTH=" + this.width;
        s = (String)s + ", ";
        s = (String)s + "HEIGHT=" + this.height;
        s = (String)s + ", ";
        s = (String)s + "TILE_GRID_X_OFFSET=" + this.tileGridXOffset;
        s = (String)s + ", ";
        s = (String)s + "TILE_GRID_Y_OFFSET=" + this.tileGridYOffset;
        s = (String)s + ", ";
        s = (String)s + "TILE_WIDTH=" + this.tileWidth;
        s = (String)s + ", ";
        s = (String)s + "TILE_HEIGHT=" + this.tileHeight;
        s = (String)s + "]";
        return s;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RasterLayout)) {
            return false;
        }
        RasterLayout il = (RasterLayout)obj;
        return this.width == il.width && this.height == il.height && this.minX == il.minX && this.minY == il.minY && this.tileHeight == il.tileHeight && this.tileWidth == il.tileWidth && this.tileGridXOffset == il.tileGridXOffset && this.tileGridYOffset == il.tileGridYOffset;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.width, this.height, this.tileGridXOffset, this.tileGridYOffset, this.tileWidth, this.tileHeight);
    }
}

