/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.util;

import it.geosolutions.imageio.stream.AccessibleStream;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import it.geosolutions.imageio.stream.input.URIImageInputStream;
import it.geosolutions.imageio.stream.input.URIImageInputStreamImpl;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.DataSourceException;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.measure.UnitFormat;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.factory.ReferencingObjectFactory;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import si.uom.SI;
import tech.units.indriya.AbstractUnit;

public class Utilities {
    private static final Logger LOGGER = Logging.getLogger(Utilities.class);
    private static final MathTransformFactory mtFactory = new DefaultMathTransformFactory();

    public static ReferenceIdentifier[] getIdentifiers(String nameIdentifier) {
        if (nameIdentifier.equalsIgnoreCase("WGS84")) {
            ReferenceIdentifier[] identifiers = new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "WGS84"), new NamedIdentifier(Citations.ORACLE, "WGS 84"), new NamedIdentifier(null, "WGS_84"), new NamedIdentifier(null, "WGS 1984"), new NamedIdentifier(Citations.EPSG, "WGS_1984"), new NamedIdentifier(Citations.ESRI, "D_WGS_1984"), new NamedIdentifier(Citations.EPSG, "World Geodetic System 1984")};
            return identifiers;
        }
        return null;
    }

    private Utilities() {
    }

    public static DefaultGeodeticDatum getDefaultGeodeticDatum(String name, double equatorialRadius, double inverseFlattening, Unit<Length> unit) {
        DefaultEllipsoid ellipsoid = DefaultEllipsoid.createFlattenedSphere((String)name, (double)equatorialRadius, (double)inverseFlattening, unit);
        ReferenceIdentifier[] identifiers = Utilities.getIdentifiers(name);
        if (identifiers == null) {
            throw new IllegalArgumentException("Reference Identifier not available");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", identifiers[0]);
        properties.put("alias", identifiers);
        DefaultGeodeticDatum datum = new DefaultGeodeticDatum(properties, (Ellipsoid)ellipsoid, (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
        return datum;
    }

    public static File getFileFromCustomInput(Object input) {
        File fileCheck = (File)input;
        String path = fileCheck.getAbsolutePath();
        int imageSpecifierIndex = path.lastIndexOf(":");
        File file = SystemUtils.IS_OS_WINDOWS ? (imageSpecifierIndex > 1 && imageSpecifierIndex > path.indexOf(":") ? new File(path.substring(0, imageSpecifierIndex)) : fileCheck) : (imageSpecifierIndex > 0 ? new File(path.substring(0, imageSpecifierIndex)) : fileCheck);
        return file;
    }

    public static CoordinateReferenceSystem getMercator2SPProjectedCRS(double standardParallel, double centralMeridian, double natOriginLat, GeographicCRS sourceCRS, Hints hints) throws DataSourceException {
        ProjectedCRS projectedCRS = null;
        ReferencingFactoryContainer fg = ReferencingFactoryContainer.instance((Hints)hints);
        try {
            ParameterValueGroup params = mtFactory.getDefaultParameters("Mercator_2SP");
            params.parameter("standard_parallel_1").setValue(standardParallel);
            params.parameter("central_meridian").setValue(centralMeridian);
            params.parameter("false_northing").setValue(0);
            params.parameter("false_easting").setValue(0);
            params.parameter("latitude_of_origin").setValue(natOriginLat);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("name", "Mercator CRS");
            OperationMethod method = null;
            MathTransform mt = fg.getMathTransformFactory().createBaseToDerived((CoordinateReferenceSystem)sourceCRS, params, (CoordinateSystem)DefaultCartesianCS.PROJECTED);
            if (method == null) {
                method = fg.getMathTransformFactory().getLastMethodUsed();
            }
            projectedCRS = ((ReferencingObjectFactory)fg.getCRSFactory()).createProjectedCRS(props, method, sourceCRS, mt, (CartesianCS)DefaultCartesianCS.PROJECTED);
        }
        catch (FactoryException e) {
            throw new DataSourceException((Throwable)e);
        }
        return projectedCRS;
    }

    public static GeographicCRS getBaseCRS(double equatorialRadius, double inverseFlattening) {
        DefaultGeodeticDatum datum = Utilities.getDefaultGeodeticDatum("WGS84", equatorialRadius, inverseFlattening, (Unit<Length>)SI.METRE);
        DefaultGeographicCRS sourceCRS = new DefaultGeographicCRS("WGS-84", (GeodeticDatum)datum, DefaultGeographicCRS.WGS84.getCoordinateSystem());
        return sourceCRS;
    }

    public static String getAttributeValue(NamedNodeMap attributes, String attributeName) {
        String attributeValue = null;
        Node attribute = attributes.getNamedItem(attributeName);
        if (attribute != null) {
            attributeValue = attribute.getNodeValue();
        }
        return attributeValue;
    }

    public static Unit<? extends Quantity<?>> parseUnit(String uom) {
        Unit unit;
        block5: {
            unit = AbstractUnit.ONE;
            if (uom != null && uom.trim().length() > 0) {
                if (uom.equalsIgnoreCase("temp_deg_c") || uom.equalsIgnoreCase("Celsius")) {
                    unit = SI.CELSIUS;
                } else {
                    try {
                        unit = UnitFormat.getInstance().parse((CharSequence)uom);
                    }
                    catch (IllegalArgumentException iae) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block5;
                        LOGGER.log(Level.FINE, "Unable to parse the provided unit " + uom);
                    }
                }
            }
        }
        return unit;
    }

    public static Envelope getEnvelopeAsWGS84(Envelope envelope, boolean get2D) throws FactoryException, TransformException {
        if (envelope == null) {
            throw new IllegalArgumentException("Specified envelope is null");
        }
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)DefaultGeographicCRS.WGS84)) {
            GeneralEnvelope requestedWGS84;
            GeneralEnvelope env = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            if (get2D) {
                requestedWGS84 = new Envelope2D((Envelope)env);
                ((Envelope2D)requestedWGS84).setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            } else {
                requestedWGS84 = env;
                requestedWGS84.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            }
            return requestedWGS84;
        }
        if (get2D) {
            return new Envelope2D(envelope);
        }
        return new GeneralEnvelope(envelope);
    }

    public static GeneralEnvelope getRequestedEnvelope2D(GeneralEnvelope requestedEnvelope) throws FactoryException, TransformException {
        LinearTransform transformTo2D;
        if (requestedEnvelope == null) {
            throw new IllegalArgumentException("requested envelope is null");
        }
        GeneralEnvelope requestedEnvelope2D = null;
        CoordinateReferenceSystem requestedEnvelopeCRS2D = requestedEnvelope.getCoordinateReferenceSystem();
        if (requestedEnvelopeCRS2D.getCoordinateSystem().getDimension() != 2) {
            transformTo2D = CRS.findMathTransform((CoordinateReferenceSystem)requestedEnvelopeCRS2D, (CoordinateReferenceSystem)CRS.getHorizontalCRS((CoordinateReferenceSystem)requestedEnvelopeCRS2D));
            requestedEnvelopeCRS2D = CRS.getHorizontalCRS((CoordinateReferenceSystem)requestedEnvelopeCRS2D);
        } else {
            transformTo2D = IdentityTransform.create((int)2);
        }
        if (!transformTo2D.isIdentity()) {
            requestedEnvelope2D = CRS.transform((MathTransform)transformTo2D, (Envelope)requestedEnvelope);
            requestedEnvelope2D.setCoordinateReferenceSystem(requestedEnvelopeCRS2D);
        } else {
            requestedEnvelope2D = new GeneralEnvelope((Envelope)requestedEnvelope);
        }
        assert (requestedEnvelopeCRS2D.getCoordinateSystem().getDimension() == 2);
        return requestedEnvelope2D;
    }

    public static Rectangle getCropRegion(GeneralEnvelope envelope, MathTransform gridToWorldTransform) throws TransformException {
        if (envelope == null || gridToWorldTransform == null) {
            boolean isEnvelope = envelope == null;
            boolean isG2W = gridToWorldTransform == null;
            boolean twoErrors = isEnvelope && isG2W;
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Specified ").append(isEnvelope ? "envelope" : "").append(twoErrors ? ", " : "").append(isG2W ? "grid to world transformation " : "").append("is null");
            throw new IllegalArgumentException(errorMessage.toString());
        }
        MathTransform worldToGridTransform = gridToWorldTransform.inverse();
        GeneralEnvelope rasterArea = CRS.transform((MathTransform)worldToGridTransform, (Envelope)envelope);
        Rectangle2D ordinates = rasterArea.toRectangle2D();
        return ordinates.getBounds();
    }

    public static GeneralEnvelope getIntersection(Envelope2D baseEnvelope2D, CoordinateReferenceSystem spatialReferenceSystem2D, GeneralEnvelope requestedEnvelope2D, Rectangle requestedDim, MathTransform2D readGridToWorld, Envelope2D wgs84BaseEnvelope2D) throws TransformException, FactoryException {
        if (baseEnvelope2D == null || spatialReferenceSystem2D == null || requestedEnvelope2D == null || requestedDim == null || readGridToWorld == null) {
            StringBuilder sb = new StringBuilder("Some of the specified parameters are null:").append(baseEnvelope2D == null ? "base envelope \n" : "").append(spatialReferenceSystem2D == null ? "native spatial reference system\n" : "").append(requestedEnvelope2D == null ? "requested envelope \n" : "").append(requestedDim == null ? "requested dim\n" : "").append(readGridToWorld == null ? "requested grid to world transformation \n" : "");
            throw new IllegalArgumentException(sb.toString());
        }
        GeneralEnvelope adjustedRequestedEnvelope = new GeneralEnvelope(2);
        CoordinateReferenceSystem requestedEnvelopeCRS2D = requestedEnvelope2D.getCoordinateReferenceSystem();
        boolean tryWithWGS84 = false;
        try {
            if (!CRS.equalsIgnoreMetadata((Object)requestedEnvelopeCRS2D, (Object)spatialReferenceSystem2D)) {
                adjustedRequestedEnvelope = CRS.transform((Envelope)requestedEnvelope2D, (CoordinateReferenceSystem)spatialReferenceSystem2D);
            } else {
                adjustedRequestedEnvelope.setEnvelope(requestedEnvelope2D);
            }
            if (!adjustedRequestedEnvelope.intersects((Envelope)baseEnvelope2D, true)) {
                return null;
            }
            adjustedRequestedEnvelope.intersect((Envelope)baseEnvelope2D);
            adjustedRequestedEnvelope.setCoordinateReferenceSystem(spatialReferenceSystem2D);
            GeneralEnvelope requestedEnvelopeCropped = CRS.transform((Envelope)adjustedRequestedEnvelope, (CoordinateReferenceSystem)requestedEnvelopeCRS2D);
            Rectangle2D ordinates = CRS.transform((MathTransform)readGridToWorld.inverse(), (Envelope)requestedEnvelopeCropped).toRectangle2D();
            GeneralGridEnvelope finalRange = new GeneralGridEnvelope(ordinates.getBounds());
            Rectangle tempRect = finalRange.toRectangle();
            XRectangle2D.intersect((Rectangle2D)tempRect, (Rectangle2D)requestedDim, (Rectangle2D)tempRect);
            requestedDim.setRect(tempRect);
        }
        catch (TransformException te) {
            tryWithWGS84 = true;
        }
        if (tryWithWGS84) {
            GeneralEnvelope requestedEnvelopeWGS84 = (GeneralEnvelope)Utilities.getEnvelopeAsWGS84((Envelope)requestedEnvelope2D, false);
            if (!requestedEnvelopeWGS84.intersects((Envelope)wgs84BaseEnvelope2D, true)) {
                return null;
            }
            adjustedRequestedEnvelope = new GeneralEnvelope((Envelope)requestedEnvelopeWGS84);
            adjustedRequestedEnvelope.intersect((Envelope)wgs84BaseEnvelope2D);
            adjustedRequestedEnvelope = CRS.transform((Envelope)adjustedRequestedEnvelope, (CoordinateReferenceSystem)spatialReferenceSystem2D);
            adjustedRequestedEnvelope.setCoordinateReferenceSystem(spatialReferenceSystem2D);
        }
        return adjustedRequestedEnvelope;
    }

    public static MathTransform getOriginalGridToWorld(MathTransform raster2Model, PixelInCell pixInCell) {
        if (pixInCell == PixelInCell.CELL_CENTER) {
            return raster2Model;
        }
        if (raster2Model instanceof AffineTransform) {
            AffineTransform tr = new AffineTransform((AffineTransform)raster2Model);
            tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
            return ProjectiveTransform.create((AffineTransform)tr);
        }
        if (raster2Model instanceof IdentityTransform) {
            AffineTransform tr = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
            return ProjectiveTransform.create((AffineTransform)tr);
        }
        throw new IllegalStateException("This grid to world transform is invalud!");
    }

    public static GeneralEnvelope evaluateRequestedParams(GridEnvelope originalGridRange, Envelope2D baseEnvelope2D, CoordinateReferenceSystem spatialReferenceSystem2D, MathTransform originalGridToWorld, GeneralEnvelope requestedEnvelope, Rectangle sourceRegion, Rectangle requestedDim, MathTransform2D readGridToWorld, Envelope2D wgs84BaseEnvelope2D) throws DataSourceException {
        GeneralEnvelope adjustedRequestedEnvelope = new GeneralEnvelope(2);
        GeneralGridEnvelope baseGridRange = (GeneralGridEnvelope)originalGridRange;
        try {
            if (requestedEnvelope != null) {
                GeneralEnvelope requestedEnvelope2D = Utilities.getRequestedEnvelope2D(requestedEnvelope);
                adjustedRequestedEnvelope = Utilities.getIntersection(baseEnvelope2D, spatialReferenceSystem2D, requestedEnvelope2D, requestedDim, readGridToWorld, wgs84BaseEnvelope2D);
                if (adjustedRequestedEnvelope == null) {
                    return null;
                }
                sourceRegion.setRect(Utilities.getCropRegion(adjustedRequestedEnvelope, Utilities.getOriginalGridToWorld(originalGridToWorld, PixelInCell.CELL_CORNER)));
                if (sourceRegion.isEmpty()) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "Too small envelope resulting in empty cropped raster region");
                    }
                    return null;
                }
                if (!sourceRegion.intersects(baseGridRange.toRectangle()) || sourceRegion.isEmpty()) {
                    throw new DataSourceException("The crop region is invalid.");
                }
                sourceRegion.setRect(sourceRegion.intersection(baseGridRange.toRectangle()));
                if (LOGGER.isLoggable(Level.FINE)) {
                    StringBuilder sb = new StringBuilder("Adjusted Requested Envelope = ").append(adjustedRequestedEnvelope.toString()).append("\n").append("Requested raster dimension = ").append(requestedDim.toString()).append("\n").append("Corresponding raster source region = ").append(sourceRegion.toString());
                    LOGGER.log(Level.FINE, sb.toString());
                }
            } else {
                sourceRegion.setBounds(new Rectangle(0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE));
            }
        }
        catch (FactoryException | TransformException e) {
            throw new DataSourceException("Unable to create a coverage for this source", e);
        }
        return adjustedRequestedEnvelope;
    }

    public static GridCoverage createCoverageFromImage(GridCoverageFactory coverageFactory, String coverageName, int imageIndex, PlanarImage image, MathTransform raster2Model, CoordinateReferenceSystem spatialReferenceSystem2D, GeneralEnvelope coverageEnvelope2D, GridSampleDimension[] sampleDimensions) throws IOException {
        GridSampleDimension[] bands = sampleDimensions;
        GridCoverage2D gridCoverage = raster2Model != null ? coverageFactory.create((CharSequence)coverageName, (RenderedImage)image, spatialReferenceSystem2D, raster2Model, bands, null, null) : coverageFactory.create((CharSequence)coverageName, (RenderedImage)image, (Envelope)coverageEnvelope2D, bands, null, null);
        return gridCoverage;
    }

    public static void setDecimationParameters(ImageReadParam readP, GridEnvelope baseGridRange, double[] requestedRes, double[] highestRes) {
        if (readP == null || baseGridRange == null) {
            throw new IllegalArgumentException("Specified parameters are null");
        }
        int w = baseGridRange.getSpan(0);
        int h = baseGridRange.getSpan(1);
        if (requestedRes == null) {
            readP.setSourceSubsampling(1, 1, 0, 0);
        } else {
            int subSamplingFactorX = (int)Math.floor(requestedRes[0] / highestRes[0]);
            int n = subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            while (w / subSamplingFactorX <= 0 && subSamplingFactorX >= 0) {
                --subSamplingFactorX;
            }
            subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            int subSamplingFactorY = (int)Math.floor(requestedRes[1] / highestRes[1]);
            int n2 = subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            while (h / subSamplingFactorY <= 0 && subSamplingFactorY >= 0) {
                --subSamplingFactorY;
            }
            subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            readP.setSourceSubsampling(subSamplingFactorX, subSamplingFactorY, 0, 0);
        }
    }

    public static NameImpl buildCoverageName(URL input) {
        if (input == null) {
            throw new IllegalArgumentException("Null URL specified");
        }
        String fileName = input.getPath();
        int slashIndex = fileName.lastIndexOf("/");
        int dotIndex = (fileName = fileName.substring(slashIndex + 1, fileName.length())).lastIndexOf(".");
        String coverageNameString = dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
        return new NameImpl(coverageNameString);
    }

    public static void setReadParameters(OverviewPolicy overviewPolicy, ImageReadParam readParam, GeneralEnvelope requestedEnvelope, Rectangle requestedDim, double[] highestRes, GridEnvelope gridRange, PixelInCell pixelInCell) throws IOException, TransformException {
        double[] requestedRes = null;
        if (overviewPolicy == null) {
            overviewPolicy = OverviewPolicy.NEAREST;
        }
        readParam.setSourceSubsampling(1, 1, 0, 0);
        if (overviewPolicy.equals((Object)OverviewPolicy.IGNORE)) {
            return;
        }
        if (requestedEnvelope != null) {
            GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper();
            geMapper.setEnvelope((Envelope)requestedEnvelope);
            geMapper.setGridRange((GridEnvelope)new GeneralGridEnvelope(requestedDim, 2));
            geMapper.setPixelAnchor(pixelInCell);
            AffineTransform transform = geMapper.createAffineTransform();
            requestedRes = CoverageUtilities.getResolution((AffineTransform)transform);
        }
        if (requestedRes == null) {
            return;
        }
        if (highestRes == null) {
            throw new IllegalArgumentException("Unspecified highest Resolution");
        }
        if (requestedRes[0] > highestRes[0] || requestedRes[1] > highestRes[1]) {
            Utilities.setDecimationParameters(readParam, gridRange, requestedRes, highestRes);
        }
    }

    public static GridCoverage createCoverage(ImageReaderSpi spi, Object input, int imageIndex, ImageReadParam imageReadParam, boolean useJAI, boolean useMultithreading, boolean newTransform, GridSampleDimension[] sampleDimensions, String coverageName, GridCoverageFactory coverageFactory, MathTransform raster2Model, CoordinateReferenceSystem coordinateReferenceSystem, GeneralEnvelope coverageEnvelope2D) throws IOException {
        PlanarImage image = Utilities.readImage(spi, input, imageIndex, useJAI, imageReadParam, useMultithreading);
        if (newTransform) {
            int ssWidth = image.getWidth();
            int ssHeight = image.getHeight();
            Rectangle sourceRegion = imageReadParam.getSourceRegion();
            double scaleX = (double)sourceRegion.width / (1.0 * (double)ssWidth);
            double scaleY = (double)sourceRegion.height / (1.0 * (double)ssHeight);
            double translateX = sourceRegion.x;
            double translateY = sourceRegion.y;
            return Utilities.createCoverageFromImage(coverageFactory, coverageName, imageIndex, image, ConcatenatedTransform.create((MathTransform)ProjectiveTransform.create((AffineTransform)new AffineTransform(scaleX, 0.0, 0.0, scaleY, translateX, translateY)), (MathTransform)raster2Model), coordinateReferenceSystem, null, sampleDimensions);
        }
        return Utilities.createCoverageFromImage(coverageFactory, coverageName, imageIndex, image, null, null, coverageEnvelope2D, sampleDimensions);
    }

    public static PlanarImage readImage(ImageReaderSpi spi, Object input, int imageIndex, boolean useJAI, ImageReadParam imageReadParam, boolean useMultithreading) throws IOException {
        PlanarImage planarImage;
        ImageReader reader;
        Object paramInput = null;
        if (input instanceof File) {
            paramInput = new FileImageInputStreamExtImpl((File)input);
        } else if (input instanceof AccessibleStream && input instanceof ImageInputStream) {
            paramInput = (ImageInputStream)input;
        } else if (input instanceof URIImageInputStream) {
            paramInput = (URIImageInputStream)input;
        } else if (input instanceof URL) {
            URL tempURL = (URL)input;
            String protocol = tempURL.getProtocol();
            if (protocol.equalsIgnoreCase("file")) {
                try {
                    File file = URLs.urlToFile((URL)tempURL);
                    paramInput = new FileImageInputStreamExtImpl(file);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create a valid input stream ", e);
                }
            } else if (tempURL.getProtocol().toLowerCase().startsWith("http") || tempURL.getProtocol().equalsIgnoreCase("dods")) {
                try {
                    paramInput = new URIImageInputStreamImpl(tempURL.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Failed to create a valid input stream ", e);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported Input type:" + String.valueOf(input));
        }
        ImageReaderSpi readerSpi = spi;
        if (useJAI) {
            ParameterBlock pbjImageRead = new ParameterBlock();
            pbjImageRead.add(paramInput);
            pbjImageRead.add(imageIndex);
            pbjImageRead.add(Boolean.FALSE);
            pbjImageRead.add(Boolean.FALSE);
            pbjImageRead.add(Boolean.FALSE);
            pbjImageRead.add(null);
            pbjImageRead.add(null);
            pbjImageRead.add(imageReadParam);
            reader = readerSpi.createReaderInstance();
            pbjImageRead.add(reader);
            String jaiOperation = useMultithreading ? "ImageReadMT" : "ImageRead";
            planarImage = JAI.create((String)jaiOperation, (ParameterBlock)pbjImageRead, null);
        } else {
            reader = readerSpi.createReaderInstance();
            reader.setInput(paramInput, true, true);
            planarImage = PlanarImage.wrapRenderedImage((RenderedImage)reader.read(imageIndex, imageReadParam));
            reader.dispose();
        }
        return planarImage;
    }

    public static GridCoverage compute(Object input, int imageIndex, boolean needTransformation, boolean isEmptyRequest, boolean useJAI, ImageReadParam imageReadParam, boolean useMultithreading, GridSampleDimension[] sampleDimensions, ImageReaderSpi imageReaderSpi, String coverageName, GridCoverageFactory coverageFactory, MathTransform raster2Model, CoordinateReferenceSystem coordinateReferenceSystem, GeneralEnvelope envelope2D) throws IOException {
        if (isEmptyRequest) {
            return null;
        }
        return Utilities.createCoverage(imageReaderSpi, input, imageIndex, imageReadParam, useJAI, useMultithreading, needTransformation, sampleDimensions, coverageName, coverageFactory, raster2Model, coordinateReferenceSystem, envelope2D);
    }

    public static final boolean ensureValidString(String ... strings) {
        for (String string : strings) {
            if (string != null && string.trim().length() > 0) continue;
            return false;
        }
        return true;
    }

    public static String buildIso8601Time(String date, String time) {
        String iso8601Date = null;
        if (Utilities.ensureValidString(date, time)) {
            String formattedDate = date.replace("/", "-");
            StringBuilder sb = new StringBuilder(formattedDate).append("T").append(time).append("Z");
            iso8601Date = sb.toString();
        }
        return iso8601Date;
    }

    public static boolean checkFileReadable(File file) {
        if (LOGGER.isLoggable(Level.FINE)) {
            String message = Utilities.getFileInfo(file);
            LOGGER.fine(message);
        }
        return file.exists() && file.canRead() && file.isFile();
    }

    public static String getFileInfo(File file) {
        StringBuilder builder = new StringBuilder();
        builder.append("Checking file:").append(FilenameUtils.getFullPath((String)file.getAbsolutePath())).append("\n");
        builder.append("isHidden:").append(file.isHidden()).append("\n");
        builder.append("exists:").append(file.exists()).append("\n");
        builder.append("isFile").append(file.isFile()).append("\n");
        builder.append("canRead:").append(file.canRead()).append("\n");
        builder.append("canWrite").append(file.canWrite()).append("\n");
        builder.append("canExecute:").append(file.canExecute()).append("\n");
        builder.append("isAbsolute:").append(file.isAbsolute()).append("\n");
        builder.append("lastModified:").append(file.lastModified()).append("\n");
        builder.append("length:").append(file.length());
        String message = builder.toString();
        return message;
    }

    public static Properties loadPropertiesFromURL(URL propsURL) {
        Properties properties = new Properties();
        try (InputStream openStream = propsURL.openStream();){
            properties.load(openStream);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        return properties;
    }
}

