/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.impl;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.io.CoverageAccess;
import org.geotools.coverage.io.Driver;
import org.geotools.coverage.io.FileDriver;
import org.geotools.coverage.io.impl.DefaultDriver;
import org.geotools.data.Parameter;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

public class DefaultFileDriver
extends DefaultDriver
implements FileDriver {
    private static final Logger LOGGER = Logging.getLogger(DefaultFileDriver.class);
    public static final Parameter<URL> URL = new Parameter("url", URL.class, (InternationalString)new SimpleInternationalString("URL"), (InternationalString)new SimpleInternationalString("Url to a local file or remote location"));
    private final List<String> fileExtensions;

    protected DefaultFileDriver(String name, String description, String title, Hints implementationHints, List<String> fileExtensions, EnumSet<Driver.DriverCapabilities> driverCapabilities) {
        super(name, description, title, driverCapabilities, implementationHints);
        Utilities.ensureNonNull((String)"fileExtensions", fileExtensions);
        this.fileExtensions = new ArrayList<String>(fileExtensions);
    }

    @Override
    public List<String> getFileExtensions() {
        return new ArrayList<String>(this.fileExtensions);
    }

    @Override
    protected boolean canConnect(Map<String, Serializable> params) {
        if (!params.containsKey(DefaultFileDriver.URL.key)) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to find parameter URL in parameters " + params.toString());
            }
            return false;
        }
        URL url = (URL)params.get(DefaultFileDriver.URL.key);
        return this.canConnect(url, params);
    }

    @Override
    protected boolean canCreate(Map<String, Serializable> params) {
        if (!params.containsKey(DefaultFileDriver.URL.key)) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to find parameter URL in parameters " + params.toString());
            }
            return false;
        }
        URL url = (URL)params.get(DefaultFileDriver.URL.key);
        return this.canCreate(url, params);
    }

    @Override
    protected boolean canDelete(Map<String, Serializable> params) {
        if (!params.containsKey(DefaultFileDriver.URL.key)) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to find parameter URL in parameters " + params.toString());
            }
            return false;
        }
        URL url = (URL)params.get(DefaultFileDriver.URL.key);
        return this.canDelete(url, params);
    }

    @Override
    protected CoverageAccess connect(Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("Invalid or no input provided.");
        }
        if (!params.containsKey(DefaultFileDriver.URL.key)) {
            throw new IllegalArgumentException("Unable to find parameter URL in parameters " + params.toString());
        }
        URL url = (URL)params.get(DefaultFileDriver.URL.key);
        return this.connect(url, params, hints, listener);
    }

    @Override
    protected CoverageAccess create(Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("Invalid or no input provided.");
        }
        if (!params.containsKey(DefaultFileDriver.URL.key)) {
            throw new IllegalArgumentException("Unable to find parameter URL in parameters " + params.toString());
        }
        URL url = (URL)params.get(DefaultFileDriver.URL.key);
        return this.create(url, params, hints, listener);
    }

    @Override
    protected CoverageAccess delete(Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("Invalid or no input provided.");
        }
        if (!params.containsKey(DefaultFileDriver.URL.key)) {
            throw new IllegalArgumentException("Unable to find parameter URL in parameters " + params.toString());
        }
        URL url = (URL)params.get(DefaultFileDriver.URL.key);
        return this.delete(url, params, hints, listener);
    }

    @Override
    public boolean canProcess(Driver.DriverCapabilities operation, URL url, Map<String, Serializable> params) {
        if (!this.getDriverCapabilities().contains((Object)operation)) {
            throw new UnsupportedOperationException("Operation " + String.valueOf((Object)operation) + " is not supported by this driver");
        }
        if (url == null) {
            if (!params.containsKey(DefaultFileDriver.URL.key)) {
                throw new IllegalArgumentException("Unable to find parameter URL in parameters " + params.toString());
            }
            url = (URL)params.get(DefaultFileDriver.URL.key);
        }
        switch (operation) {
            case CONNECT: {
                return this.canConnect(url, params);
            }
            case DELETE: {
                return this.canDelete(url, params);
            }
            case CREATE: {
                return this.canCreate(url, params);
            }
        }
        throw new IllegalArgumentException("Unrecognized operation " + String.valueOf((Object)operation));
    }

    @Override
    public CoverageAccess process(Driver.DriverCapabilities operation, URL url, Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        if (!this.getDriverCapabilities().contains((Object)operation)) {
            throw new UnsupportedOperationException("Operation " + String.valueOf((Object)operation) + " is not supported by this driver");
        }
        if (url == null) {
            if (!params.containsKey(DefaultFileDriver.URL.key)) {
                throw new IllegalArgumentException("Unable to find parameter URL in parameters " + params.toString());
            }
            url = (URL)params.get(DefaultFileDriver.URL.key);
        }
        switch (operation) {
            case CONNECT: {
                return this.connect(url, params, hints, listener);
            }
            case DELETE: {
                return this.delete(url, params, hints, listener);
            }
            case CREATE: {
                return this.create(url, params, hints, listener);
            }
        }
        throw new IllegalArgumentException("Unrecognized operation " + String.valueOf((Object)operation));
    }

    protected boolean canConnect(URL url, Map<String, Serializable> params) {
        return false;
    }

    protected boolean canCreate(URL url, Map<String, Serializable> params) {
        return false;
    }

    protected boolean canDelete(URL url, Map<String, Serializable> params) {
        return false;
    }

    protected CoverageAccess connect(URL url, Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        throw new UnsupportedOperationException("Operation not currently implemented");
    }

    protected CoverageAccess create(URL url, Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        throw new UnsupportedOperationException("Operation not currently implemented");
    }

    protected CoverageAccess delete(URL url, Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        throw new UnsupportedOperationException("Operation not currently implemented");
    }

    @Override
    protected Map<String, Parameter<?>> defineConnectParameterInfo() {
        HashMap params = new HashMap();
        params.put(DefaultFileDriver.URL.key, URL);
        return params;
    }

    @Override
    protected Map<String, Parameter<?>> defineCreateParameterInfo() {
        HashMap params = new HashMap();
        params.put(DefaultFileDriver.URL.key, URL);
        return params;
    }

    @Override
    protected Map<String, Parameter<?>> defineDeleteParameterInfo() {
        HashMap params = new HashMap();
        params.put(DefaultFileDriver.URL.key, URL);
        return params;
    }
}

