/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.ComplexType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.data.complex.expression.FeaturePropertyAccessorFactory;
import org.geotools.data.complex.feature.type.UniqueNameFeatureTypeFactoryImpl;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.feature.type.ComplexTypeImpl;
import org.geotools.feature.type.Types;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.NamespaceSupport;

public class FeaturePropertyAccessorTest {
    static final String EG = "urn:cgi:xmlns:Example:1.0";
    static final Name SIMPLE_ATTRIBUTE = new NameImpl("urn:cgi:xmlns:Example:1.0", "simpleAttribute");
    static final Name COMPLEX_ATTRIBUTE = new NameImpl("urn:cgi:xmlns:Example:1.0", "complexAttribute");
    static final Name ROOT_ATTRIBUTE = new NameImpl("urn:cgi:xmlns:Example:1.0", "rootAttribute");
    static final Name SINGLE_LEAF_ATTRIBUTE = new NameImpl("urn:cgi:xmlns:Example:1.0", "singleLeafAttribute");
    static final Name MULTI_LEAF_ATTRIBUTE = new NameImpl("urn:cgi:xmlns:Example:1.0", "multiLeafAttribute");
    static final NamespaceSupport NAMESPACES = new NamespaceSupport(){
        {
            this.declarePrefix("eg", FeaturePropertyAccessorTest.EG);
        }
    };

    @Test
    public void testComplexFeature() {
        FeatureType fType = FeaturePropertyAccessorTest.createFeatureType();
        AttributeDescriptor complexDesc = (AttributeDescriptor)fType.getDescriptor(COMPLEX_ATTRIBUTE);
        ComplexType complexAttType = (ComplexType)complexDesc.getType();
        AttributeDescriptor rootDesc = (AttributeDescriptor)complexAttType.getDescriptor(ROOT_ATTRIBUTE);
        ComplexType rootAttType = (ComplexType)rootDesc.getType();
        ArrayList<Object> properties = new ArrayList<Object>(fType.getDescriptors().size());
        AttributeDescriptor simpleAttributeDesc = (AttributeDescriptor)fType.getDescriptor(SIMPLE_ATTRIBUTE);
        AttributeImpl simpleAttribute = new AttributeImpl((Object)"simple value", simpleAttributeDesc, null);
        properties.add(simpleAttribute);
        ArrayList<AttributeImpl> rootPropertiesOne = new ArrayList<AttributeImpl>();
        AttributeDescriptor multiLeafDesc = (AttributeDescriptor)rootAttType.getDescriptor(MULTI_LEAF_ATTRIBUTE);
        AttributeImpl leafOne = new AttributeImpl((Object)"multi leaf value 1", multiLeafDesc, null);
        rootPropertiesOne.add(leafOne);
        AttributeImpl leafTwo = new AttributeImpl((Object)"multi leaf value 2", multiLeafDesc, null);
        rootPropertiesOne.add(leafTwo);
        AttributeDescriptor singleLeafDesc = (AttributeDescriptor)rootAttType.getDescriptor(SINGLE_LEAF_ATTRIBUTE);
        AttributeImpl singleLeaf = new AttributeImpl((Object)"single leaf value", singleLeafDesc, null);
        rootPropertiesOne.add(singleLeaf);
        HashMap<Name, String> userData = new HashMap<Name, String>();
        singleLeaf.getUserData().put(Attributes.class, userData);
        userData.put(Types.typeName((String)EG, (String)"att"), "test attribute");
        ComplexAttributeImpl rootOne = new ComplexAttributeImpl(rootPropertiesOne, rootDesc, null);
        ArrayList<AttributeImpl> rootPropertiesTwo = new ArrayList<AttributeImpl>();
        rootPropertiesTwo.add(leafOne);
        rootPropertiesTwo.add(singleLeaf);
        ComplexAttributeImpl rootTwo = new ComplexAttributeImpl(rootPropertiesTwo, rootDesc, null);
        ArrayList<AttributeImpl> rootPropertiesThree = new ArrayList<AttributeImpl>();
        rootPropertiesThree.add(singleLeaf);
        ComplexAttributeImpl rootThree = new ComplexAttributeImpl(rootPropertiesThree, rootDesc, null);
        ArrayList<ComplexAttributeImpl> complexProperties = new ArrayList<ComplexAttributeImpl>(2);
        complexProperties.add(rootOne);
        complexProperties.add(rootTwo);
        complexProperties.add(rootThree);
        ComplexAttributeImpl complexAttribute = new ComplexAttributeImpl(complexProperties, complexDesc, null);
        properties.add(complexAttribute);
        FeatureImpl feature = new FeatureImpl(properties, fType, (FeatureId)new FeatureIdImpl("test1"));
        AttributeExpressionImpl ex = new AttributeExpressionImpl("eg:simpleAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertEquals((Object)simpleAttribute, (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertEquals((Object)complexAttribute, (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Object o = ex.evaluate((Object)feature);
        Assert.assertTrue((boolean)(o instanceof List));
        Assert.assertEquals((long)3L, (long)((List)o).size());
        Assert.assertEquals((Object)rootOne, ((List)o).get(0));
        Assert.assertEquals((Object)rootTwo, ((List)o).get(1));
        Assert.assertEquals((Object)rootThree, ((List)o).get(2));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute/eg:singleLeafAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        o = ex.evaluate((Object)feature);
        Assert.assertTrue((boolean)(o instanceof List));
        Assert.assertEquals((long)3L, (long)((List)o).size());
        Assert.assertEquals((Object)singleLeaf, ((List)o).get(0));
        Assert.assertEquals((Object)singleLeaf, ((List)o).get(1));
        Assert.assertEquals((Object)singleLeaf, ((List)o).get(2));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute[1]", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertEquals((Object)rootOne, (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute[2]", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertEquals((Object)rootTwo, (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute[3]/eg:singleLeafAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertEquals((Object)singleLeaf, (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute[3]/eg:multiLeafAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertNull((Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute[2]/eg:multiLeafAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertEquals((Object)leafOne, (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute[2]/eg:multiLeafAttribute[2]", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertNull((Object)ex.evaluate((Object)feature));
        boolean exceptionThrown = false;
        try {
            ex.setLenient(false);
            Assert.assertNull((Object)ex.evaluate((Object)singleLeaf));
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        if (!exceptionThrown) {
            Assert.fail((String)"Expecting Exception since object passed in is not a complex attribute.");
        }
        ex = new AttributeExpressionImpl("randomAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertNull((Object)ex.evaluate((Object)feature));
        Assert.assertNull((Object)ex.evaluate((Object)fType));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute[3]/eg:singleLeafAttribute/@eg:att", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertEquals((Object)"test attribute", (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:simpleAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertEquals((Object)simpleAttributeDesc, (Object)ex.evaluate((Object)fType));
        ex = new AttributeExpressionImpl("eg:complexAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertEquals((Object)complexDesc, (Object)ex.evaluate((Object)fType));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertEquals((Object)rootDesc, (Object)ex.evaluate((Object)fType));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute/eg:singleLeafAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertEquals((Object)singleLeafDesc, (Object)ex.evaluate((Object)fType));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute/eg:multiLeafAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        Assert.assertEquals((Object)multiLeafDesc, (Object)ex.evaluate((Object)fType));
        ex = new AttributeExpressionImpl("java.lang.Thread.sleep(30000)", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        long start = System.currentTimeMillis();
        Assert.assertNull((Object)ex.evaluate((Object)feature));
        long runtime = System.currentTimeMillis() - start;
        Assert.assertTrue((String)"java.lang.Thread.sleep(30000) was executed", (runtime < 30000L ? 1 : 0) != 0);
        start = System.currentTimeMillis();
        Assert.assertNull((Object)ex.evaluate((Object)fType));
        runtime = System.currentTimeMillis() - start;
        Assert.assertTrue((String)"java.lang.Thread.sleep(30000) was executed", (runtime < 30000L ? 1 : 0) != 0);
    }

    public static FeatureType createFeatureType() {
        UniqueNameFeatureTypeFactoryImpl tfac = new UniqueNameFeatureTypeFactoryImpl();
        NameImpl fName = new NameImpl(EG, "complexFeatureType");
        ArrayList<AttributeDescriptorImpl> schema = new ArrayList<AttributeDescriptorImpl>();
        AttributeTypeImpl attType = new AttributeTypeImpl(SIMPLE_ATTRIBUTE, String.class, false, false, Collections.emptyList(), null, null);
        AttributeDescriptorImpl attDesc = new AttributeDescriptorImpl((AttributeType)attType, SIMPLE_ATTRIBUTE, 0, 1, true, null);
        schema.add(attDesc);
        ArrayList<AttributeDescriptorImpl> rootProperties = new ArrayList<AttributeDescriptorImpl>();
        attType = new AttributeTypeImpl(SINGLE_LEAF_ATTRIBUTE, String.class, false, false, Collections.emptyList(), null, null);
        attDesc = new AttributeDescriptorImpl((AttributeType)attType, SINGLE_LEAF_ATTRIBUTE, 0, 1, true, null);
        rootProperties.add(attDesc);
        attType = new AttributeTypeImpl(MULTI_LEAF_ATTRIBUTE, String.class, false, false, Collections.emptyList(), null, null);
        attDesc = new AttributeDescriptorImpl((AttributeType)attType, MULTI_LEAF_ATTRIBUTE, 0, -1, true, null);
        rootProperties.add(attDesc);
        attType = new ComplexTypeImpl(ROOT_ATTRIBUTE, rootProperties, false, false, Collections.emptyList(), null, null);
        attDesc = new AttributeDescriptorImpl((AttributeType)attType, ROOT_ATTRIBUTE, 0, -1, true, null);
        ArrayList<AttributeDescriptorImpl> nestedProperties = new ArrayList<AttributeDescriptorImpl>(1);
        nestedProperties.add(attDesc);
        attType = new ComplexTypeImpl(COMPLEX_ATTRIBUTE, nestedProperties, false, false, Collections.emptyList(), null, null);
        attDesc = new AttributeDescriptorImpl((AttributeType)attType, COMPLEX_ATTRIBUTE, 0, -1, true, null);
        schema.add(attDesc);
        return tfac.createFeatureType((Name)fName, schema, null, false, Collections.emptyList(), null, null);
    }
}

