/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2011, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */

package org.geotools.data.complex.feature.xpath;

import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.type.Name;

/**
 * Special node iterator for {@link Attribute}.
 *
 * @author Justin Deoliveira (The Open Planning Project)
 * @author Gabriel Roldan (Axios Engineering)
 */
public class XmlAttributeNodeIterator implements NodeIterator {

    /** The feature node pointer */
    AttributeNodePointer pointer;

    /** The feature. */
    Attribute feature;

    /** The name */
    Name name;

    int position = 0;

    public XmlAttributeNodeIterator(AttributeNodePointer pointer, Name name) {
        this.pointer = pointer;
        this.name = name;
        feature = pointer.getImmediateAttribute();
    }

    /** Always return 1, only a single property. */
    @Override
    public int getPosition() {
        return position;
    }

    /** Return true if position == 1. */
    @Override
    public boolean setPosition(int position) {
        this.position = position;
        return position < 2;
    }

    @Override
    public NodePointer getNodePointer() {
        return new XmlAttributeNodePointer(pointer, feature, name);
    }
}
