/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.attribute.extractor;

import java.util.HashSet;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.FilterAttributeExtractor;
import org.junit.Assert;
import org.junit.Test;

public class FilterAttributeExtractorTest {
    @Test
    public void testNonExistingAttributeEvaluatesToAttributeDescriptor() throws Exception {
        SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
        sftb.setName("twoDoublesFeatureType");
        sftb.add("pointOne", Double.class);
        sftb.add("pointTwo", Double.class);
        SimpleFeatureType type = sftb.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{5.0, 2.5}, null);
        FilterAttributeExtractor fae = new FilterAttributeExtractor(type);
        Assert.assertNotNull((Object)fae.visit((PropertyName)new AttributeExpressionImpl("type"), (Object)feature));
        HashSet<String> attributeTypesDescriptorsNames = new HashSet<String>();
        attributeTypesDescriptorsNames.add("type");
        Assert.assertEquals(attributeTypesDescriptorsNames, (Object)fae.visit((PropertyName)new AttributeExpressionImpl("type"), (Object)feature));
    }
}

