/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.geotools.filter.FilterFactoryImpl;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class LiterateTest {
    FilterFactoryImpl ff = new FilterFactoryImpl();

    @Test
    public void testLiterate() {
        List<Integer> list1 = Arrays.asList(1, 2, 3, 4);
        List<Integer> list2 = Arrays.asList(4, 3, 2, 1);
        HashMap<String, List<Integer>> map = new HashMap<String, List<Integer>>();
        map.put("list1", list1);
        map.put("list2", list2);
        Function exp = this.ff.function("literate", (Expression)this.ff.property("index"), (Expression)this.ff.function("size", (Expression)this.ff.property("list1")), (Expression)this.ff.multiply((Expression)this.ff.function("litem", (Expression)this.ff.property("list1"), (Expression)this.ff.property("index")), (Expression)this.ff.function("litem", (Expression)this.ff.property("list2"), (Expression)this.ff.property("index"))));
        Object value = exp.evaluate(map);
        Assert.assertTrue((boolean)(value instanceof List));
        Assert.assertEquals(Arrays.asList(4.0, 6.0, 6.0, 4.0), (Object)value);
    }

    @Test
    public void testEmptyList() {
        List<Integer> list = Arrays.asList(new Integer[0]);
        HashMap<String, List<Integer>> map = new HashMap<String, List<Integer>>();
        map.put("list1", list);
        Function exp = this.ff.function("literate", (Expression)this.ff.property("index"), (Expression)this.ff.function("size", (Expression)this.ff.property("list1")), (Expression)this.ff.function("litem", (Expression)this.ff.property("list1"), (Expression)this.ff.property("index")));
        Object value = exp.evaluate(map);
        Assert.assertTrue((boolean)(value instanceof List));
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)value);
    }
}

