/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.feature.type;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDContentTypeCategory;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.data.complex.feature.type.ComplexTypeProxy;
import org.geotools.util.logging.Logging;
import org.geotools.xs.XSSchema;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;

public class Types
extends org.geotools.feature.type.Types {
    private static final Logger LOGGER = Logging.getLogger(Types.class);

    public static boolean isElement(ComplexType type, Name att) {
        PropertyDescriptor descriptor = Types.descriptor((ComplexType)type, (Name)att);
        if (descriptor == null) {
            return false;
        }
        Map userData = descriptor.getUserData();
        if (userData.isEmpty()) {
            return false;
        }
        return userData.get(XSDElementDeclaration.class) != null;
    }

    public static boolean isSimpleContentType(PropertyType type) {
        if (type == XSSchema.ANYSIMPLETYPE_TYPE) {
            throw new RuntimeException("Unexpected simple type");
        }
        PropertyType superType = type.getSuper();
        if (superType == XSSchema.ANYSIMPLETYPE_TYPE) {
            return true;
        }
        if (superType == null) {
            return false;
        }
        return Types.isSimpleContentType(superType);
    }

    public static boolean isGeometryType(AttributeType type) {
        if (type instanceof GeometryType) {
            return true;
        }
        return type instanceof ComplexTypeProxy && ((ComplexTypeProxy)type).getSubject() instanceof GeometryType;
    }

    public static boolean canHaveTextContent(PropertyType type) {
        if (type == XSSchema.ANYTYPE_TYPE) {
            return true;
        }
        PropertyType superType = type.getSuper();
        if (superType == XSSchema.ANYTYPE_TYPE) {
            Map userData = type.getUserData();
            if (userData != null && userData.get(XSDTypeDefinition.class) != null) {
                XSDTypeDefinition typeDef = (XSDTypeDefinition)userData.get(XSDTypeDefinition.class);
                if (typeDef instanceof XSDComplexTypeDefinition) {
                    XSDComplexTypeDefinition complexTypeDef = (XSDComplexTypeDefinition)typeDef;
                    XSDContentTypeCategory category = complexTypeDef.getContentTypeCategory();
                    XSDDerivationMethod derivMethod = complexTypeDef.getDerivationMethod();
                    boolean hasMixedContent = XSDContentTypeCategory.MIXED_LITERAL.equals((Object)category);
                    boolean isExtension = XSDDerivationMethod.EXTENSION_LITERAL.equals((Object)derivMethod);
                    return isExtension && hasMixedContent;
                }
            } else if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("No XSDTypeDefinition found for type " + String.valueOf(type.getName()));
            }
        }
        return false;
    }
}

