/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ExtensionSymbolizer;
import org.geotools.brewer.styling.builder.AbstractStyleBuilder;
import org.geotools.brewer.styling.builder.DescriptionBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;

public class ExtensionSymbolizerBuilder
extends AbstractStyleBuilder<ExtensionSymbolizer> {
    private String name;
    private Expression geometry;
    private DescriptionBuilder description = new DescriptionBuilder(this).unset();
    private Unit<?> uom;
    private String extensionName;
    private Map<String, Expression> parameters = new HashMap<String, Expression>();

    public ExtensionSymbolizerBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public ExtensionSymbolizerBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public ExtensionSymbolizerBuilder name(String name) {
        this.unset = false;
        this.name = name;
        return this;
    }

    public ExtensionSymbolizerBuilder geometry(Expression geometry) {
        this.geometry = geometry;
        this.unset = false;
        return this;
    }

    public ExtensionSymbolizerBuilder geometryName(String geometry) {
        return this.geometry(this.property(geometry));
    }

    public ExtensionSymbolizerBuilder geometry(String cqlExpression) {
        return this.geometry(this.cqlExpression(cqlExpression));
    }

    public ExtensionSymbolizerBuilder uom(Unit<?> uom) {
        this.unset = false;
        this.uom = uom;
        return this;
    }

    public ExtensionSymbolizerBuilder extensionName(String extensionName) {
        this.unset = false;
        this.extensionName = extensionName;
        return this;
    }

    public DescriptionBuilder description() {
        this.unset = false;
        return this.description;
    }

    public ExtensionSymbolizerBuilder param(String name, Expression param) {
        this.unset = false;
        this.parameters.put(name, param);
        return this;
    }

    @Override
    public ExtensionSymbolizer build() {
        if (this.unset) {
            return null;
        }
        ExtensionSymbolizer symbolizer = this.sf.extensionSymbolizer(this.name, null, this.description.build(), this.uom, this.extensionName, this.parameters);
        symbolizer.setGeometry(this.geometry);
        if (this.parent == null) {
            this.reset();
        }
        return symbolizer;
    }

    public ExtensionSymbolizerBuilder reset() {
        this.name = null;
        this.geometry = null;
        this.description.unset();
        this.uom = null;
        this.extensionName = null;
        this.parameters = new HashMap<String, Expression>();
        this.unset = false;
        return this;
    }

    public ExtensionSymbolizerBuilder reset(ExtensionSymbolizer symbolizer) {
        if (symbolizer == null) {
            return this.unset();
        }
        this.name = symbolizer.getName();
        this.geometry = symbolizer.getGeometry();
        this.description.reset(symbolizer.getDescription());
        this.uom = symbolizer.getUnitOfMeasure();
        this.extensionName = symbolizer.getExtensionName();
        this.parameters.clear();
        this.parameters.putAll(symbolizer.getParameters());
        this.unset = false;
        return this;
    }

    @Override
    public ExtensionSymbolizerBuilder unset() {
        return (ExtensionSymbolizerBuilder)super.unset();
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().extension().init(this);
    }
}

