/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.filter.expression;

import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.brewer.styling.builder.Builder;
import org.geotools.factory.CommonFactoryFinder;

public class PropertyNameBuilder
implements Builder<PropertyName> {
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    String xpath = null;
    Name name = null;
    boolean unset = false;

    public PropertyNameBuilder() {
        this.reset();
    }

    public PropertyNameBuilder(PropertyName propertyName) {
        this.reset(propertyName);
    }

    public PropertyNameBuilder property(String xpath) {
        return this.name(xpath);
    }

    public PropertyNameBuilder name(String name) {
        this.xpath = name;
        this.name = null;
        this.unset = false;
        return this;
    }

    public PropertyNameBuilder name(Name name) {
        this.name = name;
        this.xpath = null;
        this.unset = false;
        return this;
    }

    @Override
    public PropertyName build() {
        if (this.unset) {
            return null;
        }
        if (this.name != null) {
            return this.ff.property(this.name);
        }
        return this.ff.property(this.xpath);
    }

    public PropertyNameBuilder reset() {
        this.unset = false;
        this.xpath = null;
        return this;
    }

    public PropertyNameBuilder reset(PropertyName original) {
        this.unset = false;
        this.xpath = original.getPropertyName();
        return this;
    }

    public PropertyNameBuilder unset() {
        this.unset = true;
        this.xpath = null;
        return this;
    }
}

