/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import java.util.ArrayList;
import java.util.List;
import org.geotools.brewer.styling.builder.AbstractSLDBuilder;
import org.geotools.brewer.styling.builder.FeatureTypeConstraintBuilder;
import org.geotools.brewer.styling.builder.RemoteOWSBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.brewer.styling.builder.StyledLayerDescriptorBuilder;
import org.geotools.data.DataStore;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.Style;
import org.geotools.styling.UserLayer;
import org.opengis.feature.simple.SimpleFeatureType;

public class UserLayerBuilder
extends AbstractSLDBuilder<UserLayer> {
    DataStore inlineFeatureDataStore;
    SimpleFeatureType inlineFeatureType;
    RemoteOWSBuilder remoteOWS = new RemoteOWSBuilder().unset();
    List<FeatureTypeConstraintBuilder> featureTypeConstraint = new ArrayList<FeatureTypeConstraintBuilder>();
    List<StyleBuilder> userStyles = new ArrayList<StyleBuilder>();

    public UserLayerBuilder() {
        this(null);
    }

    public UserLayerBuilder(AbstractSLDBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public UserLayerBuilder inlineData(DataStore store, SimpleFeatureType sft) {
        this.unset = false;
        this.inlineFeatureDataStore = store;
        this.inlineFeatureType = sft;
        return this;
    }

    public UserLayerBuilder remoteOWS(String onlineResource, String service) {
        this.unset = false;
        this.remoteOWS.resource(onlineResource).service(service);
        return this;
    }

    public FeatureTypeConstraintBuilder featureTypeConstraint() {
        this.unset = false;
        FeatureTypeConstraintBuilder builder = new FeatureTypeConstraintBuilder(this);
        this.featureTypeConstraint.add(builder);
        return builder;
    }

    public StyleBuilder style() {
        this.unset = false;
        StyleBuilder sb = new StyleBuilder(this);
        this.userStyles.add(sb);
        return sb;
    }

    public UserLayerBuilder reset() {
        this.unset = false;
        this.inlineFeatureDataStore = null;
        this.inlineFeatureType = null;
        this.remoteOWS.unset();
        this.featureTypeConstraint.clear();
        this.userStyles.clear();
        return this;
    }

    public UserLayerBuilder reset(UserLayer other) {
        if (other == null) {
            return this.unset();
        }
        this.inlineFeatureDataStore = other.getInlineFeatureDatastore();
        this.inlineFeatureType = other.getInlineFeatureType();
        this.remoteOWS.reset(other.getRemoteOWS());
        this.featureTypeConstraint.clear();
        for (FeatureTypeConstraint featureTypeConstraint : other.getLayerFeatureConstraints()) {
            this.featureTypeConstraint.add(new FeatureTypeConstraintBuilder(this).reset(featureTypeConstraint));
        }
        this.userStyles.clear();
        for (FeatureTypeConstraint featureTypeConstraint : other.getUserStyles()) {
            this.userStyles.add(new StyleBuilder(this).reset((Style)featureTypeConstraint));
        }
        this.unset = false;
        return this;
    }

    @Override
    public UserLayerBuilder unset() {
        return (UserLayerBuilder)super.unset();
    }

    @Override
    public UserLayer build() {
        if (this.unset) {
            return null;
        }
        UserLayer layer = this.sf.createUserLayer();
        layer.setRemoteOWS(this.remoteOWS.build());
        layer.setInlineFeatureDatastore(this.inlineFeatureDataStore);
        layer.setInlineFeatureType(this.inlineFeatureType);
        if (!this.featureTypeConstraint.isEmpty()) {
            FeatureTypeConstraint[] constraints = new FeatureTypeConstraint[this.featureTypeConstraint.size()];
            for (int i = 0; i < constraints.length; ++i) {
                constraints[i] = this.featureTypeConstraint.get(i).build();
            }
            layer.setLayerFeatureConstraints(constraints);
        }
        for (StyleBuilder sb : this.userStyles) {
            layer.addUserStyle(sb.build());
        }
        return layer;
    }

    @Override
    protected void buildSLDInternal(StyledLayerDescriptorBuilder sb) {
        sb.userLayer().init(this);
    }
}

