/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import java.awt.Color;
import org.geotools.brewer.styling.builder.AbstractStyleBuilder;
import org.geotools.brewer.styling.builder.GraphicBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.styling.Fill;
import org.geotools.util.Converters;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Graphic;

public class FillBuilder
extends AbstractStyleBuilder<org.opengis.style.Fill> {
    Expression color;
    Expression opacity;
    GraphicBuilder graphic = new GraphicBuilder(this).unset();

    public FillBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public FillBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public FillBuilder color(Expression color) {
        this.unset = false;
        this.color = color;
        return this;
    }

    public FillBuilder color(Color color) {
        return this.color(this.literal(color));
    }

    public FillBuilder color(String cqlExpression) {
        return this.color(this.cqlExpression(cqlExpression));
    }

    public FillBuilder colorHex(String hex) {
        Color color = (Color)Converters.convert((Object)hex, Color.class);
        if (color == null) {
            throw new IllegalArgumentException("The provided expression could not be turned into a color: " + hex);
        }
        return this.color(color);
    }

    public FillBuilder opacity(Expression opacity) {
        this.unset = false;
        this.opacity = opacity;
        return this;
    }

    public FillBuilder opacity(double opacity) {
        return this.opacity(this.literal(opacity));
    }

    public FillBuilder opacity(String cqlExpression) {
        return this.opacity(this.cqlExpression(cqlExpression));
    }

    public GraphicBuilder graphicFill() {
        this.unset = false;
        return this.graphic;
    }

    @Override
    public Fill build() {
        if (this.unset) {
            return null;
        }
        Fill fill = this.sf.createFill(this.color, null, this.opacity, this.graphic.build());
        if (this.parent == null) {
            this.reset();
        }
        return fill;
    }

    @Override
    public FillBuilder unset() {
        return (FillBuilder)super.unset();
    }

    public FillBuilder reset() {
        this.unset = false;
        this.color = Fill.DEFAULT.getColor();
        this.opacity = Fill.DEFAULT.getOpacity();
        this.graphic.unset();
        return this;
    }

    public FillBuilder reset(org.opengis.style.Fill original) {
        if (original == null) {
            return this.unset();
        }
        this.unset = false;
        this.color = original.getColor();
        this.opacity = original.getOpacity();
        this.graphic.reset((Graphic)original.getGraphicFill());
        return this;
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().polygon().fill().init(this);
    }
}

