/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.color;

import java.io.IOException;

public class PaletteSuitability {
    public static final int QUALITY_GOOD = 3;
    public static final int QUALITY_UNKNOWN = 2;
    public static final int QUALITY_DOUBTFUL = 1;
    public static final int QUALITY_BAD = 0;
    public static final int VIEWER_COLORBLIND = 0;
    public static final int VIEWER_PHOTOCOPY = 1;
    public static final int VIEWER_PROJECTOR = 2;
    public static final int VIEWER_LCD = 3;
    public static final int VIEWER_CRT = 4;
    public static final int VIEWER_PRINT = 5;
    private int[][] paletteSuitability = new int[11][6];
    private int maxColors = 0;

    public int[] getSuitability(int numClasses) {
        return this.paletteSuitability[numClasses - 2];
    }

    public int getSuitability(int numClasses, int viewerType) {
        return this.paletteSuitability[numClasses - 2][viewerType];
    }

    public void setSuitability(int numClasses, String[] suitability) throws IOException {
        if (numClasses > this.maxColors) {
            this.maxColors = numClasses;
        }
        if (suitability.length == 6) {
            for (int i = 0; i < 6; ++i) {
                this.paletteSuitability[numClasses - 2][i] = suitability[i].equals("G") ? 3 : (suitability[i].equals("D") ? 1 : (suitability[i].equals("B") ? 0 : 2));
            }
        } else {
            throw new IOException("wrong number of items in suitability list");
        }
    }

    public int getMaxColors() {
        return this.maxColors;
    }
}

