/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.color;

import java.awt.Color;
import java.util.List;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.brewer.color.ColorBrewer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.ClassificationFunction;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.parameter.Parameter;

public class PaletteFunction
extends FunctionExpressionImpl {
    ClassificationFunction classifier;
    String paletteName;
    FilterFactory ff;
    public static FunctionName NAME = new FunctionNameImpl("Palette", FunctionNameImpl.parameter((String)"color", Color.class), new Parameter[]{FunctionNameImpl.parameter((String)"classifier", ClassificationFunction.class), FunctionNameImpl.parameter((String)"paletteName", String.class)});

    public PaletteFunction() {
        this(CommonFactoryFinder.getFilterFactory(null));
    }

    public PaletteFunction(FilterFactory factory) {
        super(NAME);
        this.ff = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.ff = factory;
    }

    public void setParameters(List<Expression> args) {
        super.setParameters(args);
        this.classifier = (ClassificationFunction)this.getExpression(0);
        this.paletteName = (String)this.getExpression(1).evaluate(null, String.class);
    }

    public Expression getEvaluationExpression() {
        return (Expression)this.classifier.getParameters().get(0);
    }

    public void setEvaluationExpression(Expression e) {
        this.classifier.getParameters().set(0, e);
    }

    public ClassificationFunction getClassifier() {
        return this.classifier;
    }

    public void setClassifier(ClassificationFunction cf) {
        this.classifier = cf;
    }

    public int getNumberOfClasses() {
        return this.classifier.getClasses();
    }

    public void setNumberOfClasses(int i) {
        this.classifier.setClasses(i);
    }

    public String getPaletteName() {
        return this.paletteName;
    }

    public void setPaletteName(String s) {
        this.paletteName = s;
    }

    private String intToHex(int i) {
        Object prelim = Integer.toHexString(i);
        while (((String)prelim).length() < 2) {
            prelim = "0" + (String)prelim;
        }
        if (((String)prelim).length() > 2) {
            prelim = ((String)prelim).substring(0, 1);
        }
        return prelim;
    }

    public Object evaluate(Object feature) {
        int classNum = this.classifier.getClasses();
        ColorBrewer brewer = new ColorBrewer();
        int klass = (Integer)this.classifier.evaluate(feature);
        BrewerPalette pal = brewer.getPalette(this.paletteName);
        Color[] colors = pal.getColors(classNum);
        String color = "#" + this.intToHex(colors[klass].getRed()) + this.intToHex(colors[klass].getGreen()) + this.intToHex(colors[klass].getBlue());
        return color;
    }

    public String toString() {
        return "Color Brewer palette";
    }
}

