/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.geotools.brewer.styling.builder.AbstractSLDBuilder;
import org.geotools.brewer.styling.builder.AbstractStyleBuilder;
import org.geotools.brewer.styling.builder.FeatureTypeStyleBuilder;
import org.geotools.brewer.styling.builder.FillBuilder;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.Style;
import org.geotools.util.SimpleInternationalString;
import org.opengis.style.Fill;
import org.opengis.util.InternationalString;

public class StyleBuilder
extends AbstractStyleBuilder<Style> {
    List<FeatureTypeStyleBuilder> fts = new ArrayList<FeatureTypeStyleBuilder>();
    String name;
    String styleAbstract;
    String title;
    boolean isDefault;
    FillBuilder background;

    public StyleBuilder() {
        super(null);
        this.reset();
    }

    StyleBuilder(AbstractSLDBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public StyleBuilder name(String name) {
        this.name = name;
        return this;
    }

    public StyleBuilder title(String title) {
        this.title = title;
        return this;
    }

    public StyleBuilder styleAbstract(String styleAbstract) {
        this.styleAbstract = styleAbstract;
        return this;
    }

    public FeatureTypeStyleBuilder featureTypeStyle() {
        this.unset = false;
        FeatureTypeStyleBuilder ftsBuilder = new FeatureTypeStyleBuilder(this);
        this.fts.add(ftsBuilder);
        return ftsBuilder;
    }

    public FillBuilder background() {
        this.unset = false;
        this.background = new FillBuilder();
        return this.background;
    }

    @Override
    public Style build() {
        NamedStyle s;
        if (this.unset) {
            return null;
        }
        if (this.fts.isEmpty()) {
            s = this.sf.createNamedStyle();
            s.setName(this.name);
        } else {
            s = this.sf.createStyle();
            s.setName(this.name);
            if (this.styleAbstract != null) {
                s.getDescription().setAbstract((InternationalString)new SimpleInternationalString(this.styleAbstract));
            }
            if (this.title != null) {
                s.getDescription().setTitle((InternationalString)new SimpleInternationalString(this.title));
            }
            for (FeatureTypeStyleBuilder builder : this.fts) {
                s.featureTypeStyles().add(builder.build());
            }
            s.setDefault(this.isDefault);
        }
        if (this.background != null) {
            s.setBackground(this.background.build());
        }
        this.reset();
        return s;
    }

    @Override
    public StyleBuilder unset() {
        return (StyleBuilder)super.unset();
    }

    public StyleBuilder reset() {
        this.fts.clear();
        this.name = null;
        this.styleAbstract = null;
        this.title = null;
        this.isDefault = false;
        this.background = null;
        this.unset = false;
        return this;
    }

    public StyleBuilder reset(Style style) {
        if (style == null) {
            return this.unset();
        }
        this.fts.clear();
        for (FeatureTypeStyle ft : style.featureTypeStyles()) {
            this.fts.add(new FeatureTypeStyleBuilder(this).reset(ft));
        }
        this.name = style.getName();
        this.styleAbstract = Optional.ofNullable(style.getDescription().getAbstract()).map(Object::toString).orElse(null);
        this.title = Optional.ofNullable(style.getDescription().getTitle()).map(Object::toString).orElse(null);
        this.isDefault = style.isDefault();
        this.background = new FillBuilder().reset((Fill)style.getBackground());
        this.unset = false;
        return this;
    }

    @Override
    public Style buildStyle() {
        return this.build();
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
    }
}

