/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.brewer.styling.builder.AbstractSLDBuilder;
import org.geotools.brewer.styling.builder.StyledLayerDescriptorBuilder;
import org.geotools.styling.Extent;
import org.geotools.styling.FeatureTypeConstraint;
import org.opengis.filter.Filter;

public class FeatureTypeConstraintBuilder
extends AbstractSLDBuilder<FeatureTypeConstraint> {
    private List<Extent> extents = new ArrayList<Extent>();
    private Filter filter;
    private String featureTypeName;

    public FeatureTypeConstraintBuilder() {
        this(null);
    }

    public FeatureTypeConstraintBuilder(AbstractSLDBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public FeatureTypeConstraintBuilder extent(String name, String value) {
        this.unset = false;
        this.extents.add(this.sf.createExtent(name, value));
        return this;
    }

    public FeatureTypeConstraintBuilder filter(Filter filter) {
        this.unset = false;
        this.filter = filter;
        return this;
    }

    public FeatureTypeConstraintBuilder featureTypeName(String name) {
        this.unset = false;
        this.featureTypeName = name;
        return this;
    }

    @Override
    public FeatureTypeConstraint build() {
        if (this.unset) {
            return null;
        }
        Extent[] ea = this.extents.toArray(new Extent[this.extents.size()]);
        FeatureTypeConstraint constraint = this.sf.createFeatureTypeConstraint(this.featureTypeName, this.filter, ea);
        if (this.parent == null) {
            this.reset();
        }
        return constraint;
    }

    public FeatureTypeConstraintBuilder reset() {
        this.unset = false;
        this.featureTypeName = null;
        this.filter = null;
        this.extents.clear();
        return this;
    }

    public FeatureTypeConstraintBuilder reset(FeatureTypeConstraint constraint) {
        if (constraint == null) {
            return this.unset();
        }
        this.featureTypeName = constraint.getFeatureTypeName();
        this.filter = constraint.getFilter();
        this.extents.clear();
        this.extents.addAll(Arrays.asList(constraint.getExtents()));
        this.unset = false;
        return this;
    }

    @Override
    public FeatureTypeConstraintBuilder unset() {
        return (FeatureTypeConstraintBuilder)super.unset();
    }

    @Override
    protected void buildSLDInternal(StyledLayerDescriptorBuilder sb) {
        throw new UnsupportedOperationException("Can't build a SLD out of a feature type contraint");
    }
}

