/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.arcgrid;

import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageMetadata;
import it.geosolutions.imageio.plugins.arcgrid.spi.AsciiGridsImageReaderSpi;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.measure.Unit;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.geotools.api.coverage.ColorInterpretation;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.PrjFileReader;
import org.geotools.gce.arcgrid.ArcGridFormat;
import org.geotools.geometry.GeneralBounds;
import org.geotools.image.io.ImageIOExt;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.util.NumberRange;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ArcGridReader
extends AbstractGridCoverage2DReader
implements GridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger(ArcGridReader.class);
    private static final ImageReaderSpi readerSPI = new AsciiGridsImageReaderSpi();
    private double inNoData = Double.NaN;

    public ArcGridReader(Object input) throws DataSourceException {
        this(input, null);
    }

    public ArcGridReader(Object input, Hints hints) throws DataSourceException {
        super(input, hints);
        this.coverageName = "AsciiGrid";
        try {
            this.checkSource(input, hints);
            Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
            if (tempCRS != null) {
                this.crs = (CoordinateReferenceSystem)tempCRS;
                LOGGER.log(Level.FINE, "Using default coordinate reference system ");
            } else {
                this.initCoordinateReferenceSystem();
            }
            ImageReader reader = readerSPI.createReaderInstance();
            reader.setInput(this.inStream);
            this.parseMetadata(reader);
            this.getResolutionInfo(reader);
            this.finalStreamPreparation();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException((Throwable)e);
        }
    }

    private void finalStreamPreparation() throws IOException {
        if (this.closeMe) {
            this.inStream.close();
        } else {
            this.inStream.reset();
            this.inStream.mark();
        }
    }

    private void checkSource(Object input, Hints hints) throws UnsupportedEncodingException, DataSourceException, IOException, FileNotFoundException {
        URL sourceURL;
        this.closeMe = true;
        if (input instanceof URL && (sourceURL = (URL)input).getProtocol().compareToIgnoreCase("file") == 0) {
            this.source = input = URLs.urlToFile((URL)sourceURL);
        }
        if (input instanceof File) {
            File sourceFile = (File)input;
            if (!sourceFile.exists() || sourceFile.isDirectory() || !sourceFile.canRead()) {
                throw new DataSourceException("Provided file does not exist or is a directory or is not readable!");
            }
            this.coverageName = sourceFile.getName();
            int dotIndex = this.coverageName.indexOf(".");
            this.gzipped = this.coverageName.toLowerCase().endsWith("gz");
            String string = this.coverageName = dotIndex == -1 ? this.coverageName : this.coverageName.substring(0, dotIndex);
            if (this.gzipped) {
                this.inStream = ImageIO.createImageInputStream(new GZIPInputStream(new FileInputStream(sourceFile)));
            } else {
                this.inStreamSPI = ImageIOExt.getImageInputStreamSPI((Object)sourceFile);
                if (this.inStreamSPI == null) {
                    throw new DataSourceException("No input stream for the provided source");
                }
                this.inStream = this.inStreamSPI.createInputStreamInstance(sourceFile, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            }
        } else if (input instanceof URL) {
            URL tempURL = (URL)input;
            try {
                input = tempURL.openConnection().getInputStream();
                this.inStream = ImageIO.createImageInputStream(new GZIPInputStream((InputStream)input));
                this.gzipped = true;
            }
            catch (Exception e) {
                ((InputStream)input).close();
                this.gzipped = false;
                this.inStream = ImageIO.createImageInputStream(tempURL.openConnection().getInputStream());
            }
        } else if (input instanceof InputStream) {
            this.closeMe = false;
            this.inStream = ImageIO.getUseCache() ? new FileCacheImageInputStream((InputStream)input, null) : new MemoryCacheImageInputStream((InputStream)input);
            this.inStream.mark();
        } else if (input instanceof ImageInputStream) {
            this.closeMe = false;
            this.inStream = (ImageInputStream)input;
            this.inStream.mark();
        } else {
            throw new IllegalArgumentException("Unsupported input type");
        }
        if (this.inStream == null) {
            throw new DataSourceException("No input stream for the provided source");
        }
    }

    private void getResolutionInfo(ImageReader reader) throws IOException, TransformException {
        Rectangle actualDim = new Rectangle(0, 0, reader.getWidth(0), reader.getHeight(0));
        this.originalGridRange = new GridEnvelope2D(actualDim);
        this.highestRes = ArcGridReader.getResolution((GeneralBounds)this.originalEnvelope, (Rectangle2D)actualDim, (CoordinateReferenceSystem)this.crs);
    }

    public Format getFormat() {
        return new ArcGridFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IllegalArgumentException, IOException {
        GeneralBounds readEnvelope = null;
        Rectangle requestedDim = null;
        OverviewPolicy overviewPolicy = null;
        if (params != null) {
            for (GeneralParameterValue generalParameterValue : params) {
                ParameterValue param = (ParameterValue)generalParameterValue;
                String name = param.getDescriptor().getName().getCode();
                if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    readEnvelope = new GeneralBounds((Bounds)gg.getEnvelope2D());
                    requestedDim = gg.getGridRange2D().getBounds();
                    continue;
                }
                if (!name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName().toString())) continue;
                overviewPolicy = (OverviewPolicy)param.getValue();
            }
        }
        return this.createCoverage(readEnvelope, requestedDim, overviewPolicy);
    }

    private GridCoverage2D createCoverage(GeneralBounds requestedEnvelope, Rectangle requestedDim, OverviewPolicy overviewPolicy) throws IOException {
        Integer imageChoice;
        if (!this.closeMe) {
            this.inStream.reset();
            this.inStream.mark();
        }
        ImageReadParam readP = new ImageReadParam();
        try {
            imageChoice = this.setReadParams(overviewPolicy, readP, requestedEnvelope, requestedDim);
        }
        catch (IOException | TransformException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        ParameterBlock pbjImageRead = new ParameterBlock();
        if (this.source instanceof File) {
            if (!this.gzipped) {
                if (this.inStreamSPI != null) {
                    pbjImageRead.add(this.inStreamSPI.createInputStreamInstance(this.source, ImageIO.getUseCache(), ImageIO.getCacheDirectory()));
                } else {
                    pbjImageRead.add(ImageIO.createImageInputStream(this.source));
                }
            } else {
                pbjImageRead.add(ImageIO.createImageInputStream(new GZIPInputStream(new FileInputStream((File)this.source))));
            }
        } else if (this.source instanceof ImageInputStream || this.source instanceof InputStream) {
            pbjImageRead.add(this.inStream);
        } else if (this.source instanceof URL) {
            if (this.gzipped) {
                ImageIO.createImageInputStream(new GZIPInputStream(((URL)this.source).openConnection().getInputStream()));
            } else {
                pbjImageRead.add(ImageIO.createImageInputStream(((URL)this.source).openConnection().getInputStream()));
            }
        }
        pbjImageRead.add(imageChoice);
        pbjImageRead.add(Boolean.FALSE);
        pbjImageRead.add(Boolean.FALSE);
        pbjImageRead.add(Boolean.FALSE);
        pbjImageRead.add(null);
        pbjImageRead.add(null);
        pbjImageRead.add(readP);
        pbjImageRead.add(readerSPI.createReaderInstance());
        RenderedOp asciiCoverage = JAI.create((String)"ImageRead", (ParameterBlock)pbjImageRead, (RenderingHints)this.hints);
        try {
            Unit uom = null;
            Category nan = Double.isNaN(this.inNoData) ? new Category((CharSequence)Vocabulary.formatInternational((int)147), new Color(0, 0, 0, 0), Double.NaN) : new Category((CharSequence)Vocabulary.formatInternational((int)147), new Color[]{new Color(0, 0, 0, 0)}, NumberRange.create((double)this.inNoData, (double)this.inNoData));
            ColorModel cm = asciiCoverage.getColorModel();
            ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation((ColorModel)cm, (int)0);
            if (colorInterpretation == null) {
                throw new IOException("Unrecognized sample dimension type");
            }
            GridSampleDimension band = new GridSampleDimension((CharSequence)this.coverageName, new Category[]{nan}, uom);
            HashMap properties = new HashMap();
            CoverageUtilities.setNoDataProperty(properties, (Object)this.inNoData);
            return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)asciiCoverage, (Bounds)this.originalEnvelope, new GridSampleDimension[]{band}, null, properties);
        }
        catch (NoSuchElementException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException((Throwable)e);
        }
    }

    private void parseMetadata(ImageReader reader) throws Exception {
        this.setLayout(reader);
        IIOMetadata metadata = reader.getImageMetadata(0);
        if (!(metadata instanceof AsciiGridsImageMetadata)) {
            throw new DataSourceException("Unexpected error! Metadata are not of the expected class.");
        }
        AsciiGridsImageMetadata gridMetadata = (AsciiGridsImageMetadata)metadata;
        Node root = gridMetadata.getAsTree("it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageMetadata_1.0");
        Node child = root.getFirstChild();
        NamedNodeMap attributes = child.getAttributes();
        boolean grass = attributes.getNamedItem("GRASS").getNodeValue().equalsIgnoreCase("True");
        child = child.getNextSibling();
        attributes = child.getAttributes();
        int hrWidth = Integer.parseInt(attributes.getNamedItem("nColumns").getNodeValue());
        int hrHeight = Integer.parseInt(attributes.getNamedItem("nRows").getNodeValue());
        this.originalGridRange = new GridEnvelope2D(new Rectangle(0, 0, hrWidth, hrHeight));
        boolean pixelIsArea = AsciiGridsImageMetadata.RasterSpaceType.valueOf((String)attributes.getNamedItem("rasterSpaceType").getNodeValue()).equals((Object)AsciiGridsImageMetadata.RasterSpaceType.PixelIsArea);
        if (!grass) {
            this.inNoData = Double.parseDouble(attributes.getNamedItem("noDataValue").getNodeValue());
        }
        child = child.getNextSibling();
        attributes = child.getAttributes();
        double cellsizeX = Double.parseDouble(attributes.getNamedItem("cellsizeX").getNodeValue());
        double cellsizeY = Double.parseDouble(attributes.getNamedItem("cellsizeY").getNodeValue());
        double xll = Double.parseDouble(attributes.getNamedItem("xll").getNodeValue());
        double yll = Double.parseDouble(attributes.getNamedItem("yll").getNodeValue());
        if (!pixelIsArea) {
            double correctionX = cellsizeX / 2.0;
            double correctionY = cellsizeY / 2.0;
            xll -= correctionX;
            yll -= correctionY;
        }
        this.originalEnvelope = new GeneralBounds(new double[]{xll, yll}, new double[]{xll + (double)hrWidth * cellsizeX, yll + (double)hrHeight * cellsizeY});
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
    }

    private void initCoordinateReferenceSystem() throws FileNotFoundException, IOException {
        if (this.source instanceof File || this.source instanceof URL && ((URL)this.source).getProtocol() == "file") {
            String sourceAsString = this.source instanceof File ? ((File)this.source).getAbsolutePath() : ((URL)this.source).getFile();
            int index = sourceAsString.lastIndexOf(".");
            StringBuffer prjFileName = index == -1 ? new StringBuffer(sourceAsString) : new StringBuffer(sourceAsString.substring(0, index));
            prjFileName.append(".prj");
            File prjFile = new File(prjFileName.toString());
            if (prjFile.exists()) {
                try (FileChannel channel = new FileInputStream(prjFile).getChannel();
                     PrjFileReader projReader = new PrjFileReader((ReadableByteChannel)channel);){
                    this.crs = projReader.getCoordinateReferenceSystem();
                }
                catch (IOException | FactoryException e) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        }
        if (this.crs == null) {
            this.crs = AbstractGridFormat.getDefaultCRS();
            LOGGER.fine("Unable to find crs, continuing with default CRS");
        }
    }

    public int getGridCoverageCount() {
        return 1;
    }
}

