/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.joining;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.opengis.wfs20.ResolveValueType;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.complex.AbstractMappingFeatureIterator;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessMappingFeatureIterator;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureCollection;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.data.joining.JoiningQuery;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.util.factory.Hints;
import org.xml.sax.helpers.NamespaceSupport;

public class JoiningNestedAttributeMapping
extends NestedAttributeMapping {
    protected Map<Object, Instance> instances = new HashMap<Object, Instance>();

    public JoiningNestedAttributeMapping(Expression idExpression, Expression parentExpression, XPathUtil.StepList targetXPath, boolean isMultiValued, Map<Name, Expression> clientProperties, Expression sourceElement, XPathUtil.StepList sourcePath, NamespaceSupport namespaces) throws IOException {
        super(idExpression, parentExpression, targetXPath, isMultiValued, clientProperties, sourceElement, sourcePath, namespaces);
    }

    @Override
    public List<Feature> getInputFeatures(Object foreignKeyValue, FeatureTypeMapping fMapping) {
        throw new UnsupportedOperationException("Internal error: Not Allowed to run this method for Joining Nested Attribute Mapping!");
    }

    public DataAccessMappingFeatureIterator initSourceFeatures(Instance instance, Name featureTypeName, CoordinateReferenceSystem reprojection, List<PropertyName> selectedProperties, boolean includeMandatory, int resolveDepth, Integer resolveTimeOut, Transaction transaction) throws IOException {
        JoiningQuery query = new JoiningQuery();
        query.setCoordinateSystemReproject(reprojection);
        query.setRootMapping(((JoiningQuery)instance.baseTableQuery).getRootMapping());
        FeatureTypeMapping fMapping = AppSchemaDataAccessRegistry.getMappingByName(featureTypeName);
        AttributeMapping mapping = fMapping.getAttributeMapping(this.nestedTargetXPath);
        if (mapping == null) {
            throw new IllegalArgumentException("Mapping is missing for: '" + this.nestedTargetXPath + "'!");
        }
        Expression nestedSourceExpression = mapping.getSourceExpression();
        ArrayList<JoiningQuery.QueryJoin> joins = new ArrayList<JoiningQuery.QueryJoin>();
        if (instance.baseTableQuery instanceof JoiningQuery && ((JoiningQuery)instance.baseTableQuery).getQueryJoins() != null) {
            joins.addAll(((JoiningQuery)instance.baseTableQuery).getQueryJoins());
        }
        JoiningQuery.QueryJoin join = new JoiningQuery.QueryJoin();
        join.setForeignKeyName(this.sourceExpression);
        join.setJoiningKeyName(nestedSourceExpression);
        join.setJoiningTypeName(instance.baseTableQuery.getTypeName());
        join.setDenormalised(fMapping.isDenormalised());
        join.setSortBy(instance.baseTableQuery.getSortBy());
        join.setMaxFeatures(instance.baseTableQuery.getMaxFeatures());
        join.setRootMapping(((JoiningQuery)instance.baseTableQuery).getRootMapping());
        join.setStartIndex(instance.baseTableQuery.getStartIndex());
        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
        instance.mapping.getFeatureIdExpression().accept((ExpressionVisitor)extractor, null);
        for (String pn : extractor.getAttributeNameSet()) {
            join.addId(pn);
        }
        joins.add(0, join);
        query.setQueryJoins(joins);
        if (selectedProperties != null && !selectedProperties.isEmpty()) {
            selectedProperties = new ArrayList<PropertyName>(selectedProperties);
            selectedProperties.add(this.filterFac.property(this.nestedTargetXPath.toString()));
        }
        Hints hints = new Hints();
        hints.put((Object)Query.INCLUDE_MANDATORY_PROPS, (Object)includeMandatory);
        if (resolveDepth > 0) {
            hints.put((Object)Hints.RESOLVE, (Object)ResolveValueType.ALL);
            hints.put((Object)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)resolveDepth);
            hints.put((Object)Hints.RESOLVE_TIMEOUT, (Object)resolveTimeOut);
        } else {
            hints.put((Object)Hints.RESOLVE, (Object)ResolveValueType.NONE);
        }
        query.setHints(hints);
        query.setProperties(selectedProperties);
        FeatureSource<FeatureType, Feature> fSource = DataAccessRegistry.getFeatureSource(featureTypeName);
        if (fSource == null) {
            throw new IOException("Internal error: Source could not be found");
        }
        FeatureCollection collection = fSource.getFeatures((Query)query);
        if (!(collection instanceof MappingFeatureCollection)) {
            throw new IOException("Internal error: Mapping feature Collection expected but found " + collection);
        }
        MappingFeatureCollection mfc = (MappingFeatureCollection)collection;
        mfc.setUnrolledFilter(instance.baseTableQuery.getFilter());
        FeatureIterator<Feature> featureIterator = mfc.features(transaction);
        if (!(featureIterator instanceof DataAccessMappingFeatureIterator)) {
            throw new IOException("Internal error: Data Access Mapping feature Iterator expected but found " + featureIterator);
        }
        DataAccessMappingFeatureIterator daFeatureIterator = (DataAccessMappingFeatureIterator)featureIterator;
        ArrayList<Expression> foreignIds = new ArrayList<Expression>();
        for (int i = 0; i < query.getQueryJoins().size(); ++i) {
            for (int j = 0; j < query.getQueryJoins().get(i).getIds().size(); ++j) {
                foreignIds.add((Expression)this.filterFac.property("FOREIGN_ID_" + i + "_" + j));
            }
        }
        daFeatureIterator.setForeignIds(foreignIds);
        instance.featureIterators.put(featureTypeName, daFeatureIterator);
        instance.nestedSourceExpressions.put(featureTypeName, nestedSourceExpression);
        for (Instance.Skip toSkip : instance.skipped) {
            while (daFeatureIterator.hasNext() && daFeatureIterator.checkForeignIdValues(toSkip.idValues)) {
                daFeatureIterator.skip();
            }
        }
        return daFeatureIterator;
    }

    public void open(Object caller, Query baseTableQuery, FeatureTypeMapping mapping) throws IOException {
        if (this.instances.get(caller) != null) {
            throw new IllegalArgumentException("Trying to open Joining Nested Attribute Mapping that is already open!");
        }
        Instance instance = new Instance();
        instance.baseTableQuery = baseTableQuery;
        instance.mapping = mapping;
        this.instances.put(caller, instance);
    }

    public void close(Object caller) {
        Instance instance = this.instances.get(caller);
        if (instance != null) {
            for (FeatureIterator featureIterator : instance.featureIterators.values()) {
                try {
                    featureIterator.close();
                }
                catch (Exception exception) {}
            }
        } else {
            throw new IllegalArgumentException("Trying to close Joining Nested Attribute Mapping hasn't been opened!");
        }
        instance.featureIterators.clear();
        this.instances.remove(caller);
    }

    @Override
    public List<Feature> getInputFeatures(Object caller, Object foreignKeyValue, List<Object> idValues, Object feature, CoordinateReferenceSystem reprojection, List<PropertyName> selectedProperties, boolean includeMandatory) throws IOException {
        Expression nestedSourceExpression;
        Instance instance;
        if (this.isSameSource()) {
            throw new UnsupportedOperationException("Link field is missing from feature chaining mapping!");
        }
        Transaction transaction = null;
        if (caller instanceof AbstractMappingFeatureIterator) {
            transaction = ((AbstractMappingFeatureIterator)caller).getTransaction();
        }
        if ((instance = this.instances.get(caller)) == null) {
            throw new IllegalArgumentException("Trying to read Joining Nested Attribute Mapping that is not open.");
        }
        Object featureTypeName = this.getNestedFeatureType(feature);
        if (featureTypeName == null || !(featureTypeName instanceof Name)) {
            throw new IllegalArgumentException("Internal error: Feature type name expected but found " + featureTypeName);
        }
        DataAccessMappingFeatureIterator featureIterator = instance.featureIterators.get(featureTypeName);
        if (featureIterator == null) {
            featureIterator = this.initSourceFeatures(instance, (Name)featureTypeName, reprojection, selectedProperties, includeMandatory, 0, null, transaction);
        }
        if ((nestedSourceExpression = instance.nestedSourceExpressions.get(featureTypeName)) == null) {
            throw new IllegalArgumentException("Internal error: nested source expression expected but found " + featureTypeName);
        }
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>();
        if (featureIterator != null) {
            while (featureIterator.hasNext() && featureIterator.peekNextValue(nestedSourceExpression).toString().equals(foreignKeyValue.toString()) && featureIterator.checkForeignIdValues(idValues)) {
                matchingFeatures.addAll(featureIterator.skip());
            }
        }
        for (Name name : instance.featureIterators.keySet()) {
            DataAccessMappingFeatureIterator fIt = instance.featureIterators.get(name);
            if (fIt == featureIterator) continue;
            this.skipFeatures(fIt, instance.nestedSourceExpressions.get(name), foreignKeyValue, idValues);
        }
        instance.skipped.add(new Instance.Skip(idValues));
        return matchingFeatures;
    }

    @Override
    public List<Feature> getFeatures(Object caller, Object foreignKeyValue, List<Object> idValues, CoordinateReferenceSystem reprojection, Object feature, List<PropertyName> selectedProperties, boolean includeMandatory, int resolveDepth, Integer resolveTimeOut) throws IOException {
        Expression nestedSourceExpression;
        Instance instance;
        if (this.isSameSource()) {
            throw new UnsupportedOperationException("Link field is missing from feature chaining mapping!");
        }
        Transaction transaction = null;
        if (caller instanceof AbstractMappingFeatureIterator) {
            transaction = ((AbstractMappingFeatureIterator)caller).getTransaction();
        }
        if ((instance = this.instances.get(caller)) == null) {
            throw new IllegalArgumentException("Trying to read Joining Nested Attribute Mapping that is not open.");
        }
        Object featureTypeName = this.getNestedFeatureType(feature);
        if (featureTypeName == null || !(featureTypeName instanceof Name)) {
            throw new IllegalArgumentException("Something is wrong!!");
        }
        DataAccessMappingFeatureIterator featureIterator = instance.featureIterators.get(featureTypeName);
        if (featureIterator == null) {
            featureIterator = this.initSourceFeatures(instance, (Name)featureTypeName, reprojection, selectedProperties, includeMandatory, resolveDepth, resolveTimeOut, transaction);
        }
        if ((nestedSourceExpression = instance.nestedSourceExpressions.get(featureTypeName)) == null) {
            throw new IllegalArgumentException("Internal error: nested source expression expected but found " + featureTypeName);
        }
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>();
        if (featureIterator != null) {
            while (featureIterator.hasNext() && featureIterator.checkForeignIdValues(idValues) && featureIterator.peekNextValue(nestedSourceExpression).toString().equals(foreignKeyValue.toString())) {
                matchingFeatures.add(featureIterator.next());
            }
        }
        for (Name name : instance.featureIterators.keySet()) {
            DataAccessMappingFeatureIterator fIt = instance.featureIterators.get(name);
            if (fIt == featureIterator) continue;
            this.skipFeatures(fIt, instance.nestedSourceExpressions.get(name), foreignKeyValue, idValues);
        }
        instance.skipped.add(new Instance.Skip(idValues));
        return matchingFeatures;
    }

    protected void skipFeatures(DataAccessMappingFeatureIterator featureIterator, Expression nestedSourceExpression, Object foreignKeyValue, List<Object> idValues) throws IOException {
        while (featureIterator.hasNext() && featureIterator.peekNextValue(nestedSourceExpression).toString().equals(foreignKeyValue.toString()) && featureIterator.checkForeignIdValues(idValues)) {
            featureIterator.skip();
        }
    }

    public void skip(Object caller, Object foreignKeyValue, List<Object> idValues) throws IOException {
        Instance instance = this.instances.get(caller);
        if (instance == null) {
            throw new IllegalArgumentException("Trying to read Joining Nested Attribute Mapping that is not open.");
        }
        for (Name name : instance.featureIterators.keySet()) {
            DataAccessMappingFeatureIterator fIt = instance.featureIterators.get(name);
            Expression nestedSourceExpression = instance.nestedSourceExpressions.get(name);
            this.skipFeatures(fIt, nestedSourceExpression, foreignKeyValue, idValues);
        }
        instance.skipped.add(new Instance.Skip(idValues));
    }

    public Map<Name, DataAccessMappingFeatureIterator> getNestedFeatureIterators(Object caller) {
        if (this.instances.containsKey(caller)) {
            return this.instances.get((Object)caller).featureIterators;
        }
        return Collections.emptyMap();
    }

    protected static class Instance {
        public Map<Name, DataAccessMappingFeatureIterator> featureIterators = new HashMap<Name, DataAccessMappingFeatureIterator>();
        public Map<Name, Expression> nestedSourceExpressions = new HashMap<Name, Expression>();
        public List<Skip> skipped = new ArrayList<Skip>();
        public Query baseTableQuery;
        public FeatureTypeMapping mapping;

        protected Instance() {
        }

        public static class Skip {
            List<Object> idValues;

            public Skip(List<Object> idValues) {
                this.idValues = idValues;
            }
        }
    }
}

