/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.geometry.Position;
import org.geotools.api.parameter.Parameter;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.geometry.Position1D;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.CRS;

public class ToDirectPositionFunction
implements Function {
    private final List<Expression> parameters;
    private final Literal fallback;
    private static final String USAGE = "Usage: toDirectPosition('SRS_NAME'(optional), srsName(optional), point 1, point 2(optional))";
    public static final FunctionName NAME = new FunctionNameImpl("toDirectPosition", FunctionNameImpl.parameter((String)"return", Position.class), new Parameter[]{FunctionNameImpl.parameter((String)"parameter", Object.class, (int)1, (int)4)});
    private static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    public static final Expression SRS_NAME = ff.literal((Object)"SRS_NAME");

    public ToDirectPositionFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public ToDirectPositionFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public String getName() {
        return NAME.getName();
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Position.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Position1D geom;
        Expression param1 = this.parameters.get(0);
        CoordinateReferenceSystem crs = null;
        if (param1.equals(SRS_NAME)) {
            if (this.parameters.size() < 3 || this.parameters.size() > 4) {
                throw new IllegalArgumentException("Wrong number of parameters toDirectPosition function: " + this.parameters.toString() + ". Usage: toDirectPosition('SRS_NAME'(optional), srsName(optional), point 1, point 2(optional))");
            }
            String srsName = (String)this.parameters.get(1).evaluate(object, String.class);
            try {
                crs = CRS.decode((String)srsName);
            }
            catch (NoSuchAuthorityCodeException e) {
                throw new IllegalArgumentException("Invalid or unsupported SRS name detected for toDirectPosition function: " + srsName + ". Cause: " + e.getMessage());
            }
            catch (FactoryException e) {
                throw new RuntimeException("Unable to decode SRS name. Cause: " + e.getMessage());
            }
            if (this.parameters.size() == 3) {
                geom = new Position1D(crs);
            } else {
                geom = new Position2D(crs);
                geom.setOrdinate(1, ((Double)this.parameters.get(3).evaluate(object, Double.class)).doubleValue());
            }
            geom.setOrdinate(0, ((Double)this.parameters.get(2).evaluate(object, Double.class)).doubleValue());
        } else {
            if (this.parameters.size() > 2) {
                throw new IllegalArgumentException("Too many parameters for toDirectPosition function: " + this.parameters.toString() + ". Usage: toDirectPosition('SRS_NAME'(optional), srsName(optional), point 1, point 2(optional))");
            }
            if (this.parameters.size() == 1) {
                geom = new Position1D();
            } else {
                geom = new Position2D();
                geom.setOrdinate(1, ((Double)this.parameters.get(1).evaluate(object, Double.class)).doubleValue());
            }
            geom.setOrdinate(0, ((Double)param1.evaluate(object, Double.class)).doubleValue());
        }
        return (T)geom;
    }
}

