/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.ComplexType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyType;
import org.geotools.data.DataUtilities;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.AppSchemaFeatureTypeRegistry;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.util.EmfComplexFeatureReader;
import org.geotools.data.util.FeatureStreams;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.test.AppSchemaTestSupport;
import org.geotools.xsd.SchemaIndex;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class GeoSciMLTest
extends AppSchemaTestSupport {
    private static final String GSMLNS = "http://www.cgi-iugs.org/xml/GeoSciML/2";
    private static final String schemaBase = "/test-data/";
    private static EmfComplexFeatureReader reader;
    private static DataAccess<FeatureType, Feature> mappingDataStore;

    @BeforeClass
    public static void oneTimeSetUp() throws IOException {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = GeoSciMLTest.class.getResource("/test-data/mappedPolygons.xml");
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        mappingDataStore = DataAccessFinder.getDataStore(dsParams);
        reader = EmfComplexFeatureReader.newInstance();
    }

    private SchemaIndex loadSchema(String location) throws IOException {
        URL catalogLocation = this.getClass().getResource("/test-data/mappedPolygons.oasis.xml");
        reader.setResolver(catalogLocation);
        return reader.parse(new URL(location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParseSchema() throws Exception {
        SchemaIndex schemaIndex;
        try {
            schemaIndex = this.loadSchema("http://schemas.opengis.net/GeoSciML/Gsml.xsd");
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            throw e;
        }
        AppSchemaFeatureTypeRegistry typeRegistry = new AppSchemaFeatureTypeRegistry();
        try {
            typeRegistry.addSchemas(schemaIndex);
            Name typeName = Types.typeName((String)GSMLNS, (String)"MappedFeatureType");
            ComplexType mf = (ComplexType)typeRegistry.getAttributeType(typeName);
            Assert.assertNotNull((Object)mf);
            Assert.assertTrue((boolean)(mf instanceof FeatureType));
            typeName = Types.typeName((String)"http://www.opengis.net/sampling/1.0", (String)"SamplingFeatureType");
            mf = (ComplexType)typeRegistry.getAttributeType(typeName);
            Assert.assertNotNull((Object)mf);
            Assert.assertTrue((boolean)(mf instanceof FeatureType));
        }
        finally {
            typeRegistry.disposeSchemaIndexes();
        }
    }

    @Test
    public void testLoadMappingsConfig() throws Exception {
        XMLConfigDigester reader = new XMLConfigDigester();
        URL url = this.getClass().getResource("/test-data/mappedPolygons.xml");
        AppSchemaDataAccessDTO config = reader.parse(url);
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config);
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)1L, (long)mappings.size());
    }

    @Test
    public void testDataStore() throws Exception {
        try {
            Name typeName = Types.typeName((String)GSMLNS, (String)"MappedFeature");
            FeatureType boreholeType = mappingDataStore.getSchema(typeName);
            Assert.assertNotNull((Object)boreholeType);
            int EXPECTED_RESULT_COUNT = 2;
            FeatureCollection features = mappingDataStore.getFeatureSource(typeName).getFeatures();
            int resultCount = DataUtilities.count((FeatureCollection)features);
            Assert.assertEquals((long)2L, (long)resultCount);
            int count = 0;
            try (FeatureIterator it = features.features();){
                while (it.hasNext()) {
                    it.next();
                    ++count;
                }
            }
            Assert.assertEquals((long)2L, (long)count);
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            throw e;
        }
    }

    @Test
    public void testFeatureSourceHonoursQueryNamespace() throws Exception {
        Name typeName = Types.typeName((String)GSMLNS, (String)"MappedFeature");
        FeatureSource source = mappingDataStore.getFeatureSource(typeName);
        Query query = new Query();
        query.setNamespace(new URI(typeName.getNamespaceURI()));
        query.setTypeName(typeName.getLocalPart());
        FeatureCollection features = source.getFeatures(query);
        Assert.assertNotNull((Object)features);
        Assert.assertEquals((long)2L, (long)DataUtilities.count((FeatureCollection)features));
    }

    @Test
    public void testComplexFeatureNamespaces() throws Exception {
        Name typeName = Types.typeName((String)GSMLNS, (String)"MappedFeature");
        FeatureSource source = mappingDataStore.getFeatureSource(typeName);
        Query query = new Query();
        query.setNamespace(new URI(typeName.getNamespaceURI()));
        query.setTypeName(typeName.getLocalPart());
        FeatureCollection features = source.getFeatures(query);
        Assert.assertNotNull((Object)features);
        try (Stream featureStream = FeatureStreams.toFeatureStream((FeatureCollection)features);){
            Optional<Feature> first = featureStream.findFirst();
            Optional<Map> mapOpt = first.map(Attribute::getDescriptor).map(AttributeDescriptor::getType).map(PropertyType::getUserData).map(m -> m.get("declaredNamespacesMap")).filter(v -> v instanceof Map).map(x -> (Map)x);
            Assert.assertTrue((boolean)mapOpt.isPresent());
            Map namespacesMap = mapOpt.get();
            Assert.assertEquals((long)3L, (long)namespacesMap.keySet().size());
            Assert.assertTrue((boolean)this.getExpectedNamespaces().stream().allMatch(ns -> namespacesMap.containsValue(ns)));
        }
    }

    private List<String> getExpectedNamespaces() {
        return Arrays.asList("http://www.w3.org/XML/1998/namespace", "http://www.opengis.net/gml", GSMLNS);
    }
}

