/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.util;

import java.util.ArrayList;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.data.complex.util.ComplexFeatureConstants;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.gml3.GMLSchema;
import org.geotools.util.Converters;
import org.geotools.xs.XSSchema;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class ComplexAttributeConverterFactoryTest {
    @Test
    public void testLeafComplexAttribute() {
        ArrayList<AttributeImpl> attributes = new ArrayList<AttributeImpl>();
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl(XSSchema.STRING_TYPE, ComplexFeatureConstants.SIMPLE_CONTENT, 1, 1, true, null);
        attributes.add(new AttributeImpl((Object)"rini", (AttributeDescriptor)descriptor, null));
        ComplexAttributeImpl gmlName = new ComplexAttributeImpl(attributes, GMLSchema.CODETYPE_TYPE, null);
        String nameString = (String)Converters.convert((Object)gmlName, String.class);
        Assert.assertEquals((Object)"rini", (Object)nameString);
    }

    @Test
    public void testParentComplexAttribute() {
        ArrayList<AttributeImpl> attributes = new ArrayList<AttributeImpl>();
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl(XSSchema.STRING_TYPE, ComplexFeatureConstants.SIMPLE_CONTENT, 1, 1, true, null);
        attributes.add(new AttributeImpl((Object)"rini", (AttributeDescriptor)descriptor, null));
        ComplexAttributeImpl gmlName = new ComplexAttributeImpl(attributes, GMLSchema.CODETYPE_TYPE, null);
        ArrayList<ComplexAttributeImpl> parentAttributes = new ArrayList<ComplexAttributeImpl>();
        parentAttributes.add(gmlName);
        ComplexAttributeImpl parentAtt = new ComplexAttributeImpl(parentAttributes, GMLSchema.ABSTRACTFEATURETYPE_TYPE, null);
        String nameString = (String)Converters.convert((Object)parentAtt, String.class);
        Assert.assertEquals((Object)parentAtt.toString(), (Object)nameString);
        Assert.assertNotSame((Object)"rini", (Object)nameString);
    }

    @Test
    public void testFeatureId() throws Exception {
        FeatureId id = (FeatureId)Converters.convert((Object)"blah", FeatureId.class);
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((Object)id.getID(), (Object)"blah");
    }

    @Test
    public void testGeometry() {
        GeometryCollection geometry = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING)).createGeometryCollection();
        GeometryAttributeImpl geoatt = new GeometryAttributeImpl((Object)geometry, (GeometryDescriptor)new GeometryDescriptorImpl((GeometryType)new GeometryTypeImpl((Name)new NameImpl(""), GeometryCollection.class, null, false, false, null, null, null), (Name)new NameImpl(""), 0, 0, false, null), null);
        Geometry geometry2 = (Geometry)Converters.convert((Object)geoatt, Geometry.class);
        Assert.assertSame((Object)geometry, (Object)geometry2);
    }

    @Test
    public void testAttributeConversion() {
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl(XSSchema.DOUBLE_TYPE, ComplexFeatureConstants.SIMPLE_CONTENT, 1, 1, true, null);
        AttributeImpl attribute = new AttributeImpl((Object)35.0, (AttributeDescriptor)descriptor, null);
        Object result = Converters.convert((Object)attribute, Double.class);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(Double.class));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)35.0));
        result = Converters.convert((Object)attribute, String.class);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(String.class));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"35.0"));
    }

    @Test
    public void testAttributeListConversion() {
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl(XSSchema.INTEGER_TYPE, ComplexFeatureConstants.SIMPLE_CONTENT, 1, 1, true, null);
        AttributeImpl attribute1 = new AttributeImpl((Object)35, (AttributeDescriptor)descriptor, null);
        AttributeImpl attribute2 = new AttributeImpl((Object)40, (AttributeDescriptor)descriptor, null);
        ArrayList<AttributeImpl> attributes = new ArrayList<AttributeImpl>();
        attributes.add(attribute1);
        attributes.add(attribute2);
        Object result = Converters.convert(attributes, String.class);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(String.class));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"35, 40"));
        result = Converters.convert(attributes, Integer.class);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.nullValue());
    }
}

