/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.appschema.jdbc.JoiningJDBCFeatureSource;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.NonFeatureTypeProxy;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.filter.ComplexFilterSplitter;
import org.geotools.data.complex.filter.UnmappingFilterVisitor;
import org.geotools.data.complex.filter.UnmappingFilterVisitorFactory;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.spi.CustomSourceDataStore;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.data.joining.JoiningQuery;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.SortByImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.xml.sax.helpers.NamespaceSupport;

public class AppSchemaDataAccess
implements DataAccess<FeatureType, Feature> {
    private static final Logger LOGGER = Logging.getLogger(AppSchemaDataAccess.class);
    private Map<Name, FeatureTypeMapping> mappings = new LinkedHashMap<Name, FeatureTypeMapping>();
    private FilterFactory filterFac = CommonFactoryFinder.getFilterFactory(null);
    boolean hidden = false;
    URL url;
    URL parentUrl;

    public AppSchemaDataAccess(Set<FeatureTypeMapping> mappings) throws IOException {
        this(mappings, false);
    }

    public AppSchemaDataAccess(Set<FeatureTypeMapping> mappings, boolean hidden) throws IOException {
        this.hidden = hidden;
        try {
            for (FeatureTypeMapping mapping : mappings) {
                Name name = mapping.getMappingName();
                if (name == null) {
                    name = mapping.getTargetFeature().getName();
                }
                if (this.mappings.containsKey(name) || DataAccessRegistry.hasName(name)) {
                    if (this.isIncludeAndDeepSame(mapping)) {
                        LOGGER.fine("Duplicate mappingName detected, but no error thrown because it comes from an include: " + name);
                        continue;
                    }
                    throw new DataSourceException("Duplicate mappingName or targetElement across FeatureTypeMapping instances detected.\nThey have to be unique, or app-schema doesn't know which one to get.\nPlease check your mapping file(s) with mappingName or targetElement of: " + name);
                }
                this.mappings.put(name, mapping);
                AttributeType type = mapping.getTargetFeature().getType();
                if (type instanceof FeatureType) continue;
                new NonFeatureTypeProxy(type, mapping);
            }
        }
        catch (RuntimeException e) {
            for (FeatureTypeMapping mapping : mappings) {
                mapping.getSource().getDataStore().dispose();
            }
            throw e;
        }
        this.register();
    }

    private boolean isIncludeAndDeepSame(FeatureTypeMapping mapping) {
        if (!Boolean.TRUE.equals(mapping.isInclude())) {
            return false;
        }
        FeatureTypeMapping compareMapping = null;
        Name name = null;
        name = mapping.getMappingName() != null ? mapping.getMappingName() : mapping.getTargetFeature().getName();
        if (name != null) {
            if (this.mappings.containsKey(name)) {
                compareMapping = this.mappings.get(name);
            } else {
                try {
                    if (DataAccessRegistry.hasName(name)) {
                        AppSchemaDataAccess appSchemaDataAccess = (AppSchemaDataAccess)DataAccessRegistry.getDataAccess(name);
                        compareMapping = appSchemaDataAccess.getMappingByName(name);
                    }
                }
                catch (IOException | ClassCastException e) {
                    LOGGER.fine("Could not get mapping from registry for " + name + " while trying to test for duplicates");
                    return false;
                }
            }
            return mapping.equals(compareMapping);
        }
        return false;
    }

    protected void register() {
        DataAccessRegistry.register(this);
    }

    public Name[] getTypeNames() throws IOException {
        Name[] typeNames = new Name[this.mappings.size()];
        int i = 0;
        for (FeatureTypeMapping mapping : this.mappings.values()) {
            typeNames[i] = mapping.getTargetFeature().getName();
            ++i;
        }
        return typeNames;
    }

    public FeatureType getSchema(Name typeName) throws IOException {
        return (FeatureType)this.getMappingByNameOrElement(typeName).getTargetFeature().getType();
    }

    public FeatureTypeMapping getMappingByName(Name typeName) throws IOException {
        FeatureTypeMapping mapping = this.mappings.get(typeName);
        if (mapping == null) {
            throw new DataSourceException(typeName + " not found. Available: " + this.mappings.keySet().toString());
        }
        return mapping;
    }

    public FeatureTypeMapping getMappingByNameOrElement(Name typeName) throws IOException {
        FeatureTypeMapping mapping = this.mappings.get(typeName);
        if (mapping != null) {
            return mapping;
        }
        for (FeatureTypeMapping typeMapping : this.mappings.values()) {
            if (!typeMapping.getTargetFeature().getName().equals((Object)typeName)) continue;
            return typeMapping;
        }
        throw new DataSourceException(typeName + " not found. Available: " + this.mappings.keySet().toString());
    }

    public boolean hasName(Name name) {
        return this.mappings.containsKey(name);
    }

    public boolean hasElement(Name typeName) {
        for (FeatureTypeMapping mapping : this.mappings.values()) {
            if (!mapping.getTargetFeature().getName().equals((Object)typeName)) continue;
            return true;
        }
        return false;
    }

    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        FeatureTypeMapping mapping = this.getMappingByNameOrElement(this.getName(query));
        Query unmappedQuery = this.unrollQuery(query, mapping);
        return mapping.getSource().getBounds(unmappedQuery);
    }

    protected int getCount(Query targetQuery) throws IOException {
        boolean canCount;
        int count = 0;
        FeatureTypeMapping mapping = this.getMappingByNameOrElement(this.getName(targetQuery));
        Object mappedSource = mapping.getSource();
        Filter filter = targetQuery.getFilter();
        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
        filter.accept((FilterVisitor)extractor, null);
        if (AppSchemaDataAccessConfigurator.isJoining()) {
            if (mappedSource instanceof JDBCFeatureSource) {
                mappedSource = new JoiningJDBCFeatureSource((JDBCFeatureSource)mappedSource);
                targetQuery = new JoiningQuery(targetQuery);
            } else if (mappedSource instanceof JDBCFeatureStore) {
                mappedSource = new JoiningJDBCFeatureSource((JDBCFeatureStore)mappedSource);
                targetQuery = new JoiningQuery(targetQuery);
            }
        }
        if (canCount = this.canCount(targetQuery, (FeatureSource)mappedSource, mapping)) {
            Query unrollQuery = this.unrollQuery(targetQuery, mapping);
            if (unrollQuery instanceof JoiningQuery) {
                ((JoiningQuery)unrollQuery).setRootMapping(mapping);
            }
            return mappedSource.getCount(unrollQuery);
        }
        return count;
    }

    private boolean canCount(Query query, FeatureSource mappedSource, FeatureTypeMapping rootMapping) {
        boolean canCount = false;
        if (query.getFilter().equals(Filter.INCLUDE)) {
            canCount = true;
        }
        FilterCapabilities capabilities = null;
        if (mappedSource instanceof JDBCFeatureSource) {
            capabilities = ((JDBCFeatureSource)mappedSource).getDataStore().getFilterCapabilities();
        } else if (mappedSource instanceof JDBCFeatureStore) {
            capabilities = ((JDBCFeatureStore)mappedSource).getDataStore().getFilterCapabilities();
        }
        if (capabilities != null) {
            ComplexFilterSplitter splitter = new ComplexFilterSplitter(capabilities, rootMapping);
            Filter filter = query.getFilter();
            filter.accept((FilterVisitor)splitter, null);
            Filter postFilter = splitter.getFilterPost();
            if (postFilter == null || postFilter.equals(Filter.INCLUDE)) {
                canCount = true;
            } else {
                LOGGER.log(Level.FINE, "Skipping count query due Complex post filter");
            }
        }
        return canCount;
    }

    private Name getName(Query query) {
        if (query.getNamespace() == null) {
            return Types.typeName((String)query.getTypeName());
        }
        return Types.typeName((String)query.getNamespace().toString(), (String)query.getTypeName());
    }

    protected Filter getUnsupportedFilter(String typeName, Filter filter) {
        return Filter.INCLUDE;
    }

    public Query unrollQuery(Query query, FeatureTypeMapping mapping) {
        Query unrolledQuery = Query.ALL;
        FeatureSource<? extends FeatureType, ? extends Feature> source = mapping.getSource();
        if (!Query.ALL.equals((Object)query)) {
            boolean paging;
            Filter complexFilter = query.getFilter();
            Filter unrolledFilter = AppSchemaDataAccess.unrollFilter(complexFilter, mapping);
            Object includeProps = query.getHints().get((Object)Query.INCLUDE_MANDATORY_PROPS);
            List<PropertyName> propNames = this.getSurrogatePropertyNames(query.getProperties(), mapping, includeProps instanceof Boolean && (Boolean)includeProps != false);
            Query newQuery = new Query();
            String name = source.getName().getLocalPart();
            newQuery.setTypeName(name);
            newQuery.setFilter(unrolledFilter);
            newQuery.setProperties(propNames);
            newQuery.setCoordinateSystem(query.getCoordinateSystem());
            newQuery.setCoordinateSystemReproject(query.getCoordinateSystemReproject());
            newQuery.setHandle(query.getHandle());
            newQuery.setMaxFeatures(query.getMaxFeatures());
            newQuery.setStartIndex(query.getStartIndex());
            ArrayList<SortBy> sort = new ArrayList<SortBy>();
            if (query.getSortBy() != null) {
                for (SortBy sortBy : query.getSortBy()) {
                    List<Expression> expressions = this.unrollProperty(sortBy.getPropertyName(), mapping);
                    for (Expression expr : expressions) {
                        if (expr == null) continue;
                        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
                        expr.accept((ExpressionVisitor)extractor, null);
                        for (String att : extractor.getAttributeNameSet()) {
                            sort.add((SortBy)new SortByImpl(this.filterFac.property(att), sortBy.getSortOrder()));
                        }
                    }
                }
            }
            if (query instanceof JoiningQuery) {
                FilterAttributeExtractor extractor = new FilterAttributeExtractor();
                mapping.getFeatureIdExpression().accept((ExpressionVisitor)extractor, null);
                if (!Expression.NIL.equals(mapping.getFeatureIdExpression()) && !(mapping.getFeatureIdExpression() instanceof Literal) && extractor.getAttributeNameSet().isEmpty()) {
                    String ns = mapping.namespaces.getPrefix(mapping.getTargetFeature().getName().getNamespaceURI());
                    String separator = mapping.getTargetFeature().getName().getSeparator();
                    String typeName = mapping.getTargetFeature().getLocalName();
                    throw new UnsupportedOperationException(String.format("idExpression '%s' for targetElement '%s%s%s' cannot be translated into SQL, therefore is not supported with joining!\nPlease make sure idExpression is mapped into existing database fields, and only use functions that are supported by your database.\nIf this cannot be helped, you can turn off joining in app-schema.properties file.", mapping.getFeatureIdExpression(), ns, separator, typeName));
                }
                JoiningQuery jQuery = new JoiningQuery(newQuery);
                jQuery.setDenormalised(((JoiningQuery)query).isDenormalised());
                jQuery.setQueryJoins(((JoiningQuery)query).getQueryJoins());
                jQuery.setSubset(((JoiningQuery)query).isSubset());
                for (String att : extractor.getAttributeNameSet()) {
                    sort.add((SortBy)new SortByImpl(this.filterFac.property(att), SortOrder.ASCENDING));
                    jQuery.addId(att);
                }
                unrolledQuery = jQuery;
            } else {
                unrolledQuery = newQuery;
            }
            Integer startIndex = unrolledQuery.getStartIndex();
            boolean bl = paging = startIndex != null && startIndex > -1;
            if (sort.isEmpty() && paging) {
                this.populateSortByFromPrimaryKeys(mapping, sort);
            }
            unrolledQuery.setSortBy(sort.toArray(new SortBy[sort.size()]));
        }
        return unrolledQuery;
    }

    private void populateSortByFromPrimaryKeys(FeatureTypeMapping mappings, List<SortBy> sorts) {
        FeatureSource<? extends FeatureType, ? extends Feature> source = mappings.getSource();
        FeatureType featureType = source.getSchema();
        JDBCDataStore store = null;
        if (source instanceof JDBCFeatureSource) {
            JDBCFeatureSource jdbcSource = (JDBCFeatureSource)source;
            store = jdbcSource.getDataStore();
        } else if (source instanceof JDBCFeatureStore) {
            store = ((JDBCFeatureStore)source).getDataStore();
        }
        if (store != null) {
            try {
                PrimaryKey primaryKey = store.getPrimaryKey((SimpleFeatureType)source.getSchema());
                if (primaryKey != null) {
                    for (PrimaryKeyColumn column : primaryKey.getColumns()) {
                        PropertyName pn = this.filterFac.property(column.getName());
                        if (pn.evaluate((Object)featureType) == null) continue;
                        sorts.add((SortBy)new SortByImpl(pn, SortOrder.ASCENDING));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean matchProperty(XPathUtil.StepList requestedProperty, XPathUtil.StepList target) {
        int minSize = Math.min(requestedProperty.size(), target.size());
        for (int i = 0; i < minSize; ++i) {
            if (((XPathUtil.Step)target.get(i)).getName().equals(((XPathUtil.Step)requestedProperty.get(i)).getName())) continue;
            return false;
        }
        return true;
    }

    public static boolean matchProperty(String requestedProperty, XPathUtil.StepList target) {
        return ((XPathUtil.Step)target.get(0)).getName().getLocalPart().equals(requestedProperty);
    }

    private List<PropertyName> getSurrogatePropertyNames(List<PropertyName> requestedProperties, FeatureTypeMapping mapping, boolean includeMandatory) {
        ArrayList<PropertyName> propNames = new ArrayList<PropertyName>();
        AttributeDescriptor targetDescriptor = mapping.getTargetFeature();
        if (requestedProperties != null && !requestedProperties.isEmpty()) {
            FeatureType mappedType;
            requestedProperties = new ArrayList<PropertyName>(requestedProperties);
            HashSet<PropertyName> requestedSurrogateProperties = new HashSet<PropertyName>();
            for (CustomSourceDataStore extension : CustomSourceDataStore.loadExtensions()) {
                List<PropertyName> contributedProperties = extension.getSurrogatePropertyNames(requestedProperties, mapping);
                if (contributedProperties == null) continue;
                propNames.addAll(contributedProperties);
            }
            List<AttributeMapping> attMappings = mapping.getAttributeMappings();
            requestedProperties.add(this.filterFac.property(mapping.getTargetFeature().getName()));
            try {
                mappedType = mapping.getSource().getSchema();
            }
            catch (UnsupportedOperationException e) {
                mappedType = null;
            }
            for (AttributeMapping entry : attMappings) {
                PropertyName targetProp;
                Object descr;
                XPathUtil.StepList targetSteps = entry.getTargetXPath();
                boolean addThis = false;
                if (includeMandatory && (descr = (targetProp = this.filterFac.property(targetSteps.toString(), mapping.getNamespaces())).evaluate((Object)targetDescriptor.getType())) instanceof PropertyDescriptor && ((PropertyDescriptor)descr).getMinOccurs() >= 1) {
                    addThis = true;
                }
                if (!addThis) {
                    targetProp = requestedProperties.iterator();
                    while (targetProp.hasNext()) {
                        XPathUtil.StepList requestedPropertySteps;
                        PropertyName requestedProperty = (PropertyName)targetProp.next();
                        if ("__DEFAULT_GEOMETRY__".equals(requestedProperty.getPropertyName())) {
                            String defGeomPath = mapping.getDefaultGeometryXPath();
                            requestedProperty = this.filterFac.property(defGeomPath, mapping.getNamespaces());
                        }
                        if (!((requestedPropertySteps = requestedProperty.getNamespaceContext() == null ? XPath.steps((AttributeDescriptor)targetDescriptor, (String)requestedProperty.getPropertyName(), (NamespaceSupport)mapping.getNamespaces()) : XPath.steps((AttributeDescriptor)targetDescriptor, (String)requestedProperty.getPropertyName(), (NamespaceSupport)requestedProperty.getNamespaceContext())) == null ? AppSchemaDataAccess.matchProperty(requestedProperty.getPropertyName(), targetSteps) : AppSchemaDataAccess.matchProperty(requestedPropertySteps, targetSteps))) continue;
                        addThis = true;
                        break;
                    }
                }
                if (!addThis) continue;
                Expression sourceExpression = entry.getSourceExpression();
                Expression idExpression = entry.getIdentifierExpression();
                Collection<Expression> clientProperties = entry.getClientProperties().values();
                FilterAttributeExtractor extractor = new FilterAttributeExtractor();
                sourceExpression.accept((ExpressionVisitor)extractor, null);
                idExpression.accept((ExpressionVisitor)extractor, null);
                if (entry instanceof NestedAttributeMapping) {
                    Expression linkFieldExpression = ((NestedAttributeMapping)entry).nestedFeatureType;
                    linkFieldExpression.accept((ExpressionVisitor)extractor, null);
                }
                Iterator<Expression> it = clientProperties.iterator();
                while (it.hasNext()) {
                    it.next().accept((ExpressionVisitor)extractor, null);
                }
                Set exprAtts = extractor.getAttributeNameSet();
                for (String mappedAtt : exprAtts) {
                    if (mappedAtt.equals("Expression.NIL")) continue;
                    if (mappedType == null) {
                        requestedSurrogateProperties.add(this.filterFac.property(mappedAtt));
                        continue;
                    }
                    PropertyName propExpr = this.filterFac.property(mappedAtt);
                    Object object = propExpr.evaluate((Object)mappedType);
                    AttributeDescriptor mappedAttribute = (AttributeDescriptor)object;
                    if (mappedAttribute != null) {
                        requestedSurrogateProperties.add(this.filterFac.property(mappedAtt));
                        continue;
                    }
                    LOGGER.info("mapped type does not contains property " + mappedAtt);
                }
                LOGGER.fine("adding atts needed for : " + exprAtts);
            }
            propNames.addAll(requestedSurrogateProperties);
        }
        return propNames.isEmpty() ? null : propNames;
    }

    private List<Expression> unrollProperty(PropertyName property, FeatureTypeMapping mapping) {
        AttributeDescriptor targetDescriptor = mapping.getTargetFeature();
        XPathUtil.StepList propertySteps = XPath.steps((AttributeDescriptor)targetDescriptor, (String)property.getPropertyName(), (NamespaceSupport)mapping.getNamespaces());
        return mapping.findMappingsFor(propertySteps, true);
    }

    public static Filter unrollFilter(Filter complexFilter, FeatureTypeMapping mapping) {
        UnmappingFilterVisitor visitor = UnmappingFilterVisitorFactory.getInstance(mapping);
        Filter unrolledFilter = (Filter)complexFilter.accept((FilterVisitor)visitor, null);
        return unrolledFilter;
    }

    public void dispose() {
        DataAccessRegistry.unregister(this);
        for (FeatureTypeMapping mapping : this.mappings.values()) {
            mapping.getSource().getDataStore().dispose();
        }
        this.mappings.clear();
    }

    public ServiceInfo getInfo() {
        throw new UnsupportedOperationException();
    }

    public List<Name> getNames() {
        LinkedList<Name> names = new LinkedList<Name>();
        names.addAll(this.mappings.keySet());
        return names;
    }

    public void createSchema(FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FeatureSource<FeatureType, Feature> getFeatureSource(Name typeName) throws IOException {
        return new MappingFeatureSource(this, this.getMappingByNameOrElement(typeName));
    }

    public void updateSchema(Name typeName, FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void removeSchema(Name typeName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FeatureSource<FeatureType, Feature> getFeatureSourceByName(Name typeName) throws IOException {
        return new MappingFeatureSource(this, this.getMappingByName(typeName));
    }

    public Feature findFeature(FeatureId id, Hints hints) throws IOException {
        for (Map.Entry<Name, FeatureTypeMapping> mapping : this.mappings.entrySet()) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            Id filter = this.filterFac.id(new FeatureId[]{id});
            FeatureCollection<FeatureType, Feature> fCollection = new MappingFeatureSource(this, mapping.getValue()).getFeatures((Filter)filter, hints);
            FeatureIterator iterator = fCollection.features();
            try {
                if (!iterator.hasNext()) continue;
                Feature feature = iterator.next();
                return feature;
            }
            finally {
                if (iterator == null) continue;
                iterator.close();
            }
        }
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getParentUrl() {
        return this.parentUrl;
    }
}

