/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.feature;

import java.util.logging.Logger;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.FeatureFactory;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyType;
import org.geotools.data.complex.config.NonFeatureTypeProxy;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.util.logging.Logging;

public class AppSchemaAttributeBuilder
extends AttributeBuilder {
    private static final Logger LOGGER = Logging.getLogger(AppSchemaAttributeBuilder.class);

    public AppSchemaAttributeBuilder(FeatureFactory attributeFactory) {
        super(attributeFactory);
    }

    public Attribute add(String id, Object value, Name name, AttributeType type) {
        Object descriptor = this.attributeDescriptor(name);
        AttributeType declaredType = descriptor.getType();
        if (!declaredType.equals(type)) {
            boolean argIsSubType = Types.isSuperType((PropertyType)type, (PropertyType)declaredType);
            if (!argIsSubType) {
                LOGGER.fine("Adding attribute " + name + " of type " + type.getName() + " which is not a subtype of " + declaredType.getName());
            }
            int minOccurs = descriptor.getMinOccurs();
            int maxOccurs = descriptor.getMaxOccurs();
            boolean nillable = descriptor.isNillable();
            Object defaultValue = null;
            descriptor = type instanceof GeometryType ? new GeometryDescriptorImpl((GeometryType)type, name, minOccurs, maxOccurs, nillable, defaultValue) : new AttributeDescriptorImpl(type, name, minOccurs, maxOccurs, nillable, defaultValue);
        }
        Object attribute = descriptor != null && descriptor.getType() instanceof NonFeatureTypeProxy ? this.createComplexAttribute(value, null, (AttributeDescriptor)descriptor, id) : this.create(value, null, (AttributeDescriptor)descriptor, id);
        this.properties().add(attribute);
        return attribute;
    }
}

