/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.filter.Filter;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.IndexQueryManager;
import org.geotools.data.complex.IndexedMappingFeatureIterator;
import org.geotools.data.complex.PartialIndexedMappingFeatureIterator;
import org.geotools.data.complex.TotalIndexedMappingFeatureIterator;

public class IndexedMappingFeatureIteratorFactory {
    protected final AppSchemaDataAccess store;
    protected final FeatureTypeMapping mapping;
    protected final Query query;
    protected final Filter unrolledFilter;
    protected final Transaction transaction;
    private IndexQueryManager indexModeProcessor;

    public IndexedMappingFeatureIteratorFactory(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Filter unrolledFilter, Transaction transaction) {
        this.store = store;
        this.mapping = mapping;
        this.query = query;
        this.unrolledFilter = unrolledFilter;
        this.transaction = transaction;
        this.indexModeProcessor = new IndexQueryManager(mapping, query);
    }

    public IndexedMappingFeatureIterator buildInstance() {
        if (this.indexModeProcessor.getIndexMode().equals((Object)IndexQueryManager.QueryIndexCoverage.NONE)) {
            return null;
        }
        if (this.indexModeProcessor.getIndexMode().equals((Object)IndexQueryManager.QueryIndexCoverage.PARTIAL)) {
            return new PartialIndexedMappingFeatureIterator(this.store, this.mapping, this.query, this.unrolledFilter, this.transaction, this.indexModeProcessor);
        }
        return new TotalIndexedMappingFeatureIterator(this.store, this.mapping, this.query, this.unrolledFilter, this.transaction, this.indexModeProcessor);
    }

    public IndexQueryManager getIndexModeProcessor() {
        return this.indexModeProcessor;
    }
}

