/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.parameter.Parameter;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class ToEnvelopeFunction
implements Function {
    private final List<Expression> parameters;
    private final Literal fallback;
    public static final FunctionName NAME = new FunctionNameImpl("ToEnvelope", FunctionNameImpl.parameter((String)"return", Envelope.class), new Parameter[]{FunctionNameImpl.parameter((String)"parameter", Object.class, (int)2, (int)5)});

    public ToEnvelopeFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public ToEnvelopeFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public String getName() {
        return NAME.getName();
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Object.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        boolean crsexists = false;
        Envelope envelope = null;
        ReferencedEnvelope refenvelope = null;
        CoordinateReferenceSystem sourceCRS = null;
        if (this.parameters.size() <= 3) {
            Expression x = this.parameters.get(0);
            Expression y = this.parameters.get(1);
            double xvalue = (Double)x.evaluate(object, Double.class);
            double yvalue = (Double)y.evaluate(object, Double.class);
            if (this.parameters.size() == 3) {
                crsexists = true;
                Expression crs = this.parameters.get(2);
                String crsvalue = (String)crs.evaluate(object, String.class);
                try {
                    sourceCRS = CRS.decode((String)crsvalue);
                }
                catch (NoSuchAuthorityCodeException e) {
                    throw new IllegalArgumentException("Invalid or unsupported SRS name detected for toEnvelope function: " + crsvalue + ". Cause: " + e.getMessage());
                }
                catch (FactoryException e) {
                    throw new RuntimeException("Unable to decode SRS name. Cause: " + e.getMessage());
                }
            }
            Coordinate coordinate = new Coordinate(xvalue, yvalue);
            envelope = new Envelope(coordinate);
            if (crsexists) {
                refenvelope = new ReferencedEnvelope(envelope, sourceCRS);
            }
        } else {
            Expression minx = this.parameters.get(0);
            Expression maxx = this.parameters.get(1);
            Expression miny = this.parameters.get(2);
            Expression maxy = this.parameters.get(3);
            double minxvalue = (Double)minx.evaluate(object, Double.class);
            double minyvalue = (Double)miny.evaluate(object, Double.class);
            double maxxvalue = (Double)maxx.evaluate(object, Double.class);
            double maxyvalue = (Double)maxy.evaluate(object, Double.class);
            if (this.parameters.size() == 5) {
                crsexists = true;
                Expression crs = this.parameters.get(4);
                String crsvalue = (String)crs.evaluate(object, String.class);
                try {
                    sourceCRS = CRS.decode((String)crsvalue);
                }
                catch (NoSuchAuthorityCodeException e) {
                    throw new IllegalArgumentException("Invalid or unsupported SRS name detected for toEnvelope function: " + crsvalue + ". Cause: " + e.getMessage());
                }
                catch (FactoryException e) {
                    throw new RuntimeException("Unable to decode SRS name. Cause: " + e.getMessage());
                }
            }
            envelope = new Envelope(minxvalue, maxxvalue, minyvalue, maxyvalue);
            if (crsexists) {
                refenvelope = new ReferencedEnvelope(envelope, sourceCRS);
            }
        }
        if (crsexists) {
            return (T)Converters.convert((Object)refenvelope, context);
        }
        return (T)Converters.convert((Object)envelope, context);
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }
}

