/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter;

import org.geotools.api.feature.Attribute;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.parameter.Parameter;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class AsMultiGeometryFunctionExpression
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("asMultiGeometry", FunctionNameImpl.parameter((String)"multi-geometry", Geometry.class), new Parameter[]{FunctionNameImpl.parameter((String)"geometry", Geometry.class)});

    public AsMultiGeometryFunctionExpression() {
        super(NAME);
    }

    public Object evaluate(Object obj) {
        if (!(obj instanceof Attribute)) {
            return null;
        }
        Attribute att = (Attribute)obj;
        Expression arg = (Expression)this.getParameters().get(0);
        Object value = arg.evaluate((Object)att);
        if (value != null) {
            if (value instanceof Geometry) {
                if (value instanceof GeometryCollection) {
                    return value;
                }
                return this.wrap((Geometry)value);
            }
            throw new IllegalArgumentException("function argument did not evaluate to " + Geometry.class);
        }
        return null;
    }

    private GeometryCollection wrap(Geometry geometry) {
        if (geometry instanceof Point) {
            return geometry.getFactory().createMultiPoint(new Point[]{(Point)geometry});
        }
        if (geometry instanceof LineString) {
            return geometry.getFactory().createMultiLineString(new LineString[]{(LineString)geometry});
        }
        if (geometry instanceof Polygon) {
            return geometry.getFactory().createMultiPolygon(new Polygon[]{(Polygon)geometry});
        }
        throw new IllegalArgumentException("Unable to create multi geometry from " + geometry);
    }
}

