/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.Name;
import org.geotools.data.DataUtilities;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.http.HttpStaticServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public final class HttpConfigTest {
    private static final HttpStaticServer HTTP_SERVER = new HttpStaticServer();
    private static final File APP_SCHEMA_CACHE_DIR = new File(FileUtils.getTempDirectory(), "app-schema-cache");
    private static final boolean LINUX_GITHUB_BUILD = Boolean.getBoolean("linux-github-build");

    @BeforeClass
    public static void setup() {
        if (LINUX_GITHUB_BUILD) {
            return;
        }
        System.setProperty("schema.cache.dir", APP_SCHEMA_CACHE_DIR.getPath());
        HTTP_SERVER.start();
        HTTP_SERVER.putResource("measurements_http_includes.xml", "/test-data/http/measurements_http_includes.xml");
        HTTP_SERVER.putResource("measurements_relative_includes.xml", "/test-data/http/measurements_relative_includes.xml");
        HTTP_SERVER.putResource("stations_http_includes.xml", "/test-data/http/stations_http_includes.xml");
        HTTP_SERVER.putResource("stations_relative_includes.xml", "/test-data/http/stations_relative_includes.xml");
        HTTP_SERVER.putResource("stations.xsd", "/test-data/http/stations.xsd");
    }

    @AfterClass
    public static void teardown() {
        try {
            HTTP_SERVER.stop();
        }
        finally {
            FileUtils.deleteQuietly((File)APP_SCHEMA_CACHE_DIR);
        }
    }

    @Test
    public void testHttpIncludes() throws Exception {
        Assume.assumeFalse((boolean)LINUX_GITHUB_BUILD);
        this.testHttpMapping("stations_http_includes.xml");
    }

    @Test
    public void testRelativeIncludes() throws Exception {
        Assume.assumeFalse((boolean)LINUX_GITHUB_BUILD);
        this.testHttpMapping("stations_relative_includes.xml");
    }

    private void testHttpMapping(String mappingFileName) throws Exception {
        AppSchemaDataAccess store = HttpConfigTest.buildAppSchemaDataStore(mappingFileName);
        MatcherAssert.assertThat((Object)store.getTypeNames().length, (Matcher)CoreMatchers.is((Object)1));
        NameImpl name = new NameImpl("http://www.stations.org/1.0", "Station");
        MatcherAssert.assertThat((Object)store.getTypeNames()[0], (Matcher)CoreMatchers.is((Object)name));
        List features = DataUtilities.list((FeatureCollection)store.getFeatureSource((Name)name).getFeatures());
        MatcherAssert.assertThat((Object)features.size(), (Matcher)CoreMatchers.is((Object)3));
        for (Feature feature : features) {
            NameImpl measurements = new NameImpl("http://www.stations.org/1.0", "measurements");
            Property property = feature.getProperty((Name)measurements);
            MatcherAssert.assertThat((Object)property.getValue(), (Matcher)CoreMatchers.instanceOf(List.class));
            List values = (List)property.getValue();
            Assert.assertFalse((boolean)values.isEmpty());
        }
    }

    public static void runHttpStaticServer() {
        HttpConfigTest.setup();
        HTTP_SERVER.join();
    }

    private static AppSchemaDataAccess buildAppSchemaDataStore(String mappingsName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dbtype", "app-schema");
        parameters.put("url", HTTP_SERVER.buildUrl(mappingsName));
        try {
            DataAccess dataAccess = DataAccessFinder.getDataStore(parameters);
            return (AppSchemaDataAccess)dataAccess;
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Error build App-Schema data store for mappings '%s'.", mappingsName), exception);
        }
    }
}

